/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.fastcapture;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class ToggleTextAlignmentButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID_LEFT = "com.thinkbuzan.gaia.actions.TextAlignStartAction";
    private static final String ACTION_ID_RIGHT = "com.thinkbuzan.gaia.actions.TextAlignEndAction";
    private static final String ACTION_ID_CENTRE = "com.thinkbuzan.gaia.actions.TextAlignCentreAction";
    private static final String IMAGE_PATH_LEFT = "fastcapture/align_left.png";
    private static final String IMAGE_PATH_RIGHT = "fastcapture/align_right.png";
    private static final String IMAGE_PATH_CENTRE = "fastcapture/align_centre.png";
    private static final String IMAGE_PATH_FULL = "fastcapture/align_full.png";
    private static final HashMap<UUID, SelectionListener> listenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.align");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.align");
    private static final String CENTRE = "alignLabelMiddle";
    private static final String LEFT = "alignLabelStart";
    private static final String RIGHT = "alignLabelEnd";
    private static final String FULL = "labelSpaced";
    private String currentSetting;

    public ToggleTextAlignmentButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH_LEFT, 30), ResourceManager.getImageIcon(IMAGE_PATH_LEFT, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setEnabled(false);
        this.setIcon(CENTRE);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (ToggleTextAlignmentButton.this.currentSetting.equals(ToggleTextAlignmentButton.LEFT)) {
                    ServiceManager.getActionManager().runAction(ToggleTextAlignmentButton.ACTION_ID_CENTRE, new Object[0]);
                    ToggleTextAlignmentButton.this.setIcon(ToggleTextAlignmentButton.CENTRE);
                } else if (ToggleTextAlignmentButton.this.currentSetting.equals(ToggleTextAlignmentButton.CENTRE)) {
                    ServiceManager.getActionManager().runAction(ToggleTextAlignmentButton.ACTION_ID_RIGHT, new Object[0]);
                    ToggleTextAlignmentButton.this.setIcon(ToggleTextAlignmentButton.RIGHT);
                } else if (ToggleTextAlignmentButton.this.currentSetting.equals(ToggleTextAlignmentButton.RIGHT)) {
                    ServiceManager.getActionManager().runAction(ToggleTextAlignmentButton.ACTION_ID_LEFT, new Object[0]);
                    ToggleTextAlignmentButton.this.setIcon(ToggleTextAlignmentButton.LEFT);
                } else if (ToggleTextAlignmentButton.this.currentSetting.equals(ToggleTextAlignmentButton.FULL)) {
                    ServiceManager.getActionManager().runAction(ToggleTextAlignmentButton.ACTION_ID_LEFT, new Object[0]);
                    ToggleTextAlignmentButton.this.setIcon(ToggleTextAlignmentButton.LEFT);
                }
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                ToggleTextAlignmentButton.this.initialise();
            }
        });
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!listenerMap.containsKey(editor.getId())) {
                            SelectionListener listener = ToggleTextAlignmentButton.this.getListener(editor);
                            editor.addSelectionListener(listener);
                            listenerMap.put(editor.getId(), listener);
                        }
                        ToggleTextAlignmentButton.this.setEnabled(true);
                    } else {
                        ToggleTextAlignmentButton.this.setEnabled(false);
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && listenerMap.containsKey(editor.getId())) {
                        editor.removeSelectionListener((SelectionListener)listenerMap.get(editor.getId()));
                        listenerMap.remove(editor.getId());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIcon(final String flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToggleTextAlignmentButton.this.currentSetting = flag;
                    switch (flag) {
                        case "alignLabelEnd": {
                            ToggleTextAlignmentButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleTextAlignmentButton.IMAGE_PATH_RIGHT, 30));
                            break;
                        }
                        case "alignLabelStart": {
                            ToggleTextAlignmentButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleTextAlignmentButton.IMAGE_PATH_LEFT, 30));
                            break;
                        }
                        case "alignLabelMiddle": {
                            ToggleTextAlignmentButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleTextAlignmentButton.IMAGE_PATH_CENTRE, 30));
                            break;
                        }
                        case "labelSpaced": {
                            ToggleTextAlignmentButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(ToggleTextAlignmentButton.IMAGE_PATH_FULL, 30));
                        }
                    }
                }
            });
        }
    }

    private SelectionListener getListener(IEditorView editor) {
        return new SelectionListener(){

            public void selectionChanged(Object ... selComps) {
                if (selComps != null && selComps.length > 0) {
                    Object cell = selComps[0];
                    String cellString = cell.toString();
                    String[] props = cellString.split(";");
                    boolean useDefault = true;
                    for (String prop : props) {
                        String[] keyValue;
                        if (!prop.startsWith("branchLabelAlign") || (keyValue = prop.split("=")) == null || keyValue.length <= 1) continue;
                        String value = keyValue[1];
                        int commaIndex = value.indexOf(",");
                        if (commaIndex >= 0) {
                            value = value.substring(0, commaIndex);
                        }
                        ToggleTextAlignmentButton.this.setIcon(value);
                        useDefault = false;
                    }
                    if (useDefault) {
                        ToggleTextAlignmentButton.this.setIcon(ToggleTextAlignmentButton.CENTRE);
                    }
                }
            }
        };
    }
}

