/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.home;

import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.CustomJMenuItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.CurrentPresentationChangedListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.PresentationsChangedListener;
import com.thinkbuzan.pascal.services.presentation.model.IPresentation;
import com.thinkbuzan.pascal.services.ui.IMainFrame;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PresentationViewButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String LICENSE_ID = "com.thinkbuzan.license.gaia.presentationview";
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.PresentationViewAction";
    private static final String NEW_ACTION = "com.thinkbuzan.gaia.actions.NewPresentationAction";
    private static final String IMAGE_PATH = "views/present-22px.png";
    private final HashMap<UUID, PresentationsChangedListener> _listenerMap = new HashMap();
    private final HashMap<UUID, CurrentPresentationChangedListener> _currentListenerMap = new HashMap();
    private final HashMap<UUID, IViewListener> _viewListenerMap = new HashMap();
    private boolean noPresentations = true;
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.presentation");
    private static final String NEW_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.presentation.new");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.presentation.title");

    public PresentationViewButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 22), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 22), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setPopup(this.createPresentationPopup());
    }

    private JPopupMenu createPresentationPopup() {
        JPopupMenu presentationPopup = new JPopupMenu();
        presentationPopup.setBackground(Color.white);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        if (editor != null) {
                            PresentationsChangedListener listener;
                            if (!PresentationViewButton.this._listenerMap.containsKey(editor.getId())) {
                                listener = PresentationViewButton.this.getPresentationsChangedListener();
                                editor.addPresentationsChangedListener(listener);
                                PresentationViewButton.this._listenerMap.put(editor.getId(), listener);
                            }
                            if (!PresentationViewButton.this._currentListenerMap.containsKey(editor.getId())) {
                                listener = PresentationViewButton.this.getCurrentPresentationChangedListener();
                                editor.addCurrentPresentationChangedListener((CurrentPresentationChangedListener)listener);
                                PresentationViewButton.this._currentListenerMap.put(editor.getId(), listener);
                            }
                            if (!PresentationViewButton.this._viewListenerMap.containsKey(editor.getId())) {
                                listener = PresentationViewButton.this.getListener(editor);
                                editor.addViewTypeListener((IViewListener)listener);
                                PresentationViewButton.this._viewListenerMap.put(editor.getId(), listener);
                            }
                            PresentationViewButton.this.setEnabled(PresentationViewButton.this.isViewSupported(editor.getView().getId()));
                            PresentationViewButton.this.populatePopup(editor.getPresentations());
                        }
                    }
                });
            }
        });
        return presentationPopup;
    }

    private void populatePopup(List<IPresentation> presentations) {
        JPopupMenu popup = this.getPopup();
        popup.removeAll();
        this.noPresentations = true;
        if (presentations != null) {
            for (final IPresentation presentation : presentations) {
                this.noPresentations = false;
                CustomJMenuItem menuItem = new CustomJMenuItem(presentation.getName());
                menuItem.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServiceManager.getActionManager().runAction(PresentationViewButton.ACTION_ID, new Object[]{presentation.getID().toString()});
                    }
                });
                popup.add(menuItem);
            }
            JSeparator separator = new JSeparator(0);
            popup.add(separator);
        }
        CustomJMenuItem newButton = new CustomJMenuItem(NEW_BUTTON_TEXT);
        newButton.setIcon(ResourceManager.getImageIcon("presentation/presentation-new-15px.png", 15));
        newButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(PresentationViewButton.NEW_ACTION, new Object[0]);
            }
        });
        popup.add(newButton);
        if (this.noPresentations) {
            this.setCommand(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ServiceManager.getActionManager().runAction(PresentationViewButton.NEW_ACTION, new Object[0]);
                    return null;
                }
            });
        } else {
            this.setPopupCommand();
        }
    }

    private PresentationsChangedListener getPresentationsChangedListener() {
        return new PresentationsChangedListener(){

            public void presentationsChanged(List<IPresentation> presentations) {
                PresentationViewButton.this.populatePopup(presentations);
            }
        };
    }

    private CurrentPresentationChangedListener getCurrentPresentationChangedListener() {
        return new CurrentPresentationChangedListener(){

            public void currentPresentationChanged(IPresentation presentation) {
                ((IMainFrame)MainFrameUtilities.getMainFrame()).setPresentationName(presentation.getName());
            }
        };
    }

    private IViewListener getListener(IEditorView editor) {
        return new IViewListener(){

            public void viewChanged(String viewID) {
                PresentationViewButton.this.setEnabled(PresentationViewButton.this.isViewSupported(viewID));
            }
        };
    }

    private boolean isViewSupported(String viewID) {
        return viewID.equals("com.thinkbuzan.gaia.view.mindmap.MindMapView") || viewID.equals("com.thinkbuzan.gaia.view.threed.ThreeDView");
    }

    public String getLicenseId() {
        return LICENSE_ID;
    }
}

