/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.home;

import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.CustomJMenuItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class SelectButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.SelectAllAction";
    private static final String IMAGE_PATH = "home/select-15px.png";
    private static final String SELECT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.select");
    private static final String SELECT_ALL_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.selectAll");
    private static final String INVERT_SELECTION_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.invertSelection");
    private static final String SELECT_DESCENDANTS_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.selectDescendants");

    public SelectButton() {
        super(SELECT_BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 15), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 15), SelectButton.createSelectMenu());
        this.setToolTipText(SELECT_BUTTON_TEXT);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private static JPopupMenu createSelectMenu() {
        JPopupMenu branchMenu = new JPopupMenu();
        branchMenu.setBackground(Color.white);
        ActionListener selectDescendants = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SelectDescendantsAction", new Object[0]);
            }
        };
        ActionListener selectInvert = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.InvertSelectionAction", new Object[0]);
            }
        };
        ActionListener selectAll = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(SelectButton.ACTION_ID, new Object[0]);
            }
        };
        CustomJMenuItem selectAllButton = new CustomJMenuItem(SELECT_ALL_BUTTON_TEXT);
        selectAllButton.setIcon(ResourceManager.getImageIcon("home/select-all-15px.png", 15));
        selectAllButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectAllButton.addActionListener(selectAll);
        branchMenu.add(selectAllButton);
        CustomJMenuItem selectInvertButton = new CustomJMenuItem(INVERT_SELECTION_BUTTON_TEXT);
        selectInvertButton.setIcon(ResourceManager.getImageIcon("home/select-invert-15px.png", 15));
        selectInvertButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectInvertButton.addActionListener(selectInvert);
        branchMenu.add(selectInvertButton);
        CustomJMenuItem selectDescendentsButton = new CustomJMenuItem(SELECT_DESCENDANTS_TEXT);
        selectDescendentsButton.setIcon(ResourceManager.getImageIcon("home/select-descend-15px.png", 15));
        selectDescendentsButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectDescendentsButton.addActionListener(selectDescendants);
        branchMenu.add(selectDescendentsButton);
        return branchMenu;
    }
}

