/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.home;

import com.thinkbuzan.apollo.ui.win.frame.ui.LargeToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class TDViewButton
extends LargeToggleButton {
    private static final long serialVersionUID = 1L;
    private static final String TD_ACTION_ID = "com.thinkbuzan.gaia.actions.ThreeDViewAction";
    private static final String MM_ACTION_ID = "com.thinkbuzan.gaia.actions.MindMapViewAction";
    private static final String IMAGE_PATH = "home/view-3d-mindmap-30px.png";
    private static final HashMap<UUID, IViewListener> listenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.presentationview.homemenu.3DItem.label");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.3d.title");

    public TDViewButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        final Callable<Void> tdAction = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(TDViewButton.TD_ACTION_ID, new Object[0]);
                return null;
            }
        };
        final Callable<Void> mmAction = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(TDViewButton.MM_ACTION_ID, new Object[0]);
                return null;
            }
        };
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                TDViewButton.this.initialise(tdAction, mmAction);
            }
        });
        this.setCommand(tdAction);
        ServiceManager.getActionManager().hookActionStateListener(TD_ACTION_ID, (JComponent)((Object)this));
    }

    private void initialise(final Callable<Void> tdAction, final Callable<Void> mmAction) {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!listenerMap.containsKey(editor.getId())) {
                            IViewListener listener = TDViewButton.this.getListener(editor, tdAction, mmAction);
                            editor.addViewTypeListener(listener);
                            listenerMap.put(editor.getId(), listener);
                        }
                        TDViewButton.this.updateSelection(editor, editor.getView().getId(), tdAction, mmAction);
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && listenerMap.containsKey(editor.getId())) {
                        editor.removeViewTypeListener((IViewListener)listenerMap.get(editor.getId()));
                        listenerMap.remove(editor.getId());
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Failed to add initialise 3D button");
        }
    }

    private IViewListener getListener(final IEditorView editor, final Callable<Void> tdAction, final Callable<Void> mmAction) {
        return new IViewListener(){

            public void viewChanged(String viewID) {
                TDViewButton.this.updateSelection(editor, viewID, tdAction, mmAction);
            }
        };
    }

    private void updateSelection(IEditorView editor, String viewID, Callable<Void> tdAction, Callable<Void> mmAction) {
        boolean is3DView = viewID.equals("com.thinkbuzan.gaia.view.threed.ThreeDView");
        this.setSelected(is3DView);
        if (is3DView) {
            this.setCommand(mmAction);
        } else {
            this.setCommand(tdAction);
        }
    }
}

