/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.layout;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.CustomJMenuItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.CondenseSettingsListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.StateToggleListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class AutoCondenseButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String LICENSE_ID = "com.thinkbuzan.license.gaia.smartlayout";
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.SetAutoLayoutCondenseOptionAction";
    private static final String IMAGE_PATH = "layout/auto-condense-15px.png";
    private static final HashMap<UUID, StateToggleListener> layoutListenerMap = new HashMap();
    private static final HashMap<UUID, CondenseSettingsListener> condenseSettingsListenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.condense");
    private static final String OFF_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.autocondense.off");
    private static final String PARTIAL_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.autocondense.partial");
    private static final String FULL_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.autocondense.full");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.condense");
    private static final Color SELECTED_SETTING_COLOUR = Color.decode("#ececec");
    private static transient JMenuItem offButton;
    private static transient JMenuItem partialButton;
    private static transient JMenuItem fullButton;

    public AutoCondenseButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 15), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 15), AutoCondenseButton.createAutoCondenseMenu());
        this.setToolTipText(TOOL_TIP_TEXT);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                AutoCondenseButton.this.initialise();
            }
        });
    }

    private StateToggleListener getStateListener() {
        return new StateToggleListener(){

            public void toggleStateChanged(boolean oldSetting, boolean newSetting) {
                AutoCondenseButton.this.setEnabled(newSetting);
            }
        };
    }

    private CondenseSettingsListener getCondenseSettingsListener() {
        return new CondenseSettingsListener(){

            public void condenseSettingsChanged(boolean condenseOn, boolean condenseAllOn) {
                if (!condenseOn) {
                    AutoCondenseButton.this.setOffCondenseColours();
                } else if (condenseOn && !condenseAllOn) {
                    AutoCondenseButton.this.setPartialCondenseColours();
                } else if (condenseOn && condenseAllOn) {
                    AutoCondenseButton.this.setFullCondenseColours();
                }
            }
        };
    }

    private void setOffCondenseColours() {
        offButton.setBackground(SELECTED_SETTING_COLOUR);
        partialButton.setBackground(Color.white);
        fullButton.setBackground(Color.white);
    }

    private void setPartialCondenseColours() {
        offButton.setBackground(Color.white);
        partialButton.setBackground(SELECTED_SETTING_COLOUR);
        fullButton.setBackground(Color.white);
    }

    private void setFullCondenseColours() {
        offButton.setBackground(Color.white);
        partialButton.setBackground(Color.white);
        fullButton.setBackground(SELECTED_SETTING_COLOUR);
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        StateToggleListener listener;
                        if (!layoutListenerMap.containsKey(editor.getId())) {
                            listener = AutoCondenseButton.this.getStateListener();
                            editor.addLayoutToggleListener(listener);
                            layoutListenerMap.put(editor.getId(), listener);
                        }
                        if (!condenseSettingsListenerMap.containsKey(editor.getId())) {
                            listener = AutoCondenseButton.this.getCondenseSettingsListener();
                            editor.addCondenseSettingsListener((CondenseSettingsListener)listener);
                            condenseSettingsListenerMap.put(editor.getId(), listener);
                        }
                        switch (editor.getCondenseSettings()) {
                            case OFF: {
                                AutoCondenseButton.this.setOffCondenseColours();
                                break;
                            }
                            case PARTIAL: {
                                AutoCondenseButton.this.setPartialCondenseColours();
                                break;
                            }
                            case FULL: {
                                AutoCondenseButton.this.setFullCondenseColours();
                            }
                        }
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null) {
                        StateToggleListener listener;
                        if (layoutListenerMap.containsKey(editor.getId())) {
                            listener = (StateToggleListener)layoutListenerMap.remove(editor.getId());
                            editor.removeLayoutToggleListener(listener);
                        }
                        if (condenseSettingsListenerMap.containsKey(editor.getId())) {
                            listener = (CondenseSettingsListener)condenseSettingsListenerMap.remove(editor.getId());
                            editor.removeCondenseSettingsListener((CondenseSettingsListener)listener);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JPopupMenu createAutoCondenseMenu() {
        JPopupMenu autoCondenseMenu = CoreUIFactory.createPopupMenu();
        autoCondenseMenu.setBackground(Color.white);
        ActionListener off = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(AutoCondenseButton.ACTION_ID, new Object[]{false, false});
            }
        };
        ActionListener full = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(AutoCondenseButton.ACTION_ID, new Object[]{true, true});
            }
        };
        ActionListener partial = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction(AutoCondenseButton.ACTION_ID, new Object[]{true, false});
            }
        };
        offButton = new CustomJMenuItem(OFF_BUTTON_TEXT);
        offButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        offButton.addActionListener(off);
        autoCondenseMenu.add(offButton);
        partialButton = new CustomJMenuItem(PARTIAL_BUTTON_TEXT);
        partialButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        partialButton.addActionListener(partial);
        autoCondenseMenu.add(partialButton);
        fullButton = new CustomJMenuItem(FULL_BUTTON_TEXT);
        fullButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        fullButton.addActionListener(full);
        autoCondenseMenu.add(fullButton);
        return autoCondenseMenu;
    }

    public String getLicenseId() {
        return LICENSE_ID;
    }
}

