/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.layout;

import com.thinkbuzan.apollo.ui.core.factory.AbstractSliderUI;
import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.MediumRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.StateToggleListener;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class BranchStyleButton
extends MediumRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String LICENSE_ID = "com.thinkbuzan.license.gaia.smartlayout";
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.SetAutoLayoutOrganicOptionAction";
    private static final String IMAGE_PATH = "layout/styles-15px.png";
    private static final HashMap<UUID, StateToggleListener> layoutListenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.organicness");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.organicness");

    public BranchStyleButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 15), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 15), BranchStyleButton.createBranchStyleMenu());
        this.setToolTipText(TOOL_TIP_TEXT);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                BranchStyleButton.this.initialise();
            }
        });
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null && !layoutListenerMap.containsKey(editor.getId())) {
                        StateToggleListener listener = BranchStyleButton.this.getListener();
                        editor.addLayoutToggleListener(listener);
                        layoutListenerMap.put(editor.getId(), listener);
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && layoutListenerMap.containsKey(editor.getId())) {
                        StateToggleListener listener = (StateToggleListener)layoutListenerMap.remove(editor.getId());
                        editor.removeLayoutToggleListener(listener);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private StateToggleListener getListener() {
        return new StateToggleListener(){

            public void toggleStateChanged(boolean oldSetting, boolean newSetting) {
                BranchStyleButton.this.setEnabled(newSetting);
            }
        };
    }

    private static JPopupMenu createBranchStyleMenu() {
        JPopupMenu branchStyleMenu = CoreUIFactory.createPopupMenu();
        branchStyleMenu.setBackground(Color.white);
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new FlowLayout(0, 5, 0));
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel narrowLabel = new JLabel(ResourceManager.getImageIcon("layout/branch-style-curved-15px.png", 15));
        JLabel wideLabel = new JLabel(ResourceManager.getImageIcon("layout/branch-style-linear-15px.png", 15));
        final JSlider slider = new JSlider(0, 5);
        slider.setOpaque(false);
        AbstractSliderUI sliderUI = CoreUIFactory.createSliderUI((JSlider)slider, (boolean)false, (boolean)true);
        sliderUI.setSliderForegroundColour(Color.decode("#0067b0"));
        slider.setUI((SliderUI)sliderUI);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = slider.getValue() == 5 ? 4 : (slider.getValue() == 4 ? 5 : slider.getValue());
                ServiceManager.getActionManager().runAction(BranchStyleButton.ACTION_ID, new Object[]{value});
            }
        });
        p.add(narrowLabel);
        p.add(slider);
        p.add(wideLabel);
        branchStyleMenu.add(p);
        return branchStyleMenu;
    }

    public String getLicenseId() {
        return LICENSE_ID;
    }
}

