/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.layout;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.StateToggleListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class SmartLayoutButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String LICENSE_ID = "com.thinkbuzan.license.gaia.smartlayout";
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.ToggleLayoutEnabledAction";
    private static final String IMAGE_PATH = "layout/smart-layout-30px.png";
    private static final String IMAGE_PATH_OFF = "layout/smart-layout-off-30px.png";
    private static final HashMap<UUID, StateToggleListener> layoutListenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.autoLayout");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.autoLayout.description");

    public SmartLayoutButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setEnabled(false);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(SmartLayoutButton.ACTION_ID, new Object[0]);
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                SmartLayoutButton.this.initialise();
            }
        });
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!layoutListenerMap.containsKey(editor.getId())) {
                            StateToggleListener listener = SmartLayoutButton.this.getListener();
                            editor.addLayoutToggleListener(listener);
                            layoutListenerMap.put(editor.getId(), listener);
                        }
                        SmartLayoutButton.this.setIcon(editor.isLayoutOn());
                        SmartLayoutButton.this.setEnabled(true);
                    } else {
                        SmartLayoutButton.this.setEnabled(false);
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && layoutListenerMap.containsKey(editor.getId())) {
                        StateToggleListener listener = (StateToggleListener)layoutListenerMap.remove(editor.getId());
                        editor.removeLayoutToggleListener(listener);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setIcon(final boolean flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (flag) {
                        SmartLayoutButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(SmartLayoutButton.IMAGE_PATH, 30));
                    } else {
                        SmartLayoutButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(SmartLayoutButton.IMAGE_PATH_OFF, 30));
                    }
                }
            });
        }
    }

    private StateToggleListener getListener() {
        return new StateToggleListener(){

            public void toggleStateChanged(boolean oldSetting, boolean newSetting) {
                SmartLayoutButton.this.setIcon(newSetting);
            }
        };
    }

    public String getLicenseId() {
        return LICENSE_ID;
    }
}

