/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.project;

import com.thinkbuzan.apollo.ui.win.frame.ui.LargeToggleButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorChangeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.ProjectStateListener;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.JComponent;

public class ShowMindMapButton
extends LargeToggleButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.ProjectViewShowMindMapAction";
    private static final String IMAGE_PATH = "project/show-mindmap-30px.png";
    private static final HashMap<UUID, ProjectStateListener> projectListenerMap = new HashMap();
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.projectview.showMap");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.projectview.showMap.description");

    public ShowMindMapButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(ShowMindMapButton.ACTION_ID, new Object[]{!ShowMindMapButton.this.isSelected()});
                return null;
            }
        };
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                ShowMindMapButton.this.initialise();
            }
        });
        this.setCommand(callable);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private void initialise() {
        try {
            ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                public void editorChanged(IEditorView editor) {
                    if (editor != null) {
                        if (!projectListenerMap.containsKey(editor.getId())) {
                            ProjectStateListener listener = ShowMindMapButton.this.getListener();
                            editor.addProjectStateListener(listener);
                            projectListenerMap.put(editor.getId(), listener);
                        }
                        ShowMindMapButton.this.setSelected(editor.isProjectShowMap());
                    }
                }
            });
            ServiceManager.getEditorManager().getEditorTabManager().addEditorChangeListener(new IEditorChangeListener(){

                public void editorRemoved(IEditorView editor) {
                    if (editor != null && projectListenerMap.containsKey(editor.getId())) {
                        ProjectStateListener listener = (ProjectStateListener)projectListenerMap.remove(editor.getId());
                        editor.removeProjectStateListener(listener);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ProjectStateListener getListener() {
        return new ProjectStateListener(){

            public void showMapValueChanged(boolean newValue) {
                ShowMindMapButton.this.setSelected(newValue);
            }

            public void autoScheduleValueChanged(boolean newValue) {
            }
        };
    }
}

