/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.sketch;

import com.thinkbuzan.apollo.ui.core.factory.AbstractSliderUI;
import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class ToolSizeButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.SketchToolWidthAction";
    private static final String IMAGE_PATH = "sketch/tool-size-30px.png";
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.sketcheditor.radius");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.sketcheditor.radius");

    public ToolSizeButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), ToolSizeButton.createToolSizeMenu());
        this.setToolTipText(TOOL_TIP_TEXT);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private static JPopupMenu createToolSizeMenu() {
        JPopupMenu opacityMenu = new JPopupMenu();
        opacityMenu.setBackground(Color.white);
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new FlowLayout(0, 5, 0));
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel zeroLabel = ToolSizeButton.getLabel("0");
        JLabel hundredLabel = ToolSizeButton.getLabel("30");
        final JSlider slider = new JSlider(0, 30);
        slider.setOpaque(false);
        slider.setValue(1);
        AbstractSliderUI sliderUI = CoreUIFactory.createSliderUI((JSlider)slider, (boolean)false, (boolean)true);
        sliderUI.setSliderForegroundColour(Color.decode("#0067b0"));
        slider.setUI((SliderUI)sliderUI);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServiceManager.getActionManager().runAction(ToolSizeButton.ACTION_ID, new Object[]{slider.getValue()});
            }
        });
        p.add(zeroLabel);
        p.add(slider);
        p.add(hundredLabel);
        opacityMenu.add(p);
        return opacityMenu;
    }

    private static JLabel getLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        label.setForeground(Color.decode("#0067b0"));
        return label;
    }
}

