/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.timeline;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TimelineLayoutButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.orion.timeline.actions.ToggleLayout";
    private static final String IMAGE_PATH = "layout/smart-layout-30px.png";
    private static final String IMAGE_PATH_OFF = "layout/smart-layout-off-30px.png";
    private static final String BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.autoLayout");
    private static final String TOOL_TIP_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.windows.rt.autoLayout.description");
    private transient boolean selected = false;

    public TimelineLayoutButton() {
        super(BUTTON_TEXT, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setEnabled(true);
        this.setSelected(this.selected);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceManager.getActionManager().runAction(TimelineLayoutButton.ACTION_ID, new Object[0]);
                TimelineLayoutButton.this.selected = !TimelineLayoutButton.this.selected;
                TimelineLayoutButton.this.setSelected(TimelineLayoutButton.this.selected);
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)((Object)this));
    }

    private void setSelected(final boolean flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (flag) {
                        TimelineLayoutButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(TimelineLayoutButton.IMAGE_PATH, 30));
                    } else {
                        TimelineLayoutButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(TimelineLayoutButton.IMAGE_PATH_OFF, 30));
                    }
                }
            });
        }
    }
}

