/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.timeline;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.apollo.view.ITimelineView;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class TimelineToggelConnectorsButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.orion.timeline.actions.ToggleConnectionVisibilityAction";
    private static final String IMAGE_PATH = "timeline/windows_always_show.png";
    private static final String IMAGE_PATH_OFF = "layout/smart-layout-off-30px.png";
    private static final String BUTTON_TEXT_ALWYAS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.timeline.connections.showAlways");
    private static final String BUTTON_TEXT_SELECTION = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.timeline.connections.showActive");
    private static final String TOOL_TIP_TEXT = BUTTON_TEXT_ALWYAS;
    private transient boolean selected = false;

    public TimelineToggelConnectorsButton() {
        super(BUTTON_TEXT_ALWYAS, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setToolTipText(TOOL_TIP_TEXT);
        this.setEnabled(true);
        this.setSelected(this.selected);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineToggelConnectorsButton.this.selected = !TimelineToggelConnectorsButton.this.selected;
                TimelineToggelConnectorsButton.this.setSelected(TimelineToggelConnectorsButton.this.selected);
                ServiceManager.getActionManager().runAction(TimelineToggelConnectorsButton.ACTION_ID, new Object[0]);
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(final IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        TimelineToggelConnectorsButton.this.setEnabled(service.getAllEditorViews().size() > 0);
                        TimelineToggelConnectorsButton.this.updateSelected();
                    }
                });
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSelected() {
        try {
            if (!(ServiceManager.getEditorManager().getCurrentEditorComponent().getView() instanceof ITimelineView)) return;
        }
        catch (Exception e) {
            this.setSelected(false);
        }
    }

    private void setSelected(final boolean flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (flag) {
                        TimelineToggelConnectorsButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(TimelineToggelConnectorsButton.IMAGE_PATH, 30));
                        TimelineToggelConnectorsButton.this.setText(BUTTON_TEXT_SELECTION);
                    } else {
                        TimelineToggelConnectorsButton.this.getIconLabel().setIcon(ResourceManager.getImageIcon(TimelineToggelConnectorsButton.IMAGE_PATH_OFF, 30));
                        TimelineToggelConnectorsButton.this.setText(BUTTON_TEXT_ALWYAS);
                    }
                    TimelineToggelConnectorsButton.this.revalidate();
                }
            });
        }
    }
}

