/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.buttons.timeline;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.apollo.view.ITimelineView;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class TimelineToggleHintsButton
extends LargeRibbonButton {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_ID = "com.thinkbuzan.orion.timeline.actions.ToggleHintsAction";
    private static final String IMAGE_PATH = "timeline/windows_hints.png";
    private static final String BUTTON_TEXT_SHOW = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.timeline.hint.button.show");
    private static final String BUTTON_TEXT_HIDE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.timeline.hint.button.hide");
    private transient boolean selected = true;

    public TimelineToggleHintsButton() {
        super(BUTTON_TEXT_SHOW, ResourceManager.getImageIcon(IMAGE_PATH, 30), ResourceManager.getImageIcon(DISABLED + IMAGE_PATH, 30), null);
        this.setEnabled(true);
        this.setSelected(this.selected);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineToggleHintsButton.this.selected = !TimelineToggleHintsButton.this.selected;
                TimelineToggleHintsButton.this.setSelected(TimelineToggleHintsButton.this.selected);
                ServiceManager.getActionManager().runAction(TimelineToggleHintsButton.ACTION_ID, new Object[0]);
                return null;
            }
        };
        this.setCommand(callable);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(final IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        TimelineToggleHintsButton.this.setEnabled(service.getAllEditorViews().size() > 0);
                        TimelineToggleHintsButton.this.updateSelected();
                    }
                });
            }
        });
    }

    private void updateSelected() {
        try {
            if (ServiceManager.getEditorManager().getCurrentEditorComponent().getView() instanceof ITimelineView) {
                this.setSelected(((ITimelineView)ServiceManager.getEditorManager().getCurrentEditorComponent().getView()).isShowHints());
            }
        }
        catch (Exception e) {
            this.setSelected(false);
        }
    }

    private void setSelected(final boolean flag) {
        if (this.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (flag) {
                        TimelineToggleHintsButton.this.setText(BUTTON_TEXT_HIDE);
                    } else {
                        TimelineToggleHintsButton.this.setText(BUTTON_TEXT_SHOW);
                    }
                    TimelineToggleHintsButton.this.revalidate();
                }
            });
        }
    }
}

