/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.scrollabletilepanel;

import com.thinkbuzan.apollo.ui.win.frame.ui.scrollabletilepanel.ScrollableTilePanelTile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ScrollableTilePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color BORDER = Color.decode("#ababab");
    private static final Color HOVER_BORDER = Color.decode("#a3bde3");
    private static final Color PRESSED_BORDER = Color.decode("#a3bde3");
    private static final Color FOREGROUND = Color.decode("#777777");
    private static final Color HOVER_FOREGROUND = Color.decode("#444444");
    private static final Color PRESSED_FOREGROUND = Color.black;
    private static final Color BACKGROUND = Color.white;
    private static final Color HOVER_BACKGROUND = Color.decode("#d5e1f2");
    private static final Color PRESSED_BACKGROUND = Color.decode("#a3bde3");
    private static final int COLUMNS = 7;
    LinkedList<JPanel> _tilePanels;
    int _currentPage;
    JPanel _scrollToolPanel;
    JSeparator _separator = this.createSeparator();

    public ScrollableTilePanel() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this._tilePanels = new LinkedList();
        JPanel tilePanel = this.createTilePanel();
        this.add((Component)tilePanel, "Center");
        this._scrollToolPanel = new JPanel();
        this._scrollToolPanel.setOpaque(false);
        this.add((Component)this._scrollToolPanel, "East");
        this._scrollToolPanel.setLayout(new BoxLayout(this._scrollToolPanel, 1));
        JPanel upArrow = this.createUpArrow();
        JPanel downArrow = this.createDownArrow();
        this._scrollToolPanel.add(upArrow);
        this._scrollToolPanel.add(this._separator);
        this._scrollToolPanel.add(downArrow);
    }

    public void addTile(ScrollableTilePanelTile tile) {
        JPanel lastTilePanel = this._tilePanels.getLast();
        if (lastTilePanel.getComponentCount() == 7) {
            lastTilePanel = this.createTilePanel();
        }
        lastTilePanel.add(tile);
    }

    public void removeAllTiles() {
        JPanel currentTile = this._tilePanels.get(this._currentPage);
        this.remove(currentTile);
        this._tilePanels.clear();
        this._currentPage = 0;
        JPanel tilePanel = this.createTilePanel();
        this.add((Component)tilePanel, "Center");
    }

    public int getPageNumber() {
        return this._currentPage;
    }

    public void setPageNumber(int pageNumber) {
        if (pageNumber < this._tilePanels.size() && pageNumber >= 0) {
            this.setPage(pageNumber);
        }
    }

    private JPanel createTilePanel() {
        JPanel tilePanel = new JPanel();
        tilePanel.setLayout(new FlowLayout(0, 0, 0));
        tilePanel.setOpaque(false);
        tilePanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, BORDER));
        this._tilePanels.addLast(tilePanel);
        return tilePanel;
    }

    private void scrollUp() {
        int newPage = this._currentPage - 1;
        if (newPage >= 0) {
            this.setPage(newPage);
        }
    }

    private void scrollDown() {
        int newPage = this._currentPage + 1;
        if (newPage < this._tilePanels.size()) {
            this.setPage(newPage);
        }
    }

    private void setPage(int newPage) {
        this.remove(this._tilePanels.get(this._currentPage));
        this.add(this._tilePanels.get(newPage));
        this._currentPage = newPage;
        this.revalidate();
        this.repaint();
    }

    private JPanel createUpArrow() {
        final JPanel upArrow = this.createToolButton("\uf035");
        upArrow.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, BORDER));
        upArrow.addMouseListener(new MouseAdapter(){

            private void setHover() {
                upArrow.setBackground(HOVER_BACKGROUND);
                upArrow.setForeground(HOVER_FOREGROUND);
                upArrow.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, HOVER_BORDER));
                ScrollableTilePanel.this._separator.setForeground(HOVER_BORDER);
            }

            private void setNormal() {
                upArrow.setBackground(BACKGROUND);
                upArrow.setForeground(FOREGROUND);
                upArrow.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, BORDER));
                ScrollableTilePanel.this._separator.setForeground(BORDER);
            }

            private void setPressed() {
                upArrow.setBackground(PRESSED_BACKGROUND);
                upArrow.setForeground(PRESSED_FOREGROUND);
                upArrow.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, PRESSED_BORDER));
                ScrollableTilePanel.this._separator.setForeground(PRESSED_BORDER);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ScrollableTilePanel.this.scrollUp();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setHover();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setNormal();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.setPressed();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (upArrow.getBounds().contains(e.getPoint())) {
                    this.setHover();
                } else {
                    this.setNormal();
                }
            }
        });
        return upArrow;
    }

    private JPanel createDownArrow() {
        final JPanel downArrow = this.createToolButton("\uf036");
        downArrow.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, BORDER));
        downArrow.addMouseListener(new MouseAdapter(){

            private void setHover() {
                downArrow.setBackground(HOVER_BACKGROUND);
                downArrow.setForeground(HOVER_FOREGROUND);
                downArrow.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, HOVER_BORDER));
                ScrollableTilePanel.this._separator.setForeground(HOVER_BORDER);
            }

            private void setNormal() {
                downArrow.setBackground(BACKGROUND);
                downArrow.setForeground(FOREGROUND);
                downArrow.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, BORDER));
                ScrollableTilePanel.this._separator.setForeground(BORDER);
            }

            private void setPressed() {
                downArrow.setBackground(PRESSED_BACKGROUND);
                downArrow.setForeground(PRESSED_FOREGROUND);
                downArrow.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, PRESSED_BORDER));
                ScrollableTilePanel.this._separator.setForeground(PRESSED_BORDER);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ScrollableTilePanel.this.scrollDown();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setHover();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setNormal();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.setPressed();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point point = e.getPoint();
                Rectangle bounds = downArrow.getBounds();
                point.y += bounds.height;
                if (bounds.contains(point)) {
                    this.setHover();
                } else {
                    this.setNormal();
                }
            }
        });
        return downArrow;
    }

    private JSeparator createSeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setForeground(Color.decode("#ababab"));
        separator.setPreferredSize(new Dimension(10, 1));
        return separator;
    }

    private JPanel createToolButton(String text) {
        final JLabel toolLabel = new JLabel(text);
        toolLabel.setFont(new Font("Marlett", 0, 8));
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BorderLayout());
        p.add((Component)toolLabel, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(13, 3, 13, 2));
        JPanel q = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setForeground(Color fg) {
                toolLabel.setForeground(fg);
            }
        };
        q.setBackground(BACKGROUND);
        q.setLayout(new FlowLayout(1, 0, 0));
        q.setForeground(FOREGROUND);
        q.add(p);
        return q;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superDim = super.getMinimumSize();
        int width = ScrollableTilePanelTile.SIZE.width * 7 + this._scrollToolPanel.getPreferredSize().width + 1;
        return new Dimension(width, superDim.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

