/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContextTabTopper
extends JPanel {
    private final JPanel _panel;
    private final JLabel _contextTabLabel;

    public ContextTabTopper(Color highlightColour, Color backgroundColour, Color textColour) {
        this.setLayout(new BorderLayout());
        this._panel = new JPanel();
        this._panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 4));
        this._panel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 4));
        this._panel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 4));
        this._contextTabLabel = new JLabel("", 0);
        this._contextTabLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)9.0f));
        this._contextTabLabel.setOpaque(true);
        this.setHighlightColour(highlightColour);
        this.setBackgroundColour(backgroundColour);
        this.setTextColour(textColour);
        this.add((Component)this._panel, "North");
        this.add((Component)this._contextTabLabel, "Center");
    }

    public Color getHighlightColour() {
        return this._panel.getBackground();
    }

    public Color getBackgroundColour() {
        return this._contextTabLabel.getBackground();
    }

    public Color getTextColour() {
        return this._contextTabLabel.getForeground();
    }

    public void setHighlightColour(Color colour) {
        this._panel.setBackground(colour);
    }

    public void setBackgroundColour(Color colour) {
        this._contextTabLabel.setBackground(colour);
    }

    public void setTextColour(Color colour) {
        this._contextTabLabel.setForeground(colour);
    }

    public void setText(String text) {
        this._contextTabLabel.setText(text);
    }
}

