/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs;

import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.ContextTabTopper;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.TabbedRibbon;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Tab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String id;
    private static final int COLLAPSE_AREA_WIDTH = 29;
    private static final int COLLAPSE_AREA_HEIGHT = 17;
    private TabbedRibbon _parentTabbedPane;
    private final Color BACKGROUND_COLOUR = Color.decode("#f1f1f1");
    private final Color FOREGROUND_COLOUR = Color.decode("#444444");
    private final Color SELECTED_BACKGROUND_COLOUR = Color.decode("#fafafa");
    private final Color SELECTED_FOREGROUND_COLOUR = Color.decode("#2b579a");
    private boolean _isHoveringCollapseButton = false;
    private boolean _isPressedCollapseButton = false;
    private boolean _isContextTab;
    private ContextTabTopper _topper;
    private final JComponent _tabContent;

    public boolean IsContextTab() {
        return this._isContextTab;
    }

    public ContextTabTopper getTopper() {
        return this._topper;
    }

    public void setTopperBounds(int x, int y, int w, int h) {
        this._topper.setBounds(x, y, w, h);
    }

    public void setTopperBounds(Rectangle r) {
        this._topper.setBounds(r);
    }

    public void setTopperText(String text) {
        this._topper.setText(text);
    }

    public JComponent getTabContent() {
        return this._tabContent;
    }

    public Tab(TabbedRibbon parent, JPanel content, String idIn, ContextTabTopper contextTabTopper) {
        this._isContextTab = true;
        this._topper = contextTabTopper;
        this._tabContent = content;
        this.init(parent, this._tabContent, idIn);
    }

    public Tab(TabbedRibbon parent, JPanel content, String idIn) {
        this._isContextTab = false;
        this._tabContent = content;
        this.init(parent, this._tabContent, idIn);
    }

    private void init(TabbedRibbon parent, Component content, String idIn) {
        this.id = idIn;
        this._parentTabbedPane = parent;
        this.setLayout(new BorderLayout());
        this.add(content, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (Tab.this._isHoveringCollapseButton) {
                    Tab.this._isPressedCollapseButton = true;
                    Tab.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Tab.this._isPressedCollapseButton = false;
                if (e.getX() < Tab.this.getWidth() - 29 || e.getX() > Tab.this.getWidth() || e.getY() < Tab.this.getHeight() - 17 || e.getY() > Tab.this.getHeight()) {
                    Tab.this._isHoveringCollapseButton = false;
                }
                Tab.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Tab.this._isHoveringCollapseButton = false;
                if (!Tab.this._isPressedCollapseButton) {
                    Tab.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Tab.this._isHoveringCollapseButton) {
                    Tab.this._parentTabbedPane.collapse();
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean oldHoverState = Tab.this._isHoveringCollapseButton;
                if (e.getX() > Tab.this.getWidth() - 29 && e.getY() > Tab.this.getHeight() - 17) {
                    Tab.this._isHoveringCollapseButton = true;
                } else {
                    Tab.this._isHoveringCollapseButton = false;
                }
                if (Tab.this._isHoveringCollapseButton != oldHoverState) {
                    Tab.this.repaint();
                }
            }
        });
    }

    public Color getForegroundColour() {
        return this.FOREGROUND_COLOUR;
    }

    public Color getSelectedForegroundColour() {
        if (this._isContextTab) {
            return this._topper.getTextColour();
        }
        if (this._parentTabbedPane.isCollapsed()) {
            return this.FOREGROUND_COLOUR;
        }
        return this.SELECTED_FOREGROUND_COLOUR;
    }

    public Color getForegroundHoverColour() {
        if (this._isContextTab) {
            return this._topper.getTextColour();
        }
        return this.SELECTED_FOREGROUND_COLOUR;
    }

    public Color getBackgroundColour() {
        if (this._isContextTab) {
            return this._topper.getBackgroundColour();
        }
        return this.BACKGROUND_COLOUR;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        int x = this.getWidth() - 29;
        int y = this.getHeight() - 17;
        if (this._isHoveringCollapseButton) {
            if (this._isPressedCollapseButton) {
                g.setColor(Color.decode("#a3bde3"));
            } else {
                g.setColor(Color.decode("#d5e1f2"));
            }
            g.fillRect(x, y, 29, 17);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this._isPressedCollapseButton) {
            g2d.setColor(Color.decode("#19478a"));
        } else {
            g2d.setColor(Color.decode("#777777"));
        }
        g2d.drawLine(x + 11, y + 10, x + 14, y + 7);
        g2d.drawLine(x + 14, y + 7, x + 17, y + 10);
    }
}

