/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs;

import com.thinkbuzan.apollo.ui.core.win.component.LargeRibbonButton;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.MindMapFrame;
import com.thinkbuzan.apollo.ui.win.frame.ui.RibbonSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.ContextTabTopper;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.RibbonTabContent;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.Tab;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.BackgroundImageSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.ColoursSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.EditSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.InsertSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.ModeSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.branch.ConvertSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.branch.DesignSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.branch.DroptaskSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.branch.SnippetSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.comments.CommentsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.design.BackgroundSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.design.DrawModeSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.design.MapStyleSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.design.StyleElementsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.ClipboardSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.EditingSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.FormattingSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.LayoutSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.ModesSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.home.ViewsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.BranchItemsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.BranchSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.IllustrationsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.MapElementsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.MapSnippetsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.layout.PinningSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.layout.SmartLayoutSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.layout.VisibleSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.presentation.AdvancedSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.presentation.PresentationSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.presentation.SlidesSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.project.ExportSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.project.TasksSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.project.ViewSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.sketch.EndSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.sketch.OptionsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.sketch.ShapesSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.sketch.ToolsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.timeline.TimelineEditSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.timeline.TimelineInsertSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.timeline.TimelineSettingsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.timeline.TimelineStatusSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools.AccountSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools.MapSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools.ProductSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools.ProofingSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools.SupportSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.view.DetailsSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.view.FilterSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.view.ShowSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.view.ZoomSection;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import com.thinkbuzan.pascal.services.ui.IMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class TabbedRibbon
extends JTabbedPane {
    private static final String OPEN = "Open";
    private static final String NEW = "New";
    private static final long serialVersionUID = 1L;
    private static final Color LINE_COLOUR = Color.decode("#c6c6c6");
    private static final Color BACKGROUND_COLOUR = Color.decode("#fafafa");
    private static final int TAB_HEIGHT = 26;
    public static final Dimension PREF_SIZE = new Dimension(0, 119);
    private Tab _selectedTab;
    private Tab _previouslySelectedTab;
    final boolean[] justClickedFile = new boolean[1];
    private TabbedRibbon _thisTabbedRibbon;
    private JPanel _topBar;
    private FileMenu _filePagePanel;
    private Tab _fileTab;
    private Tab _homeTab;
    private Tab _insertTab;
    private Tab _layoutTab;
    private Tab _designTab;
    private Tab _viewTab;
    private Tab _toolsTab;
    private Tab _fastCaptureTab;
    private Tab _brainstormTab;
    private Tab _branchTab;
    private Tab _projectTab;
    private Tab _commentsTab;
    private Tab _presentationTab;
    private Tab _sketchTab;
    private Tab _timelineTab;
    private boolean _isCollapsed = false;
    private static final String FILE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.file").toUpperCase();
    private static final String HOME_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.home").toUpperCase();
    private static final String INSERT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.insert").toUpperCase();
    private static final String LAYOUT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.layout").toUpperCase();
    private static final String DESIGN_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.design").toUpperCase();
    private static final String VIEW_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.view").toUpperCase();
    private static final String TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.tools").toUpperCase();
    private static final String FAST_CAPTURE_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.fastcapturetools");
    private static final String BRAINSTORM_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.brainstormtools").toUpperCase();
    private static final String BRANCH_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.branchtools").toUpperCase();
    private static final String PROJECT_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.projecttools").toUpperCase();
    private static final String COMMENTS_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.commentstools").toUpperCase();
    private static final String PRESENTATION_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.presentationtools").toUpperCase();
    private static final String SKETCH_TOOLS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.sketchtools").toUpperCase();
    private static final String FAST_CAPTURE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.fastcapture").toUpperCase();
    private static final String BRAINSTORMING_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.brainstorming").toUpperCase();
    private static final String BRANCH_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.branch").toUpperCase();
    private static final String PROJECT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.project").toUpperCase();
    private static final String COMMENTS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.comments").toUpperCase();
    private static final String PRESENTATION_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.presentation").toUpperCase();
    private static final String SKETCH_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.sketch").toUpperCase();
    private static final String TIMELINE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.timeline").toUpperCase();
    final JPopupMenu overflowPopup = new JPopupMenu();
    final LargeRibbonButton showPopupButton = new LargeRibbonButton(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.more"), null, this.overflowPopup);
    final ArrayList<Component> componentsOnRibbon = new ArrayList();
    final ArrayList<Component> componentsOnOverflow = new ArrayList();
    int previousComponentCount = 0;
    MindMapFrame.FullScreenMouseListener fullScreenListener;
    IViewListener ivl;

    public Tab getPreviouslySelectedTab() {
        return this._previouslySelectedTab;
    }

    public Tab getSelectedTab() {
        return this._selectedTab;
    }

    public TabbedRibbon(JPanel topBar, FileMenu filePagePanel) {
        this._thisTabbedRibbon = this;
        this._topBar = topBar;
        this._filePagePanel = filePagePanel;
        this.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        this.setBackground(BACKGROUND_COLOUR);
        this.overflowPopup.setLightWeightPopupEnabled(false);
        this.overflowPopup.setBackground(Color.decode("#fafafa"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TabbedRibbon.this.fitRibbonSections(TabbedRibbon.this.getWidth());
            }
        });
        JPanel r = new JPanel();
        r.setBackground(this.getBackground());
        this._fileTab = new Tab(this, r, "file");
        this.addTab("  " + FILE_BUTTON_TEXT + "   ", this._fileTab);
        this.setForegroundAt(this.indexOfComponent(this._fileTab), this._fileTab.getSelectedForegroundColour());
        this._selectedTab = this._fileTab;
        this._homeTab = this.createHomeTab();
        this.addTab(HOME_BUTTON_TEXT, this._homeTab);
        this._insertTab = this.createInsertTab();
        this.addTab(INSERT_BUTTON_TEXT, this._insertTab);
        this._layoutTab = this.createLayoutTab();
        this.addTab(LAYOUT_BUTTON_TEXT, this._layoutTab);
        if (BundleLicenser.isStylesLicensed() || BundleLicenser.isBackgroundLicensed() || BundleLicenser.isFreehandLicensed()) {
            this._designTab = this.createDesignTab();
            this.addTab(DESIGN_BUTTON_TEXT, this._designTab);
        }
        this._viewTab = this.createViewTab();
        this.addTab(VIEW_BUTTON_TEXT, this._viewTab);
        this._toolsTab = this.createToolsTab();
        this.addTab(TOOLS_BUTTON_TEXT, this._toolsTab);
        this._fastCaptureTab = this.createFastCaptureTab();
        this._brainstormTab = this.createBrainstormTab();
        this._branchTab = this.createBranchTab();
        this._projectTab = this.createProjectTab();
        this._commentsTab = this.createCommentsTab();
        this._presentationTab = this.createPresentationTab();
        this._sketchTab = this.createSketchTab();
        this._timelineTab = this.createTimelineTab();
        topBar.add((Component)this._fastCaptureTab.getTopper(), 0);
        topBar.add((Component)this._brainstormTab.getTopper(), 0);
        topBar.add((Component)this._branchTab.getTopper(), 0);
        topBar.add((Component)this._projectTab.getTopper(), 0);
        topBar.add((Component)this._commentsTab.getTopper(), 0);
        topBar.add((Component)this._presentationTab.getTopper(), 0);
        topBar.add((Component)this._sketchTab.getTopper(), 0);
        topBar.add((Component)this._timelineTab.getTopper(), 0);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        if (editor == null) {
                            ((IMainFrame)MainFrameUtilities.getMainFrame()).setMapName(null);
                            ((IMainFrame)MainFrameUtilities.getMainFrame()).setPresentationName(null);
                            return;
                        }
                        if (!editor.getView().getId().equals("com.thinkbuzan.phoenix.view.PresentationView")) {
                            ((IMainFrame)MainFrameUtilities.getMainFrame()).setPresentationName(null);
                        }
                        if (editor.getView().getId().equals("com.thinkbuzan.phoenix.view.BrainstormView")) {
                            if (TabbedRibbon.this.indexOfComponent(TabbedRibbon.this._brainstormTab) >= 0) {
                                TabbedRibbon.this.setSelectedComponent(TabbedRibbon.this._brainstormTab);
                            } else {
                                TabbedRibbon.this.addBrainstormContextTab();
                            }
                        }
                        if (editor.getView().getId().equals("com.thinkbuzan.phoenix.view.FastCaptureView")) {
                            if (TabbedRibbon.this.indexOfComponent(TabbedRibbon.this._fastCaptureTab) >= 0) {
                                TabbedRibbon.this.setSelectedComponent(TabbedRibbon.this._fastCaptureTab);
                            } else {
                                TabbedRibbon.this.addFastCaptureContextTab();
                            }
                        }
                        if (editor.getView().getId().equals("com.thinkbuzan.orion.view.TimelineView")) {
                            if (TabbedRibbon.this.indexOfComponent(TabbedRibbon.this._timelineTab) >= 0) {
                                TabbedRibbon.this.setSelectedComponent(TabbedRibbon.this._timelineTab);
                            } else {
                                TabbedRibbon.this.addTimelineContextTab();
                            }
                        }
                        if (TabbedRibbon.this._selectedTab == TabbedRibbon.this._fileTab) {
                            if (TabbedRibbon.this._previouslySelectedTab != TabbedRibbon.this._fileTab) {
                                TabbedRibbon.this.goToPreviousTab();
                            } else {
                                TabbedRibbon.this.setSelectedComponent(TabbedRibbon.this._homeTab);
                            }
                        }
                    }
                });
            }
        });
        this.justClickedFile[0] = false;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TabbedRibbon.this.justClickedFile[0]) {
                    TabbedRibbon.this.expand();
                }
                TabbedRibbon.this.justClickedFile[0] = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                JTabbedPane tabs = (JTabbedPane)e.getSource();
                if (TabbedRibbon.this.findComponentAt(e.getX(), e.getY()) == tabs) {
                    int tabIndex = TabbedRibbon.this.indexAtLocation(e.getX(), e.getY());
                    if (tabIndex >= 0) {
                        Tab tab = (Tab)tabs.getComponentAt(tabIndex);
                        tabs.setForegroundAt(tabIndex, tab.getForegroundHoverColour());
                    }
                    for (int i = 0; i < tabs.getTabCount(); ++i) {
                        if (i == tabIndex || i == tabs.getSelectedIndex() && !TabbedRibbon.this._isCollapsed) continue;
                        Tab tab = (Tab)tabs.getComponentAt(i);
                        tabs.setForegroundAt(i, tab.getForegroundColour());
                    }
                }
            }
        });
        this.setUI(new BasicTabbedPaneUI(){

            @Override
            protected Insets getContentBorderInsets(int tabPlacement) {
                return new Insets(3, 0, 1, 0);
            }

            @Override
            protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
                Font font = this.tabPane.getFont();
                FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
                int width = this.calculateTabWidth(tabPlacement, selectedIndex, metrics);
                int start = 0;
                for (int i = 0; i < selectedIndex; ++i) {
                    start += this.calculateTabWidth(tabPlacement, i, metrics);
                }
                int selectedEnd = start + width + 3;
                g.setColor(LINE_COLOUR);
                g.drawLine(0, 25, start, 25);
                g.drawLine(selectedEnd, 25, this.tabPane.getWidth(), 25);
            }

            @Override
            protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            }

            @Override
            protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
                if (tabIndex == 0) {
                    g.setColor(Color.decode("#67C2DE"));
                    g.fillRect(x - 2, y - 2, w + 3, h + 5);
                } else {
                    Tab tab = (Tab)TabbedRibbon.this._thisTabbedRibbon.getComponentAt(tabIndex);
                    if (isSelected && !TabbedRibbon.this._isCollapsed) {
                        g.setColor(TabbedRibbon.this.getBackground());
                    } else {
                        g.setColor(tab.getBackgroundColour());
                    }
                    g.fillRect(x, y - 2, w + 1, h + 5);
                }
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                Rectangle r;
                int selectedIndex = TabbedRibbon.this.getSelectedIndex();
                Graphics2D g2d = (Graphics2D)g;
                this.paintTabBackground(g, tabPlacement, tabIndex, rects[tabIndex].x, rects[tabIndex].y, rects[tabIndex].width, rects[tabIndex].height, selectedIndex == tabIndex);
                Tab t = (Tab)TabbedRibbon.this._thisTabbedRibbon.getComponentAt(tabIndex);
                if (t != null && t.IsContextTab()) {
                    r = (Rectangle)rects[tabIndex].clone();
                    if (tabIndex == TabbedRibbon.this.indexOfComponent(TabbedRibbon.this._selectedTab)) {
                        r.x -= 114;
                        r.width -= 2;
                        r.height -= 2;
                    } else {
                        r.x -= 116;
                        ++r.width;
                        r.y -= 2;
                        r.height += 2;
                    }
                    t.setTopperBounds(r);
                    TabbedRibbon.this._topBar.revalidate();
                    TabbedRibbon.this._topBar.repaint();
                }
                if (!TabbedRibbon.this._isCollapsed) {
                    r = (Rectangle)rects[selectedIndex].clone();
                    ++r.x;
                    r.y += 2;
                    --r.width;
                    if (tabIndex == 0) {
                        g2d.setColor(Color.decode("#67C2DE"));
                    } else {
                        g2d.setColor(LINE_COLOUR);
                        g2d.draw(rects[selectedIndex]);
                        g2d.setColor(BACKGROUND_COLOUR);
                    }
                    g2d.fill(r);
                }
                String title = this.tabPane.getTitleAt(tabIndex);
                Font font = this.tabPane.getFont();
                FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
                Icon icon = this.getIconForTab(tabIndex);
                this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, rects[tabIndex], iconRect, textRect, false);
                this.paintText(g2d, tabPlacement, TabbedRibbon.this.getFont(), metrics, tabIndex, title, textRect, false);
            }

            @Override
            protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
                g.setFont(font);
                View v = this.getTextViewForTab(tabIndex);
                if (v != null) {
                    v.paint(g, textRect);
                } else {
                    int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
                    if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                        Color selectedFG;
                        Color fg = this.tabPane.getForegroundAt(tabIndex);
                        if (isSelected && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                            fg = selectedFG;
                        }
                        if (tabIndex == 0) {
                            g.setColor(Color.white);
                        } else {
                            g.setColor(fg);
                        }
                        SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                    } else {
                        g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                        SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                        g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                        SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
                    }
                }
            }
        });
        this._fastCaptureTab.getTopper().repaint();
        this._brainstormTab.getTopper().repaint();
        this._branchTab.getTopper().repaint();
        this._projectTab.getTopper().repaint();
        this._presentationTab.getTopper().repaint();
        this._commentsTab.getTopper().repaint();
        this._sketchTab.getTopper().repaint();
    }

    private void fitRibbonSections(int availableWidth) {
        ArrayList<Component> sections = this.getSections();
        int componentsToAdd = this.measure(sections, availableWidth);
        if (componentsToAdd != this.previousComponentCount) {
            this.previousComponentCount = componentsToAdd;
            if (componentsToAdd > 0) {
                this.populateComponentsOnRibbon(sections, componentsToAdd);
                this.populateComponentsOnPopup(sections, componentsToAdd);
                if (this.overflowPopup.getComponentCount() > 0) {
                    this.getSelectedTab().getTabContent().add((Component)this.showPopupButton);
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    private void populateComponentsOnRibbon(ArrayList<Component> sections, int endIndex) {
        this.componentsOnRibbon.clear();
        this.getSelectedTab().getTabContent().removeAll();
        for (int i = 0; i < endIndex; ++i) {
            System.out.println("add to ribbon: " + i);
            Component section = sections.get(i);
            this.getSelectedTab().getTabContent().add(section);
            this.componentsOnRibbon.add(section);
        }
    }

    private void populateComponentsOnPopup(ArrayList<Component> sections, int startIndex) {
        this.componentsOnOverflow.clear();
        this.overflowPopup.removeAll();
        for (int i = startIndex; i < sections.size(); ++i) {
            System.out.println("add to popup: " + i);
            Component section = sections.get(i);
            this.overflowPopup.add(section);
            this.componentsOnOverflow.add(section);
        }
    }

    private ArrayList<Component> getSections() {
        ArrayList<Component> sections = new ArrayList<Component>();
        for (Component component : this.componentsOnRibbon) {
            if (!(component instanceof RibbonSection)) continue;
            sections.add((RibbonSection)component);
        }
        for (Component component : this.componentsOnOverflow) {
            if (!(component instanceof RibbonSection)) continue;
            sections.add((RibbonSection)component);
        }
        return sections;
    }

    private int measure(ArrayList<Component> sections, int availableWidth) {
        if (sections.isEmpty()) {
            return 0;
        }
        int widthUsed = 0;
        int componentsToAdd = 0;
        for (Component section : sections) {
            int sectionWidth = section.getPreferredSize().width;
            System.out.println("section width: " + sectionWidth);
            if (widthUsed + sectionWidth > availableWidth) break;
            widthUsed += sectionWidth;
            ++componentsToAdd;
        }
        System.out.println("component count: " + componentsToAdd);
        return componentsToAdd;
    }

    public void addFullScreenMouseListener(MindMapFrame.FullScreenMouseListener listener) {
        this.fullScreenListener = listener;
        if (this.isCollapsed()) {
            this.addMouseListener(listener);
        } else {
            this._homeTab.addMouseListener(listener);
            this._insertTab.addMouseListener(listener);
            this._layoutTab.addMouseListener(listener);
            this._designTab.addMouseListener(listener);
            this._viewTab.addMouseListener(listener);
            this._toolsTab.addMouseListener(listener);
            this._fastCaptureTab.addMouseListener(listener);
            this._brainstormTab.addMouseListener(listener);
            this._branchTab.addMouseListener(listener);
            this._projectTab.addMouseListener(listener);
            this._commentsTab.addMouseListener(listener);
            this._presentationTab.addMouseListener(listener);
            this._sketchTab.addMouseListener(listener);
            this._timelineTab.addMouseListener(listener);
        }
    }

    public void removeFullScreenMouseListener(MindMapFrame.FullScreenMouseListener listener) {
        this.removeMouseListener(listener);
        this._homeTab.removeMouseListener(listener);
        this._insertTab.removeMouseListener(listener);
        this._layoutTab.removeMouseListener(listener);
        this._designTab.removeMouseListener(listener);
        this._viewTab.removeMouseListener(listener);
        this._toolsTab.removeMouseListener(listener);
        this._fastCaptureTab.removeMouseListener(listener);
        this._brainstormTab.removeMouseListener(listener);
        this._branchTab.removeMouseListener(listener);
        this._projectTab.removeMouseListener(listener);
        this._commentsTab.removeMouseListener(listener);
        this._presentationTab.removeMouseListener(listener);
        this._sketchTab.removeMouseListener(listener);
        this._timelineTab.removeMouseListener(listener);
        this.fullScreenListener = null;
    }

    @Override
    public void setSelectedIndex(int index) {
        Tab newSelectedTab;
        block12: {
            super.setSelectedIndex(index);
            if (this.isCollapsed()) {
                // empty if block
            }
            newSelectedTab = (Tab)this.getSelectedComponent();
            Tab oldTab = this._selectedTab;
            int oldTabIndex = this.indexOfComponent(oldTab);
            if (oldTabIndex > -1) {
                this.setForegroundAt(this.indexOfComponent(oldTab), oldTab.getForegroundColour());
            }
            if (newSelectedTab == this._fileTab) {
                try {
                    final IEditorView editorComponent = ServiceManager.getEditorManager().getCurrentEditorComponent();
                    if (editorComponent != null && ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.ExitPresentationAction") && editorComponent.getView().getId().equals("com.thinkbuzan.gaia.view.PresentationView")) {
                        this.ivl = new IViewListener(){

                            public void viewChanged(String viewID) {
                                TabbedRibbon.this.showFileTab();
                                editorComponent.removeViewTypeListener(TabbedRibbon.this.ivl);
                            }
                        };
                        editorComponent.addViewTypeListener(this.ivl);
                        this.justClickedFile[0] = false;
                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ExitPresentationAction", new Object[0]);
                        break block12;
                    }
                    this.showFileTab();
                    this.justClickedFile[0] = true;
                }
                catch (Exception e1) {
                    this.showFileTab();
                }
            } else {
                Tab newTab = newSelectedTab;
                int newTabIndex = this.indexOfComponent(newTab);
                if (newTabIndex > -1) {
                    this.setForegroundAt(this.indexOfComponent(newTab), newTab.getSelectedForegroundColour());
                }
                this.hideFileTab();
            }
        }
        this._previouslySelectedTab = this._selectedTab;
        this._selectedTab = newSelectedTab;
        if (this._previouslySelectedTab != null && !this.componentsOnOverflow.isEmpty()) {
            this._previouslySelectedTab.getTabContent().remove(this.overflowPopup);
            for (Component component : this.componentsOnOverflow) {
                this._previouslySelectedTab.getTabContent().add(component);
            }
        }
        this.componentsOnRibbon.clear();
        this.componentsOnOverflow.clear();
        this.overflowPopup.setVisible(false);
        this.overflowPopup.removeAll();
        this.previousComponentCount = -1;
        if (this._selectedTab != null) {
            for (Component component : this._selectedTab.getTabContent().getComponents()) {
                if (!(component instanceof RibbonSection)) continue;
                this.componentsOnRibbon.add(component);
            }
        }
        this.fitRibbonSections(this.getWidth());
    }

    public void showFileTab() {
        this._filePagePanel.expand();
        this._filePagePanel.setPanel(OPEN);
        this._filePagePanel.setPanel(NEW);
    }

    public void showFileTab(String tab) {
        this.setSelectedComponent(this._fileTab);
        this._filePagePanel.setPanel(tab);
    }

    private void hideFileTab() {
        if (this._filePagePanel != null) {
            this._filePagePanel.collapse();
        }
    }

    public boolean isCollapsed() {
        return this._isCollapsed;
    }

    private Tab createHomeTab() {
        RibbonTabContent homeTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(true, true, true);
        homeTabContent.add(viewsSection);
        FormattingSection formattingSection = new FormattingSection();
        homeTabContent.add(formattingSection);
        EditingSection editingSection = new EditingSection();
        homeTabContent.add(editingSection);
        ClipboardSection clipboardSection = new ClipboardSection();
        homeTabContent.add(clipboardSection);
        if (BundleLicenser.isCondenseLicensed()) {
            LayoutSection layoutSection = new LayoutSection();
            homeTabContent.add(layoutSection);
        }
        if (BundleLicenser.is3DViewLicensed() || BundleLicenser.isProjectViewLicensed()) {
            ModesSection modeSection = new ModesSection();
            homeTabContent.add(modeSection);
        }
        Tab homeTab = new Tab(this, homeTabContent, "home");
        return homeTab;
    }

    private Tab createInsertTab() {
        RibbonTabContent insertTabContent = new RibbonTabContent();
        BranchSection branchSection = new BranchSection();
        insertTabContent.add(branchSection);
        BranchItemsSection branchItemsSection = new BranchItemsSection();
        insertTabContent.add(branchItemsSection);
        MapElementsSection mapElementsSection = new MapElementsSection();
        insertTabContent.add(mapElementsSection);
        IllustrationsSection illustrationsSection = new IllustrationsSection();
        insertTabContent.add(illustrationsSection);
        if (BundleLicenser.isMapSnippetsLicensed()) {
            MapSnippetsSection mapSnippetsSection = new MapSnippetsSection();
            insertTabContent.add(mapSnippetsSection);
        }
        if (BundleLicenser.isCommentsLicensed()) {
            com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.CommentsSection commentsSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.insert.CommentsSection();
            insertTabContent.add(commentsSection);
        }
        Tab insertTab = new Tab(this, insertTabContent, "insert");
        return insertTab;
    }

    private Tab createLayoutTab() {
        RibbonTabContent layoutTabContent = new RibbonTabContent();
        if (BundleLicenser.isBranchPinningLicensed()) {
            PinningSection pinningSection = new PinningSection();
            layoutTabContent.add(pinningSection);
        }
        if (BundleLicenser.isSmartLayoutLicensed()) {
            SmartLayoutSection smartLayoutSection = new SmartLayoutSection();
            layoutTabContent.add(smartLayoutSection);
        }
        VisibleSection visibleSection = new VisibleSection();
        layoutTabContent.add(visibleSection);
        Tab insertTab = new Tab(this, layoutTabContent, "layout");
        return insertTab;
    }

    private Tab createDesignTab() {
        RibbonTabContent designTabContent = new RibbonTabContent();
        if (BundleLicenser.isStylesLicensed()) {
            MapStyleSection mapStyleSection = new MapStyleSection();
            designTabContent.add(mapStyleSection);
            StyleElementsSection styleElementsSection = new StyleElementsSection();
            designTabContent.add(styleElementsSection);
        }
        if (BundleLicenser.isBackgroundLicensed()) {
            BackgroundSection backgroundSection = new BackgroundSection();
            designTabContent.add(backgroundSection);
        }
        if (BundleLicenser.isFreehandLicensed()) {
            DrawModeSection drawModeSection = new DrawModeSection();
            designTabContent.add(drawModeSection);
        }
        Tab designTab = new Tab(this, designTabContent, "design");
        return designTab;
    }

    private Tab createViewTab() {
        RibbonTabContent viewTabContent = new RibbonTabContent();
        ZoomSection zoomSection = new ZoomSection();
        viewTabContent.add(zoomSection);
        if (BundleLicenser.isExpandCollapseLicensed() || BundleLicenser.isFocusInOutLicensed()) {
            DetailsSection detailsSection = new DetailsSection();
            viewTabContent.add(detailsSection);
        }
        if (BundleLicenser.isFilteringLicensed()) {
            FilterSection filterSection = new FilterSection();
            viewTabContent.add(filterSection);
        }
        ShowSection showSection = new ShowSection();
        viewTabContent.add(showSection);
        Tab viewTab = new Tab(this, viewTabContent, "view");
        return viewTab;
    }

    private Tab createToolsTab() {
        RibbonTabContent toolsTabContent = new RibbonTabContent();
        ProofingSection proofingSection = new ProofingSection();
        toolsTabContent.add(proofingSection);
        SupportSection supportSection = new SupportSection();
        toolsTabContent.add(supportSection);
        ProductSection productSection = new ProductSection();
        toolsTabContent.add(productSection);
        AccountSection accountSection = new AccountSection();
        toolsTabContent.add(accountSection);
        if (BundleLicenser.isUltimateVersion()) {
            MapSection mapSection = new MapSection();
            toolsTabContent.add(mapSection);
        }
        Tab toolsTab = new Tab(this, toolsTabContent, "tools");
        return toolsTab;
    }

    private Tab createFastCaptureTab() {
        RibbonTabContent fastCaptureTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(false, true, false);
        fastCaptureTabContent.add(viewsSection);
        com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.EditSection editSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.EditSection();
        fastCaptureTabContent.add(editSection);
        com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.ClipboardSection clipboardSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.ClipboardSection();
        fastCaptureTabContent.add(clipboardSection);
        com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.LayoutSection layoutSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.fastcapture.LayoutSection();
        fastCaptureTabContent.add(layoutSection);
        com.thinkbuzan.apollo.ui.win.frame.ui.buttons.fastcapture.BackgroundSection backgroundSection = new com.thinkbuzan.apollo.ui.win.frame.ui.buttons.fastcapture.BackgroundSection();
        fastCaptureTabContent.add(backgroundSection);
        Color highlight = Color.decode("#f7a85d");
        Color background = Color.decode("#f8dcc2");
        Color text = Color.decode("#b25d24");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab fastCaptureTab = new Tab(this, fastCaptureTabContent, "fastcapture", topper);
        fastCaptureTab.setTopperText(FAST_CAPTURE_TOOLS_BUTTON_TEXT);
        return fastCaptureTab;
    }

    private Tab createBrainstormTab() {
        RibbonTabContent brainstormTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(false, true, false);
        brainstormTabContent.add(viewsSection);
        InsertSection insertSection = new InsertSection();
        brainstormTabContent.add(insertSection);
        ColoursSection coloursSection = new ColoursSection();
        brainstormTabContent.add(coloursSection);
        EditSection editSection = new EditSection();
        brainstormTabContent.add(editSection);
        ModeSection drawModeSection = new ModeSection();
        brainstormTabContent.add(drawModeSection);
        com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.LayoutSection layoutSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.brainstorm.LayoutSection();
        brainstormTabContent.add(layoutSection);
        BackgroundImageSection backgroundImageSection = new BackgroundImageSection();
        brainstormTabContent.add(backgroundImageSection);
        DroptaskSection droptaskImageSection = new DroptaskSection();
        brainstormTabContent.add(droptaskImageSection);
        Color highlight = Color.decode("#f7a85d");
        Color background = Color.decode("#f8dcc2");
        Color text = Color.decode("#b25d24");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab brainstormTab = new Tab(this, brainstormTabContent, "brainstorm", topper);
        brainstormTab.setTopperText(BRAINSTORM_TOOLS_BUTTON_TEXT);
        return brainstormTab;
    }

    private Tab createBranchTab() {
        RibbonTabContent branchTabContent = new RibbonTabContent();
        DesignSection designSection = new DesignSection();
        branchTabContent.add(designSection);
        FormattingSection formattingSection = new FormattingSection();
        branchTabContent.add(formattingSection);
        if (BundleLicenser.isFocusInOutLicensed() || BundleLicenser.isExpandCollapseLicensed()) {
            DetailsSection detailsSection = new DetailsSection(true);
            branchTabContent.add(detailsSection);
        }
        if (BundleLicenser.isMultiMapsLicensed() || BundleLicenser.isChildMapsLicensed()) {
            ConvertSection convertSection = new ConvertSection();
            branchTabContent.add(convertSection);
        }
        if (BundleLicenser.isMapSnippetsLicensed()) {
            SnippetSection snippetSection = new SnippetSection();
            branchTabContent.add(snippetSection);
        }
        DroptaskSection droptaskSection = new DroptaskSection();
        branchTabContent.add(droptaskSection);
        Color highlight = Color.decode("#f77f6c");
        Color background = Color.decode("#fdd4ce");
        Color text = Color.decode("#b23924");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab branchTab = new Tab(this, branchTabContent, "branch", topper);
        branchTab.setTopperText(BRANCH_TOOLS_BUTTON_TEXT);
        return branchTab;
    }

    private Tab createProjectTab() {
        RibbonTabContent projectTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(false, true, false);
        ViewSection viewSection = new ViewSection();
        TasksSection tasksSection = new TasksSection();
        ExportSection exportSection = new ExportSection();
        projectTabContent.add(viewsSection);
        projectTabContent.add(viewSection);
        projectTabContent.add(tasksSection);
        projectTabContent.add(exportSection);
        Color highlight = Color.decode("#84c8c0");
        Color background = Color.decode("#bee2de");
        Color text = Color.decode("#1a806f");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab projectTab = new Tab(this, projectTabContent, "project", topper);
        projectTab.setTopperText(PROJECT_TOOLS_BUTTON_TEXT);
        return projectTab;
    }

    private Tab createCommentsTab() {
        RibbonTabContent commentsTabContent = new RibbonTabContent();
        CommentsSection commentsSection = new CommentsSection();
        commentsTabContent.add(commentsSection);
        Color highlight = Color.decode("#f1be54");
        Color background = Color.decode("#f7e2ba");
        Color text = Color.decode("#b27724");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab commentsTab = new Tab(this, commentsTabContent, "comments", topper);
        commentsTab.setTopperText(COMMENTS_TOOLS_BUTTON_TEXT);
        return commentsTab;
    }

    private Tab createPresentationTab() {
        RibbonTabContent presentationTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(false, false, true);
        PresentationSection presentationSection = new PresentationSection();
        SlidesSection slidesSection = new SlidesSection();
        com.thinkbuzan.apollo.ui.win.frame.ui.tabs.presentation.LayoutSection layoutSection = new com.thinkbuzan.apollo.ui.win.frame.ui.tabs.presentation.LayoutSection();
        AdvancedSection advancedSection = new AdvancedSection();
        presentationTabContent.add(viewsSection);
        presentationTabContent.add(presentationSection);
        presentationTabContent.add(slidesSection);
        presentationTabContent.add(layoutSection);
        presentationTabContent.add(advancedSection);
        Color highlight = Color.decode("#d0a9cc");
        Color background = Color.decode("#eddeeb");
        Color text = Color.decode("#994c91");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab presentationTab = new Tab(this, presentationTabContent, "presentation", topper);
        presentationTab.setTopperText(PRESENTATION_TOOLS_BUTTON_TEXT);
        return presentationTab;
    }

    private Tab createSketchTab() {
        RibbonTabContent sketchTabContent = new RibbonTabContent();
        ToolsSection toolsSection = new ToolsSection();
        ShapesSection shapesSection = new ShapesSection();
        OptionsSection optionsSection = new OptionsSection();
        EndSection endSection = new EndSection();
        sketchTabContent.add(toolsSection);
        sketchTabContent.add(shapesSection);
        sketchTabContent.add(optionsSection);
        sketchTabContent.add(endSection);
        Color highlight = Color.decode("#f4b083");
        Color background = Color.decode("#fbd4bb");
        Color text = Color.decode("#99501f");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab presentationTab = new Tab(this, sketchTabContent, "sketch", topper);
        presentationTab.setTopperText(SKETCH_TOOLS_BUTTON_TEXT);
        return presentationTab;
    }

    private Tab createTimelineTab() {
        RibbonTabContent timelineTabContent = new RibbonTabContent();
        ViewsSection viewsSection = new ViewsSection(false, true, false);
        TimelineInsertSection insertSection = new TimelineInsertSection();
        TimelineEditSection editSection = new TimelineEditSection();
        TimelineStatusSection statusSection = new TimelineStatusSection();
        TimelineSettingsSection settingsSection = new TimelineSettingsSection();
        DroptaskSection droptaskImageSection = new DroptaskSection();
        timelineTabContent.add(viewsSection);
        timelineTabContent.add(insertSection);
        timelineTabContent.add(editSection);
        timelineTabContent.add(statusSection);
        timelineTabContent.add(settingsSection);
        timelineTabContent.add(droptaskImageSection);
        Color highlight = Color.decode("#f7a85d");
        Color background = Color.decode("#f8dcc2");
        Color text = Color.decode("#b25d24");
        ContextTabTopper topper = new ContextTabTopper(highlight, background, text);
        Tab timelineTab = new Tab(this, timelineTabContent, "timeline", topper);
        timelineTab.setTopperText(TIMELINE_BUTTON_TEXT);
        return timelineTab;
    }

    public void addFastCaptureContextTab() {
        this.addTab(FAST_CAPTURE_BUTTON_TEXT, this._fastCaptureTab);
        this.setSelectedComponent(this._fastCaptureTab);
        this.lockTab(this._fastCaptureTab);
    }

    public void hideFastCaptureContextTab() {
        this.maybeGoToPreviousTab(this._fastCaptureTab);
        this.remove(this._fastCaptureTab);
        this._fastCaptureTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isFastCaptureTabAdded() {
        return this.indexOfComponent(this._fastCaptureTab) > -1;
    }

    public void addTimelineContextTab() {
        this.addTab(TIMELINE_BUTTON_TEXT, this._timelineTab);
        this.setSelectedComponent(this._timelineTab);
        this.lockTab(this._timelineTab);
    }

    public void hideTimelineContextTab() {
        this.maybeGoToPreviousTab(this._timelineTab);
        this.remove(this._timelineTab);
        this._timelineTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isTimelineTabAdded() {
        return this.indexOfComponent(this._timelineTab) > -1;
    }

    public void addBrainstormContextTab() {
        this.addTab(BRAINSTORMING_BUTTON_TEXT, this._brainstormTab);
        this.setSelectedComponent(this._brainstormTab);
        this.lockTab(this._brainstormTab);
    }

    public void hideBrainstormContextTab() {
        this.maybeGoToPreviousTab(this._brainstormTab);
        this.remove(this._brainstormTab);
        this._brainstormTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isBrainstormTabAdded() {
        return this.indexOfComponent(this._brainstormTab) > -1;
    }

    public void addBranchContextTab() {
        try {
            if (!this.containsTab(this._branchTab)) {
                this.addTab(BRANCH_BUTTON_TEXT, this._branchTab);
                this.setSelectedComponent(this._branchTab);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean containsTab(Tab tab) {
        for (Component c : this.getComponents()) {
            if (c != tab) continue;
            return true;
        }
        return false;
    }

    public void hideBranchContextTab() {
        this.maybeGoToPreviousTab(this._branchTab);
        this.remove(this._branchTab);
        this._branchTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isBranchTabAdded() {
        return this.indexOfComponent(this._branchTab) > -1;
    }

    public void addProjectContextTab() {
        this.addTab(PROJECT_BUTTON_TEXT, this._projectTab);
        this.setSelectedComponent(this._projectTab);
    }

    public void hideProjectContextTab() {
        this.maybeGoToPreviousTab(this._projectTab);
        this.remove(this._projectTab);
        this._projectTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isProjectTabAdded() {
        return this.indexOfComponent(this._projectTab) > -1;
    }

    public void addCommentsContextTab() {
        this.addTab(COMMENTS_BUTTON_TEXT, this._commentsTab);
        this.setSelectedComponent(this._commentsTab);
    }

    public void hideCommentsContextTab() {
        this.maybeGoToPreviousTab(this._commentsTab);
        this.remove(this._commentsTab);
        this._commentsTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public boolean isCommentsTabAdded() {
        return this.indexOfComponent(this._commentsTab) > -1;
    }

    public void addPresentationContextTab() {
        this.addTab(PRESENTATION_BUTTON_TEXT, this._presentationTab);
        this.setSelectedComponent(this._presentationTab);
        this.lockTab(this._presentationTab);
    }

    public void hidePresentationContextTab() {
        this.maybeGoToPreviousTab(this._presentationTab);
        this.remove(this._presentationTab);
        this._presentationTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
        this.unlockTabs();
    }

    public boolean isPresentationTabAdded() {
        return this.indexOfComponent(this._presentationTab) > -1;
    }

    public void addSketchContextTab() {
        this.addTab(SKETCH_BUTTON_TEXT, this._sketchTab);
        this.setSelectedComponent(this._sketchTab);
        this.lockTab(this._sketchTab);
    }

    public void hideSketchContextTab() {
        this.maybeGoToPreviousTab(this._sketchTab);
        this.remove(this._sketchTab);
        this._sketchTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
        this.unlockTabs();
    }

    public boolean isSketchTabAdded() {
        return this.indexOfComponent(this._sketchTab) > -1;
    }

    public void goToPreviousTab() {
        this.goToPreviousTab(false);
    }

    public void goToPreviousTab(boolean ignoreCollapse) {
        if (this.indexOfComponent(this._fastCaptureTab) >= 0) {
            this.setSelectedComponent(this._fastCaptureTab);
        } else if (this.indexOfComponent(this._brainstormTab) >= 0) {
            this.setSelectedComponent(this._brainstormTab);
        } else if (this.indexOfComponent(this._presentationTab) >= 0) {
            this.setSelectedComponent(this._presentationTab);
        } else if (this.indexOfComponent(this._sketchTab) >= 0) {
            this.setSelectedComponent(this._sketchTab);
        } else if (this.indexOfComponent(this._timelineTab) >= 0) {
            this.setSelectedComponent(this._timelineTab);
        } else {
            this.setSelectedComponent(this._homeTab);
        }
        if (this.isCollapsed() && !ignoreCollapse) {
            this.expand();
        }
    }

    private void maybeGoToPreviousTab(Tab currentTab) {
        if (this.getSelectedComponent() == currentTab) {
            this.goToPreviousTab(true);
        }
    }

    public void hideContextTabs() {
        if (this._selectedTab.IsContextTab()) {
            this.goToPreviousTab(true);
        }
        this.remove(this._fastCaptureTab);
        this.remove(this._brainstormTab);
        this.remove(this._branchTab);
        this.remove(this._projectTab);
        this.remove(this._commentsTab);
        this.remove(this._presentationTab);
        this.remove(this._sketchTab);
        this.remove(this._timelineTab);
        this._fastCaptureTab.setTopperBounds(0, 0, 0, 0);
        this._brainstormTab.setTopperBounds(0, 0, 0, 0);
        this._branchTab.setTopperBounds(0, 0, 0, 0);
        this._projectTab.setTopperBounds(0, 0, 0, 0);
        this._commentsTab.setTopperBounds(0, 0, 0, 0);
        this._presentationTab.setTopperBounds(0, 0, 0, 0);
        this._sketchTab.setTopperBounds(0, 0, 0, 0);
        this._timelineTab.setTopperBounds(0, 0, 0, 0);
        this._topBar.revalidate();
        this._topBar.repaint();
    }

    public void collapse() {
        if (!this._isCollapsed) {
            this._isCollapsed = true;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.setForegroundAt(i, this._homeTab.getForegroundColour());
            }
            this.revalidate();
            if (this.fullScreenListener != null) {
                MindMapFrame.FullScreenMouseListener listener = this.fullScreenListener;
                this.removeFullScreenMouseListener(this.fullScreenListener);
                this.addFullScreenMouseListener(listener);
                listener.hide();
            }
        }
    }

    public void expand() {
        if (this._isCollapsed) {
            this._isCollapsed = false;
            this.revalidate();
            if (this.fullScreenListener != null) {
                MindMapFrame.FullScreenMouseListener listener = this.fullScreenListener;
                this.removeFullScreenMouseListener(this.fullScreenListener);
                this.addFullScreenMouseListener(listener);
            }
        }
    }

    public void lockTab(Tab tab) {
        for (int i = 1; i < this.getComponentCount(); ++i) {
            this.setEnabledAt(i, false);
        }
        int index = this.indexOfComponent(tab);
        if (index >= 0) {
            this.setEnabledAt(index, true);
        }
        if (tab != null) {
            this.setSelectedComponent(tab);
        } else {
            this.setSelectedIndex(0);
        }
    }

    public void unlockTabs() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.setEnabledAt(i, true);
        }
        int x = this.indexOfComponent(this.getSelectedComponent());
        if (x > 0) {
            this.setSelectedIndex(1);
        } else {
            this.setSelectedIndex(x);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superDim = super.getPreferredSize();
        int width = (int)Math.max(superDim.getWidth(), PREF_SIZE.getWidth());
        int height = this._isCollapsed ? 26 : (int)Math.min(superDim.getHeight(), PREF_SIZE.getHeight());
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Border getBorder() {
        return BorderFactory.createMatteBorder(0, 0, 1, 0, LINE_COLOUR);
    }

    public void lockTabs() {
        this.lockTab(null);
    }
}

