/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.design;

import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.RibbonSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.scrollabletilepanel.ScrollableTilePanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.scrollabletilepanel.ScrollableTilePanelTile;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.entities.Theme;
import com.thinkbuzan.gaia.theme.listener.ThemeEvent;
import com.thinkbuzan.gaia.theme.listener.ThemesListener;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MapStyleSection
extends RibbonSection {
    private static final String TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.mapstyle");
    private ThemeManager themeManager;
    private final ScrollableTilePanel _scrollableTilePanel;
    private final JPopupMenu _rightClickMenu = this.createRightClickMenu();
    private ScrollableTilePanelTile _selectedTile;
    private Theme _rightClickTheme;
    private HashMap<UUID, ScrollableTilePanelTile> _tileMap = new HashMap();
    private JMenuItem _remove;

    public MapStyleSection() {
        super(TITLE);
        this._scrollableTilePanel = new ScrollableTilePanel();
        ServiceManager.addThemeManagerServiceListener(new IServiceListener<ThemeManager>(){

            public void serviceRemoved(ThemeManager service) {
            }

            public void serviceAdded(ThemeManager service) {
                MapStyleSection.this.initialise();
                service.addThemesListener(new ThemesListener(){

                    public void themesChanged(ThemeEvent themeEvent) {
                        switch (themeEvent.getType()) {
                            case THEMES_CHANGED: {
                                MapStyleSection.this.initialise();
                                break;
                            }
                            case THEMES_SELECTION_CHANGED: {
                                ScrollableTilePanelTile selected;
                                Theme selectedTheme = MapStyleSection.this.themeManager.getSelectedTheme();
                                if (selectedTheme == null || (selected = (ScrollableTilePanelTile)MapStyleSection.this._tileMap.get(selectedTheme.getUUID())) == null || MapStyleSection.this._selectedTile == selected) break;
                                if (MapStyleSection.this._selectedTile != null) {
                                    MapStyleSection.this._selectedTile.setSelected(false);
                                }
                                selected.setSelected(true);
                                MapStyleSection.this._selectedTile = selected;
                            }
                        }
                    }
                });
            }
        });
        this.getContentPanel().setLayout(new BoxLayout(this.getContentPanel(), 0));
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
        this.getContentPanel().add(this.wrapForAlignment(this._scrollableTilePanel, 0));
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
    }

    private void initialise() {
        try {
            this.themeManager = ServiceManager.getThemeManager();
            List themes = this.themeManager.getThemes();
            int page = this._scrollableTilePanel.getPageNumber();
            this._scrollableTilePanel.removeAllTiles();
            this._tileMap.clear();
            for (final Theme theme : themes) {
                BufferedImage thumb = this.themeManager.getThumbnail(theme, false);
                JPanel themePanel = new JPanel();
                themePanel.setOpaque(false);
                themePanel.setLayout(new BorderLayout());
                JLabel imageLabel = new JLabel(new ImageIcon(thumb));
                imageLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                JLabel titleLabel = new JLabel(theme.getName(), 0);
                titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)10.0f));
                themePanel.add((Component)imageLabel, "Center");
                themePanel.add((Component)titleLabel, "South");
                final ScrollableTilePanelTile tile = new ScrollableTilePanelTile(themePanel);
                this._tileMap.put(theme.getUUID(), tile);
                tile.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 1) {
                            ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeByIdAction", new Object[]{theme.getUUID().toString()});
                            if (MapStyleSection.this._selectedTile != null) {
                                MapStyleSection.this._selectedTile.setSelected(false);
                            }
                            tile.setSelected(true);
                            MapStyleSection.this._selectedTile = tile;
                        } else if (e.getButton() == 3) {
                            MapStyleSection.this._remove.setEnabled(theme.isUserDefined());
                            MapStyleSection.this._rightClickTheme = theme;
                            MapStyleSection.this._rightClickMenu.show(tile, e.getX(), e.getY());
                        }
                    }
                });
                this._scrollableTilePanel.addTile(tile);
            }
            this._scrollableTilePanel.setPageNumber(page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPopupMenu createRightClickMenu() {
        JPopupMenu rightClickMenu = new JPopupMenu();
        JMenuItem setAsDefault = new JMenuItem(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.setAsDefault"));
        this._remove = new JMenuItem(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.remove"));
        setAsDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (MapStyleSection.this._rightClickTheme != null) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetDefaultThemeByIdAction", new Object[]{MapStyleSection.this._rightClickTheme.getUUID().toString()});
                }
            }
        });
        this._remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (MapStyleSection.this._rightClickTheme != null && MapStyleSection.this._rightClickTheme.isUserDefined()) {
                    String title = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.deleteStyle");
                    String message = MessageFormat.format(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.confirmDelete"), MapStyleSection.this._rightClickTheme.getName());
                    String acceptText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.yes");
                    String cancelText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.no");
                    ModalOptionDialog.SelectedModalOptionDialogOption option = ModalOptionDialog.showAcceptCancelDialog((Frame)MainFrameUtilities.getMainFrame(), (String)title, (String)message, (String)acceptText, (String)cancelText);
                    if (option == ModalOptionDialog.SelectedModalOptionDialogOption.ACCEPT) {
                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.RemoveThemeByIdAction", new Object[]{MapStyleSection.this._rightClickTheme.getUUID().toString()});
                    }
                }
            }
        });
        rightClickMenu.add(setAsDefault);
        rightClickMenu.add(this._remove);
        return rightClickMenu;
    }
}

