/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file;

import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenuSidebarBackButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenuSidebarItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenuSidebarMenuItem;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class FileMenuSidebar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int TOP_PADDING = 5;
    private static final int PADDING = 3;
    private FileMenuSidebarBackButton _backButton;
    private FileMenuSidebarMenuItem _newItem;
    private FileMenuSidebarMenuItem _newFromTemplateItem;
    private FileMenuSidebarMenuItem _openItem;
    private FileMenuSidebarMenuItem _saveItem;
    private FileMenuSidebarMenuItem _saveAsItem;
    private FileMenuSidebarMenuItem _saveAllItem;
    private FileMenuSidebarMenuItem _printItem;
    private FileMenuSidebarMenuItem _cloudFilesItem;
    private FileMenuSidebarMenuItem _cloudContactsItem;
    private FileMenuSidebarMenuItem _exportItem;
    private FileMenuSidebarMenuItem _closeItem;
    private FileMenuSidebarMenuItem _helpItem;
    private FileMenuSidebarMenuItem _optionsItem;
    private FileMenuSidebarMenuItem _exitItem;
    private static final String NEW_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.new");
    private static final String NEW_FROM_TEMPLATE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.newFromTemplate");
    private static final String OPEN_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.open");
    private static final String SAVE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.save");
    private static final String SAVE_AS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.saveAs");
    private static final String SAVE_ALL_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.saveAll");
    private static final String PRINT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.print");
    private static final String IMINDMAP_CLOUD_FILES_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.thinkbuzanCloudFiles");
    private static final String IMINDMAP_CLOUD_CONTACTS_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.thinkbuzanCloudContacts");
    private static final String EXPORT_AND_SHARE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.exportandshare");
    private static final String CLOSE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.close");
    private static final String HELP_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.help");
    private static final String OPTIONS_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.options");
    private static final String EXIT_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.exit");

    @Override
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color color1 = Color.decode("#67C2DE");
        Color color2 = Color.decode("#2698B1");
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 0.0f, h, color2);
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, w, h);
    }

    public FileMenuSidebar() {
        this.setLayout(new BoxLayout(this, 3));
        this._backButton = new FileMenuSidebarBackButton();
        this.disableBackButtonIfNoEditor();
        this._newItem = new FileMenuSidebarMenuItem(NEW_BUTTON_TEXT);
        this._newFromTemplateItem = new FileMenuSidebarMenuItem(NEW_FROM_TEMPLATE_BUTTON_TEXT);
        this._openItem = new FileMenuSidebarMenuItem(OPEN_BUTTON_TEXT);
        this._saveItem = new FileMenuSidebarMenuItem(SAVE_BUTTON_TEXT);
        this._saveAsItem = new FileMenuSidebarMenuItem(SAVE_AS_BUTTON_TEXT);
        this._saveAllItem = new FileMenuSidebarMenuItem(SAVE_ALL_BUTTON_TEXT);
        this._printItem = new FileMenuSidebarMenuItem(PRINT_BUTTON_TEXT);
        this._cloudFilesItem = new FileMenuSidebarMenuItem(IMINDMAP_CLOUD_FILES_TEXT);
        this._cloudContactsItem = new FileMenuSidebarMenuItem(IMINDMAP_CLOUD_CONTACTS_TEXT);
        this._exportItem = new FileMenuSidebarMenuItem(EXPORT_AND_SHARE_BUTTON_TEXT);
        this._closeItem = new FileMenuSidebarMenuItem(CLOSE_BUTTON_TEXT);
        this._helpItem = new FileMenuSidebarMenuItem(HELP_BUTTON_TEXT);
        this._optionsItem = new FileMenuSidebarMenuItem(OPTIONS_BUTTON_TEXT);
        this._exitItem = new FileMenuSidebarMenuItem(EXIT_BUTTON_TEXT);
        this.setupSelection();
        this.add(Box.createVerticalStrut(5));
        this.add(this._backButton);
        this.add(Box.createVerticalStrut(3));
        this.add(this._newItem);
        if (BundleLicenser.isTemplatesLicensed() || BundleLicenser.isWizardsLicensed()) {
            this.add(Box.createVerticalStrut(3));
            this.add(this._newFromTemplateItem);
        }
        this.add(Box.createVerticalStrut(3));
        this.add(this._openItem);
        this.add(Box.createVerticalStrut(28));
        this.add(this._cloudFilesItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._cloudContactsItem);
        this.add(Box.createVerticalStrut(28));
        this.add(this._saveItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._saveAsItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._saveAllItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._printItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._exportItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._closeItem);
        this.add(Box.createVerticalStrut(28));
        this.add(this._helpItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._optionsItem);
        this.add(Box.createVerticalStrut(3));
        this.add(this._exitItem);
    }

    private void disableBackButtonIfNoEditor() {
        this._backButton.setEnabled(false);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                service.addEditorViewListener(new IEditorViewListener(){

                    public void editorChanged(IEditorView editor) {
                        FileMenuSidebar.this._backButton.setEnabled(editor != null);
                    }
                });
            }
        });
    }

    private void setupSelection() {
        this._newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenuSidebar.this.selectItem(FileMenuSidebar.this._newItem);
            }
        });
        this._newFromTemplateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenuSidebar.this.selectItem(FileMenuSidebar.this._newFromTemplateItem);
            }
        });
        this._openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenuSidebar.this.selectItem(FileMenuSidebar.this._openItem);
            }
        });
        this._saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenuSidebar.this.selectItem(FileMenuSidebar.this._saveAsItem);
            }
        });
    }

    public final void selectItem(FileMenuSidebarMenuItem item) {
        this.deselectAll();
        item.setSelected(true);
    }

    public final void deselectAll() {
        this._newItem.setSelected(false);
        this._newItem.setOpaque(false);
        this._newFromTemplateItem.setSelected(false);
        this._newFromTemplateItem.setOpaque(false);
        this._openItem.setSelected(false);
        this._openItem.setOpaque(false);
        this._saveAsItem.setSelected(false);
        this._saveAsItem.setOpaque(false);
        this.repaint();
    }

    public final FileMenuSidebarItem getBackButton() {
        return this._backButton;
    }

    public final FileMenuSidebarMenuItem getNewMenuItem() {
        return this._newItem;
    }

    public final FileMenuSidebarMenuItem getNewFromTemplateMenuItem() {
        return this._newFromTemplateItem;
    }

    public final FileMenuSidebarMenuItem getOpenMenuItem() {
        return this._openItem;
    }

    public final FileMenuSidebarMenuItem getSaveMenuItem() {
        return this._saveItem;
    }

    public final FileMenuSidebarMenuItem getSaveAsMenuItem() {
        return this._saveAsItem;
    }

    public final FileMenuSidebarMenuItem getSaveAllMenuItem() {
        return this._saveAllItem;
    }

    public final FileMenuSidebarMenuItem getPrintMenuItem() {
        return this._printItem;
    }

    public final FileMenuSidebarMenuItem getCloudFilesMenuItem() {
        return this._cloudFilesItem;
    }

    public final FileMenuSidebarMenuItem getCloudContactsMenuItem() {
        return this._cloudContactsItem;
    }

    public final FileMenuSidebarMenuItem getExportMenuItem() {
        return this._exportItem;
    }

    public final FileMenuSidebarMenuItem getCloseMenuItem() {
        return this._closeItem;
    }

    public final FileMenuSidebarMenuItem getHelpMenuItem() {
        return this._helpItem;
    }

    public final FileMenuSidebarMenuItem getOptionsMenuItem() {
        return this._optionsItem;
    }

    public final FileMenuSidebarMenuItem getExitMenuItem() {
        return this._exitItem;
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension superDim = super.getPreferredSize();
        return new Dimension(200, superDim.height);
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

