/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class FileMenuSidebarItem
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final int HEIGHT = 28;
    public static final int WIDTH = 200;
    protected static final Dimension SIZE = new Dimension(200, 28);
    private boolean _selected;
    private ArrayList<ActionListener> _actionListeners = new ArrayList();

    public final void setSelected(boolean selected) {
        this.setOpaque(false);
        this._selected = selected;
        if (selected) {
            this.setOpaque(true);
            this.setBackground(Color.decode("#2a8dd4"));
        } else {
            this.setOpaque(false);
        }
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public FileMenuSidebarItem() {
        this.addMouseListener(this);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(210, 28);
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this._actionListeners.contains(actionListener)) {
            this._actionListeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this._actionListeners.remove(actionListener);
    }

    private void fireActionListeners(ActionEvent e) {
        for (ActionListener actionListener : this._actionListeners) {
            actionListener.actionPerformed(e);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        if (this.isEnabled()) {
            ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "mouseClicked");
            this.fireActionListeners(ae);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.setOpaque(true);
            this.setBackground(Color.decode("#2a8dd4"));
        }
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.setOpaque(false);
        if (this.isEnabled() && !this.isSelected()) {
            this.setBackground(Color.decode("#0067b0"));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setSelected(false);
        }
    }
}

