/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab.HeaderPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class CanvasOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int BORDER_THICKNESS = 5;
    private static final Color BORDER_UNSELECTED_COLOUR = Color.decode("#67C2DE");
    private static final Color BORDER_SELECTED_COLOUR = Color.decode("#2698B1");
    private static final Color BORDER_HOVER_COLOUR = BORDER_UNSELECTED_COLOUR;
    public static final int BRAINSTORM = 0;
    public static final int PROFESSIONAL = 1;
    public static final int BUZAN = 2;
    public static final int TEMPLATE = 3;
    public static final int WIZARD = 4;
    public static final int FAST_CAPTURE = 5;
    public static final int ACTION = 6;
    public static final int TIMELINE = 7;
    private static final String BRAINSTORM_IMAGE_FILENAME = "file/start_organise.png";
    private static final String PROFESSIONAL_IMAGE_FILENAME = "file/start_develop.png";
    private static final String BUZAN_IMAGE_FILENAME = "file/buzan.png";
    private static final String TEMPLATE_IMAGE_FILENAME = "file/template.png";
    private static final String WIZARD_IMAGE_FILENAME = "file/wizard.png";
    private static final String FAST_CAPTURE_IMAGE_FILENAME = "file/start_capture.png";
    private static final String ACTION_IMAGE_FILENAME = "file/start_action.png";
    private static final String TIMELINE_IMAGE_FILENAME = "file/start_timeline.png";
    private static final String FAST_CAPTURE_ICONNAME = "file/embedded_capture";
    private static final String PROFESSIONAL_ICONNAME = "file/embedded_professional_mindmap";
    private static final String TIMELINE_ICONNAME = "file/embedded_timemap";
    private static final String BRAINSTORM_ICONNAME = "file/embedded_brainstorm";
    private static final String ACTIVE = "_active";
    private static final String PNG = ".png";
    private static final String BRAINSTORM_HOME_FILENAME = "file/home_brainstorm.png";
    private static final String PROFESSIONAL_HOME_FILENAME = "file/home_mind_map.png";
    private static final String FAST_CAPTURE_HOME_FILENAME = "file/home_fast_capture.png";
    private static final String TIMELINE_HOME_FILENAME = "file/home_time_map.png";
    private final transient Dimension SIZE = new Dimension(178, 120);
    private final transient JLabel label;
    private final transient HeaderPanel header;
    private Border _border;
    private Border _hoverBorder;
    private Border _selectedBorder;
    private boolean _selected;
    private boolean _compact;

    public final boolean isSelected() {
        return this._selected;
    }

    public final void setSelected(boolean selected) {
        this._selected = selected;
        if (this._selected) {
            this.setBorder(this._selectedBorder);
            this.setBackground(BORDER_SELECTED_COLOUR);
            this.repaint();
        } else {
            this.setBorder(this._border);
            this.setBackground(BORDER_UNSELECTED_COLOUR);
            this.repaint();
        }
        if (this.label != null) {
            this.label.setForeground(Color.WHITE);
        }
    }

    public final void setCompact(boolean isCompact) {
        this._compact = isCompact;
    }

    public final boolean isCompact() {
        return this._compact;
    }

    public final void clearBorder() {
        this.setBorder(null);
        this.setBackground(null);
        this._selected = false;
        if (this.header != null) {
            this.header.setSelected(false);
        }
        this.repaint();
    }

    public CanvasOptionsPanel(int type, String text, String description) {
        this._border = BorderFactory.createEmptyBorder();
        this._hoverBorder = BorderFactory.createEmptyBorder();
        this._selectedBorder = BorderFactory.createEmptyBorder();
        String filename = "";
        String iconName = "";
        switch (type) {
            case 0: {
                filename = BRAINSTORM_HOME_FILENAME;
                iconName = BRAINSTORM_ICONNAME;
                break;
            }
            case 1: {
                filename = PROFESSIONAL_HOME_FILENAME;
                iconName = PROFESSIONAL_ICONNAME;
                break;
            }
            case 5: {
                filename = FAST_CAPTURE_HOME_FILENAME;
                iconName = FAST_CAPTURE_ICONNAME;
                break;
            }
            case 7: {
                filename = TIMELINE_HOME_FILENAME;
                iconName = TIMELINE_ICONNAME;
                break;
            }
            default: {
                Logger.getLogger(this.getClass()).warn((Object)("view type error: " + type));
            }
        }
        this.setLayout(new BorderLayout());
        this.setBorder(this._border);
        ImageIcon unselected = ResourceManager.getImageIcon(iconName + PNG, 0);
        ImageIcon selected = ResourceManager.getImageIcon(iconName + ACTIVE + PNG, 0);
        this.header = new HeaderPanel(text, selected, unselected);
        this.label = null;
        JPanel displayDetails = new JPanel();
        displayDetails.setLayout(new BorderLayout());
        displayDetails.setBackground(Color.WHITE);
        JTextArea details = new JTextArea();
        details.setOpaque(false);
        details.setEditable(false);
        details.setLineWrap(true);
        details.setWrapStyleWord(true);
        details.setText(description);
        details.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        details.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        details.setForeground(Color.GRAY);
        details.setBackground(Color.WHITE);
        displayDetails.add((Component)details, "Center");
        JSeparator sep = new JSeparator(1);
        sep.setForeground(Color.GRAY);
        JPanel thumbnail = new JPanel(new BorderLayout());
        thumbnail.setOpaque(false);
        thumbnail.add((Component)new JLabel(ResourceManager.getImageIcon(filename, 0)), "Center");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        content.add(thumbnail);
        content.add(sep);
        content.add(displayDetails);
        content.setBackground(Color.WHITE);
        this.add((Component)this.header, "North");
        this.add((Component)content, "Center");
        this.addMouseListener(this.createMouseAdapter(false));
        details.addMouseListener(this.createMouseAdapter(true));
    }

    private MouseAdapter createMouseAdapter(final boolean forward) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (forward) {
                    CanvasOptionsPanel.this.header.setHover(false);
                    MouseEvent event = new MouseEvent(CanvasOptionsPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    CanvasOptionsPanel.this.dispatchEvent(event);
                } else {
                    CanvasOptionsPanel.this.header.setHover(false);
                    super.mouseClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (!CanvasOptionsPanel.this._selected) {
                    CanvasOptionsPanel.this.header.setSelected(false);
                    CanvasOptionsPanel.this.header.setHover(true);
                } else {
                    CanvasOptionsPanel.this.header.setSelected(true);
                    CanvasOptionsPanel.this.header.setHover(false);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                if (!CanvasOptionsPanel.this._selected) {
                    CanvasOptionsPanel.this.header.setSelected(false);
                    CanvasOptionsPanel.this.header.setHover(false);
                } else {
                    CanvasOptionsPanel.this.header.setSelected(true);
                    CanvasOptionsPanel.this.header.setHover(false);
                }
            }
        };
    }

    public CanvasOptionsPanel(int type, String text) {
        this._border = BorderFactory.createEmptyBorder(5, 5, 2, 5);
        this._hoverBorder = BorderFactory.createMatteBorder(5, 5, 2, 5, BORDER_HOVER_COLOUR);
        this._selectedBorder = BorderFactory.createMatteBorder(5, 5, 2, 5, BORDER_SELECTED_COLOUR);
        String filename = "";
        switch (type) {
            case 0: {
                filename = BRAINSTORM_IMAGE_FILENAME;
                break;
            }
            case 1: {
                filename = PROFESSIONAL_IMAGE_FILENAME;
                break;
            }
            case 2: {
                filename = BUZAN_IMAGE_FILENAME;
                break;
            }
            case 3: {
                filename = TEMPLATE_IMAGE_FILENAME;
                break;
            }
            case 4: {
                filename = WIZARD_IMAGE_FILENAME;
                break;
            }
            case 5: {
                filename = FAST_CAPTURE_IMAGE_FILENAME;
                break;
            }
            case 6: {
                filename = ACTION_IMAGE_FILENAME;
                break;
            }
            case 7: {
                filename = TIMELINE_IMAGE_FILENAME;
                break;
            }
            default: {
                Logger.getLogger(this.getClass()).warn((Object)("file type error: " + type));
            }
        }
        this.header = null;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(ResourceManager.getImageIcon(filename, 0)));
        this.add(Box.createVerticalStrut(2));
        this.label = new JLabel(text + " ", 2);
        this.label.setFont(ApplicationFont.getRegularFont((int)0, (float)15.0f));
        this.label.setForeground(Color.WHITE);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add(this.label);
        this.setBorder(this._border);
        this.setBackground(BORDER_UNSELECTED_COLOUR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (!CanvasOptionsPanel.this._selected) {
                    CanvasOptionsPanel.this.setBorder(CanvasOptionsPanel.this._hoverBorder);
                    CanvasOptionsPanel.this.setBackground(BORDER_HOVER_COLOUR);
                    CanvasOptionsPanel.this.label.setForeground(BORDER_SELECTED_COLOUR);
                } else {
                    CanvasOptionsPanel.this.setBorder(CanvasOptionsPanel.this._selectedBorder);
                    CanvasOptionsPanel.this.setBackground(BORDER_SELECTED_COLOUR);
                    CanvasOptionsPanel.this.label.setForeground(Color.WHITE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                if (!CanvasOptionsPanel.this._selected) {
                    CanvasOptionsPanel.this.setBorder(CanvasOptionsPanel.this._border);
                    CanvasOptionsPanel.this.setBackground(BORDER_UNSELECTED_COLOUR);
                } else {
                    CanvasOptionsPanel.this.setBorder(CanvasOptionsPanel.this._selectedBorder);
                    CanvasOptionsPanel.this.setBackground(BORDER_SELECTED_COLOUR);
                }
                CanvasOptionsPanel.this.label.setForeground(Color.WHITE);
            }
        });
    }

    private Dimension getDimensions() {
        if (this.header == null) {
            int h = Math.max(super.getMaximumSize().height, this.SIZE.height);
            return new Dimension(this.SIZE.width, h);
        }
        if (this._compact) {
            return new Dimension(245, 195);
        }
        return new Dimension(480, 250);
    }

    @Override
    public final Dimension getPreferredSize() {
        return this.getDimensions();
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getDimensions();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getDimensions();
    }
}

