/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class DropShadowBorder
implements Border {
    private static final Map<Integer, Map<Position, BufferedImage>> CACHE = new HashMap<Integer, Map<Position, BufferedImage>>();
    private final transient Color lineColor;
    private final transient int lineWidth;
    private final transient int shadowSize;
    private final transient float shadowOpacity;
    private final transient int cornerSize;
    private final transient boolean showTopShadow;
    private final transient boolean showLeftShadow;
    private final transient boolean showBottomShadow;
    private final transient boolean showRightShadow;
    private static final int LINE_WIDTH = 1;
    private static final int SHADOW_SIZE = 5;
    private static final float ALPHA = 0.7f;
    private static final int CONER_SIZE_IN = 12;

    public DropShadowBorder() {
        this(UIManager.getColor("Control"), 1, 5);
    }

    public DropShadowBorder(Color lineColorIn, int lineWidthIn, int shadowSizeIn) {
        this(lineColorIn, lineWidthIn, shadowSizeIn, false, false, true, true);
    }

    public DropShadowBorder(Color lineColorIn, int lineWidthIn, boolean showLeftShadowIn) {
        this(lineColorIn, lineWidthIn, 5, false, showLeftShadowIn, true, true);
    }

    public DropShadowBorder(Color lineColorIn, int lineWidthIn, int shadowSizeIn, boolean showTopShadowIn, boolean showLeftShadowIn, boolean showBottomShadowIn, boolean showRightShadowIn) {
        this.lineColor = lineColorIn;
        this.lineWidth = lineWidthIn;
        this.shadowSize = shadowSizeIn;
        this.shadowOpacity = 0.7f;
        this.cornerSize = 12;
        this.showTopShadow = showTopShadowIn;
        this.showLeftShadow = showLeftShadowIn;
        this.showBottomShadow = showBottomShadowIn;
        this.showRightShadow = showRightShadowIn;
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(this.lineColor);
        this.drawTopShadow(g2, x, y, width);
        this.drawLeftShadow(g2, x, y, height);
        this.drawBottomShadow(g2, x, y, width, height);
        this.drawRightShadow(g2, x, y, width, height);
        this.drawLeftOrTopShadow(g2, x, y);
        this.drawLeftOrBottomShadow(g2, x, y, height);
        this.drawRightOrTopShadow(g2, x, y, width);
        this.drawRightOrBottomShadow(g2, x, y, width, height);
    }

    private void drawLeftOrTopShadow(Graphics2D g2, int x, int y) {
        Point topLeftShadowPoint = this.getTopLeftShadowPoint(x, y);
        if ((this.showLeftShadow || this.showTopShadow) && topLeftShadowPoint != null) {
            g2.drawImage(this.getImages().get((Object)Position.TOP_LEFT), null, (int)topLeftShadowPoint.getX(), (int)topLeftShadowPoint.getY());
        }
    }

    private void drawLeftOrBottomShadow(Graphics2D g2, int x, int y, int height) {
        Point bottomLeftShadowPoint = this.getBottomLeftShadowPoint(x, y, height);
        if ((this.showLeftShadow || this.showBottomShadow) && bottomLeftShadowPoint != null) {
            g2.drawImage(this.getImages().get((Object)Position.BOTTOM_LEFT), null, (int)bottomLeftShadowPoint.getX(), (int)bottomLeftShadowPoint.getY());
        }
    }

    private void drawRightOrBottomShadow(Graphics2D g2, int x, int y, int width, int height) {
        Point bottomRightShadowPoint = this.getBottomRightShadowPoint(x, y, width, height);
        if ((this.showRightShadow || this.showBottomShadow) && bottomRightShadowPoint != null) {
            g2.drawImage(this.getImages().get((Object)Position.BOTTOM_RIGHT), null, (int)bottomRightShadowPoint.getX(), (int)bottomRightShadowPoint.getY());
        }
    }

    private void drawRightOrTopShadow(Graphics2D g2, int x, int y, int width) {
        Point topRightShadowPoint = this.getTopRightShadowPoint(x, y, width);
        if ((this.showRightShadow || this.showTopShadow) && topRightShadowPoint != null) {
            g2.drawImage(this.getImages().get((Object)Position.TOP_RIGHT), null, (int)topRightShadowPoint.getX(), (int)topRightShadowPoint.getY());
        }
    }

    private void drawTopShadow(Graphics2D g2, int x, int y, int width) {
        Point topLeftShadowPoint = this.getTopLeftShadowPoint(x, y);
        Point topRightShadowPoint = this.getTopRightShadowPoint(x, y, width);
        if (this.showTopShadow && topLeftShadowPoint != null && topRightShadowPoint != null) {
            Rectangle topShadowRect = new Rectangle((int)topLeftShadowPoint.getX() + this.shadowSize, y, (int)(topRightShadowPoint.getX() - topLeftShadowPoint.getX() - (double)this.shadowSize), this.shadowSize);
            g2.drawImage(this.getImages().get((Object)Position.TOP).getScaledInstance(topShadowRect.width, topShadowRect.height, 2), topShadowRect.x, topShadowRect.y, null);
        }
    }

    private void drawLeftShadow(Graphics2D g2, int x, int y, int height) {
        Point topLeftShadowPoint = this.getTopLeftShadowPoint(x, y);
        Point bottomLeftShadowPoint = this.getBottomLeftShadowPoint(x, y, height);
        if (this.showLeftShadow && topLeftShadowPoint != null && bottomLeftShadowPoint != null) {
            Rectangle leftShadowRect = new Rectangle(x, (int)(topLeftShadowPoint.getY() + (double)this.shadowSize), this.shadowSize, (int)(bottomLeftShadowPoint.getY() - topLeftShadowPoint.getY() - (double)this.shadowSize));
            g2.drawImage(this.getImages().get((Object)Position.LEFT).getScaledInstance(leftShadowRect.width, leftShadowRect.height, 2), leftShadowRect.x, leftShadowRect.y, null);
        }
    }

    private void drawBottomShadow(Graphics2D g2, int x, int y, int width, int height) {
        Point bottomLeftShadowPoint = this.getBottomLeftShadowPoint(x, y, height);
        Point bottomRightShadowPoint = this.getBottomRightShadowPoint(x, y, width, height);
        if (this.showBottomShadow && bottomLeftShadowPoint != null && bottomRightShadowPoint != null) {
            Rectangle bottomShadowRect = new Rectangle((int)(bottomLeftShadowPoint.getX() + (double)this.shadowSize), y + height - this.shadowSize, (int)(bottomRightShadowPoint.getX() - bottomLeftShadowPoint.getX() - (double)this.shadowSize), this.shadowSize);
            g2.drawImage(this.getImages().get((Object)Position.BOTTOM).getScaledInstance(bottomShadowRect.width, bottomShadowRect.height, 2), bottomShadowRect.x, bottomShadowRect.y, null);
        }
    }

    private void drawRightShadow(Graphics2D g2, int x, int y, int width, int height) {
        Point bottomRightShadowPoint = this.getBottomRightShadowPoint(x, y, width, height);
        Point topRightShadowPoint = this.getTopRightShadowPoint(x, y, width);
        if (this.showRightShadow && bottomRightShadowPoint != null && topRightShadowPoint != null) {
            Rectangle rightShadowRect = new Rectangle(x + width - this.shadowSize, (int)(topRightShadowPoint.getY() + (double)this.shadowSize), this.shadowSize, (int)(bottomRightShadowPoint.getY() - topRightShadowPoint.getY() - (double)this.shadowSize));
            g2.drawImage(this.getImages().get((Object)Position.RIGHT).getScaledInstance(rightShadowRect.width, rightShadowRect.height, 2), rightShadowRect.x, rightShadowRect.y, null);
        }
    }

    private Point getTopLeftShadowPoint(int x, int y) {
        Point topLeftShadowPoint = null;
        if (this.showLeftShadow || this.showTopShadow) {
            topLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y + this.shadowSize);
            } else if (this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y);
            } else if (!this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x + this.shadowSize, y);
            }
        }
        return topLeftShadowPoint;
    }

    private Point getTopRightShadowPoint(int x, int y, int width) {
        Point topRightShadowPoint = null;
        if (this.showRightShadow || this.showTopShadow) {
            topRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y + this.shadowSize);
            } else if (this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y);
            } else if (!this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y);
            }
        }
        return topRightShadowPoint;
    }

    private Point getBottomLeftShadowPoint(int x, int y, int height) {
        Point bottomLeftShadowPoint = null;
        if (this.showLeftShadow || this.showBottomShadow) {
            bottomLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize);
            } else if (!this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x + this.shadowSize, y + height - this.shadowSize);
            }
        }
        return bottomLeftShadowPoint;
    }

    private Point getBottomRightShadowPoint(int x, int y, int width, int height) {
        Point bottomRightShadowPoint = null;
        if (this.showRightShadow || this.showBottomShadow) {
            bottomRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize);
            } else if (!this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y + height - this.shadowSize);
            }
        }
        return bottomRightShadowPoint;
    }

    private Map<Position, BufferedImage> getImages() {
        Map<Position, BufferedImage> images = CACHE.get(this.shadowSize);
        if (images == null) {
            images = new HashMap<Position, BufferedImage>();
            int rectWidth = this.cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, this.cornerSize, this.cornerSize);
            int imageWidth = rectWidth + this.shadowSize * 2;
            BufferedImage image = new BufferedImage(imageWidth, imageWidth, 2);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            buffer.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            buffer.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            buffer.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            buffer.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowOpacity));
            buffer.translate(this.shadowSize, this.shadowSize);
            buffer.fill(rect);
            float blurry = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] blurKernel = new float[this.shadowSize * this.shadowSize];
            for (int i = 0; i < blurKernel.length; ++i) {
                blurKernel[i] = blurry;
            }
            ConvolveOp blur = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, blurKernel));
            BufferedImage targetImage = new BufferedImage(imageWidth, imageWidth, 2);
            ((Graphics2D)targetImage.getGraphics()).drawImage(image, blur, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int x = 1;
            int y = 1;
            int w = this.shadowSize;
            int h = this.shadowSize;
            images.put(Position.TOP_LEFT, targetImage.getSubimage(x, y, w, h));
            x = 1;
            y = h;
            w = this.shadowSize;
            h = 1;
            images.put(Position.LEFT, targetImage.getSubimage(x, y, w, h));
            x = 1;
            y = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_LEFT, targetImage.getSubimage(x, y, w, h));
            x = this.cornerSize + 1;
            y = rectWidth;
            w = 1;
            h = this.shadowSize;
            images.put(Position.BOTTOM, targetImage.getSubimage(x, y, w, h));
            y = x = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_RIGHT, targetImage.getSubimage(x, y, w, h));
            x = rectWidth;
            y = this.cornerSize + 1;
            w = this.shadowSize;
            h = 1;
            images.put(Position.RIGHT, targetImage.getSubimage(x, y, w, h));
            x = rectWidth;
            y = 1;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.TOP_RIGHT, targetImage.getSubimage(x, y, w, h));
            x = this.shadowSize;
            y = 1;
            w = 1;
            h = this.shadowSize;
            images.put(Position.TOP, targetImage.getSubimage(x, y, w, h));
            buffer.dispose();
            image.flush();
        }
        return images;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.getTopBorderInsets(), this.getLeftBorderInsets(), this.getBottomBorderInsets(), this.getRightBorderInsets());
    }

    private int getTopBorderInsets() {
        if (this.showTopShadow) {
            return this.lineWidth + this.shadowSize;
        }
        return this.lineWidth;
    }

    private int getLeftBorderInsets() {
        if (this.showLeftShadow) {
            return this.lineWidth + this.shadowSize;
        }
        return this.lineWidth;
    }

    private int getBottomBorderInsets() {
        if (this.showBottomShadow) {
            return this.lineWidth + this.shadowSize;
        }
        return this.lineWidth;
    }

    private int getRightBorderInsets() {
        if (this.showRightShadow) {
            return this.lineWidth + this.shadowSize;
        }
        return this.lineWidth;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

