/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color BORDER_UNSELECTED_COLOUR = Color.decode("#67C2DE");
    private static final Color BORDER_SELECTED_COLOUR = Color.decode("#2698B1");
    private final transient ImageIcon active;
    private final transient ImageIcon inactive;
    private final transient JLabel icon;
    private final transient JLabel label;
    private transient boolean highlight;
    private boolean selected;

    public HeaderPanel(String text, ImageIcon activeIn, ImageIcon inactiveIn) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.active = activeIn;
        this.inactive = inactiveIn;
        this.icon = new JLabel(this.inactive);
        JPanel iconPanel = new JPanel();
        iconPanel.setOpaque(false);
        iconPanel.add(this.icon);
        this.label = new JLabel(text, 0);
        this.label.setFont(ApplicationFont.getRegularFont((int)0, (float)25.0f));
        this.label.setForeground(Color.WHITE);
        final Component box = Box.createHorizontalStrut(iconPanel.getPreferredSize().height);
        this.add((Component)iconPanel, "West");
        this.add((Component)this.label, "Center");
        this.add(box, "East");
        this.highlight = false;
        this.selected = false;
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){
            private transient boolean enabled = false;

            @Override
            public void ancestorResized(HierarchyEvent e) {
                super.ancestorResized(e);
                boolean bl = this.enabled = this.enabled || e.getComponent().getWidth() > 300;
                if (this.enabled && e.getComponent().getWidth() < 300) {
                    box.setVisible(false);
                } else {
                    box.setVisible(true);
                }
            }
        });
    }

    public final void setHover(boolean hoverIn) {
        this.highlight = hoverIn;
        this.updateIcon();
    }

    public final void setSelected(boolean selectedIn) {
        this.selected = selectedIn;
        this.updateIcon();
    }

    private void updateIcon() {
        if (this.selected || this.highlight) {
            this.icon.setIcon(this.active);
            this.label.setForeground(BORDER_UNSELECTED_COLOUR);
        } else {
            this.icon.setIcon(this.inactive);
            this.label.setForeground(Color.WHITE);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.selected || this.highlight) {
            g2d.setColor(Color.decode("#007390"));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BORDER_SELECTED_COLOUR, this.getWidth(), 0.0f, BORDER_UNSELECTED_COLOUR));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2d.dispose();
        super.paint(g);
    }
}

