/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab;

import com.thinkbuzan.apollo.dialogs.imagechooser.ImageChooser;
import com.thinkbuzan.apollo.ui.core.win.component.LabelButton;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab.CanvasOptionsPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab.DropShadowBorder;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import com.thinkbuzan.phoenix.licensing.LicenseType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class NewTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CREATIVE_THEME = "644b2a25-c97e-4cb2-8928-5cce7bba23d0";
    private static final String PRO_THEME = "f503e61f-5a7f-46b7-b94a-e05563ecc47d";
    private static final String BS_THEME = "20872e30-4e39-11e4-916c-0800200c9a66";
    private static final String FAST_CAPTURE_THEME = "FAST_CAPTURE_THEME";
    private static final String GET_DEFAULT_THEME = "defaultTheme";
    private static final String TIMELINE_THEME = "TIMELINE_THEME";
    private static final int WIDTH = 330;
    private static final Dimension SIZE = new Dimension(330, Integer.MAX_VALUE);
    private static final int NAME_WIDTH = 30;
    private static final int HINT_WIDTH = 40;
    private static final int FULL_HINT_WIDTH = 50;
    private static final Color FONT_COLOUR = Color.decode("#4e4e4e");
    private static final Color BORDER_COLOUR = Color.decode("#c6c6c6");
    private static final int PADDING = 20;
    private static final String BRAINSTORM_DEFAULT_CI_ID = "cec2c159-46de-4468-818e-9bbeb5e9039e";
    private static final UUID BRAINSTORM_DEFAULT_CI_UUID = UUID.fromString("cec2c159-46de-4468-818e-9bbeb5e9039e");
    private CanvasOptionsPanel _fastCaptureOptionPanel;
    private CanvasOptionsPanel _brainstormCanvasOptionPanel;
    private CanvasOptionsPanel _professionalCanvasOptionPanel;
    private CanvasOptionsPanel _timelineCanvasOptionPanel;
    private JPanel _fcPanel;
    private JPanel _bsPanel;
    private JPanel _ciPanel;
    private JPanel _mainPanel;
    private JPanel _tlPanel;
    private JPanel _infoPanel;
    private JTextField _fcNameTextField;
    private LabelButton _startFastCaptureButton;
    private JTextField _bsNameTextField;
    private LabelButton _startBrainstormButton;
    private JTextField _tlNameTextField;
    private LabelButton _startTimelineButton;
    private ImageChooser _ideaChooser;
    private IIdeaInserter ideaInserter;
    private FileMenu _fileMenu;
    private ButtonGroup _styleGroup;
    private static final String NAME_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.name");
    private static final String START_BRAINSTORMING_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.relationshipDialog.positionStart").toUpperCase();
    private static final String BROWSE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.browse").toUpperCase();
    private static final String START_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.projectview.start").toUpperCase();
    private static final String ORGANISE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.brainstorm");
    private static final String DEVELOP_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.mindMap");
    private static final String FAST_CAPTURE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.process.capture");
    private static final String FAST_CAPTURE_MESSAGE = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.win.ui.fastcapture.message");
    private static final String START_FAST_CAPTURE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.relationshipDialog.positionStart").toUpperCase();
    private static final String TIMELINE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.timeline");
    private static final String TIMELINE_MESSAGE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.view.timeline.windows.startmessage");
    private static final String START_TIMELINE_LABEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.relationshipDialog.positionStart").toUpperCase();
    private static final String ORGANISE_MESSAGE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.brainstorm.message");
    private static final String DEVELOP_MESSAGE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.mindmap.message");
    private static final String STYLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.style");
    private static final String STYLE_BUZAN_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newtab.mindmaptype.buzan");
    private static final String STYLE_PROF_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newtab.mindmaptype.professional");
    private static final String STYLE_DEFAULT_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.useDefault");
    private static final String NEW_VIEW_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.chooseView");
    public static final String SHARE_ID = "sharePanel";
    public static final String PRESENT_ID = "presentPanel";
    private static final String TWO = "2. ";
    private final Dimension HEADING_SIZE = new Dimension(500, 48);
    private final Dimension MESSAGE_SIZE = new Dimension(700, 68);
    private final String HTML_1 = "<html><body style='width: ";
    private final String HTML_2 = "px; text-align:left'>";
    private final String HTML_3 = "</html>";

    public NewTab(FileMenu fileMenu) {
        this._fileMenu = fileMenu;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOUR));
        this.ideaInserter = this.createIdeaInserter();
        this._ideaChooser = new ImageChooser(this.ideaInserter, ServiceManager.getI18n(), ServiceManager.getPendingTDViewInterface());
        this._fcPanel = this.createFCPanel();
        this._bsPanel = this.createBSPanel();
        this._ciPanel = this.createCIPanel();
        this._tlPanel = this.createTLPanel();
        this._mainPanel = this.createLeftPanel();
        this._infoPanel = this.createInfoPanel();
        if (ServiceManager.getPluginLicenseService().getLicense(false).getType().equals((Object)LicenseType.homestudent)) {
            this.remove(this._bsPanel);
            this.add((Component)this._mainPanel, "West");
            this.add((Component)this._ciPanel, "Center");
            this._professionalCanvasOptionPanel.setSelected(true);
        } else {
            this.add((Component)this._infoPanel, "Center");
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                NewTab.this._fastCaptureOptionPanel.clearBorder();
                NewTab.this._brainstormCanvasOptionPanel.clearBorder();
                NewTab.this._professionalCanvasOptionPanel.clearBorder();
                NewTab.this._timelineCanvasOptionPanel.clearBorder();
                NewTab.this.showInfoPanel();
            }
        });
    }

    public final void showInfoPanel() {
        if (ServiceManager.getPluginLicenseService().getLicense(false).getType().equals((Object)LicenseType.homestudent)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewTab.this._professionalCanvasOptionPanel.setSelected(true);
                    NewTab.this.remove(NewTab.this._ciPanel);
                    NewTab.this.remove(NewTab.this._bsPanel);
                    NewTab.this.add((Component)NewTab.this._ciPanel, "Center");
                    NewTab.this.repaint();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewTab.this.remove(NewTab.this._fcPanel);
                    NewTab.this.remove(NewTab.this._bsPanel);
                    NewTab.this.remove(NewTab.this._ciPanel);
                    NewTab.this.remove(NewTab.this._tlPanel);
                    NewTab.this.remove(NewTab.this._mainPanel);
                    NewTab.this.add((Component)NewTab.this._infoPanel, "Center");
                    NewTab.this.repaint();
                }
            });
        }
    }

    private IIdeaInserter createIdeaInserter() {
        return new IIdeaInserter(){

            public void start() {
                if (ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
                    String themeId = NewTab.this.getThemeId();
                    String name = NewTab.this.getCentralIdeaLabel();
                    UUID ideaId = themeId.equalsIgnoreCase(NewTab.TIMELINE_THEME) ? BRAINSTORM_DEFAULT_CI_UUID : (themeId.equals(NewTab.BS_THEME) || themeId.equals(NewTab.FAST_CAPTURE_THEME) ? BRAINSTORM_DEFAULT_CI_UUID : NewTab.this._ideaChooser.getSelectedIdeaId());
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{ideaId, themeId, name});
                    NewTab.this._fileMenu.getRibbon().goToPreviousTab();
                }
            }

            public void start(Image localSelected) {
            }
        };
    }

    private JPanel createFCPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(TWO + FAST_CAPTURE_LABEL_TEXT + " ", 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)48.0f));
        heading.setForeground(FONT_COLOUR);
        JTextArea subheading = new JTextArea();
        subheading.setEditable(false);
        subheading.setCursor(null);
        subheading.setOpaque(false);
        subheading.setFocusable(false);
        subheading.setLineWrap(true);
        subheading.setWrapStyleWord(true);
        subheading.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        subheading.setForeground(FONT_COLOUR);
        subheading.setColumns(40);
        subheading.setText(FAST_CAPTURE_MESSAGE);
        JLabel name = new JLabel(NAME_LABEL_TEXT + ":", 2);
        name.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        name.setForeground(FONT_COLOUR);
        name.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this._fcNameTextField = new JTextField();
        this._fcNameTextField.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        this._fcNameTextField.setColumns(30);
        Border inner = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        Border outer = BorderFactory.createLineBorder(Color.decode("#b7bdc6"));
        this._fcNameTextField.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this._fcNameTextField.setForeground(FONT_COLOUR);
        Locale locale = ServiceManager.getI18n().getUserLocale();
        if (!(locale == null || locale.toString().equalsIgnoreCase(Locale.JAPAN.toString()) || locale.toString().equalsIgnoreCase(Locale.JAPANESE.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINA.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINESE.toString()))) {
            this._fcNameTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        NewTab.this._startFastCaptureButton.doClick();
                    }
                }
            });
        }
        JPanel namePanel = new JPanel();
        namePanel.setOpaque(false);
        namePanel.setLayout(new FlowLayout(0, 0, 0));
        namePanel.add(name);
        namePanel.add(this._fcNameTextField);
        this._startFastCaptureButton = new LabelButton(START_FAST_CAPTURE_LABEL_TEXT);
        this._startFastCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewTab.this.ideaInserter.start();
                NewTab.this._tlNameTextField.setText("");
            }
        });
        this._startFastCaptureButton.setBackground(Color.decode("#2698B1"));
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.NewNewAction", (JComponent)this._startFastCaptureButton);
        if (!ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
            this._startFastCaptureButton.setEnabled(false);
        }
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap(namePanel));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap((JComponent)this._startFastCaptureButton));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel createTLPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(TWO + TIMELINE_LABEL_TEXT + " ", 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)48.0f));
        heading.setForeground(FONT_COLOUR);
        JTextArea subheading = new JTextArea();
        subheading.setEditable(false);
        subheading.setCursor(null);
        subheading.setOpaque(false);
        subheading.setFocusable(false);
        subheading.setLineWrap(true);
        subheading.setWrapStyleWord(true);
        subheading.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        subheading.setForeground(FONT_COLOUR);
        subheading.setColumns(40);
        subheading.setText(TIMELINE_MESSAGE);
        JLabel name = new JLabel(NAME_LABEL_TEXT + ":", 2);
        name.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        name.setForeground(FONT_COLOUR);
        name.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this._tlNameTextField = new JTextField();
        this._tlNameTextField.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        this._tlNameTextField.setColumns(30);
        Border inner = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        Border outer = BorderFactory.createLineBorder(Color.decode("#b7bdc6"));
        this._tlNameTextField.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this._tlNameTextField.setForeground(FONT_COLOUR);
        Locale locale = ServiceManager.getI18n().getUserLocale();
        if (!(locale == null || locale.toString().equalsIgnoreCase(Locale.JAPAN.toString()) || locale.toString().equalsIgnoreCase(Locale.JAPANESE.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINA.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINESE.toString()))) {
            this._tlNameTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        NewTab.this._startTimelineButton.doClick();
                    }
                }
            });
        }
        JPanel namePanel = new JPanel();
        namePanel.setOpaque(false);
        namePanel.setLayout(new FlowLayout(0, 0, 0));
        namePanel.add(name);
        namePanel.add(this._tlNameTextField);
        this._startTimelineButton = new LabelButton(START_TIMELINE_LABEL_TEXT);
        this._startTimelineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewTab.this.ideaInserter.start();
                NewTab.this._tlNameTextField.setText("");
            }
        });
        this._startTimelineButton.setBackground(Color.decode("#2698B1"));
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.NewNewAction", (JComponent)this._startTimelineButton);
        if (!ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
            this._startTimelineButton.setEnabled(false);
        }
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap(namePanel));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap((JComponent)this._startTimelineButton));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel createBSPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(TWO + ORGANISE_LABEL_TEXT + " ", 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)48.0f));
        heading.setForeground(FONT_COLOUR);
        JTextArea subheading = new JTextArea();
        subheading.setEditable(false);
        subheading.setCursor(null);
        subheading.setOpaque(false);
        subheading.setFocusable(false);
        subheading.setLineWrap(true);
        subheading.setWrapStyleWord(true);
        subheading.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        subheading.setForeground(FONT_COLOUR);
        subheading.setColumns(40);
        subheading.setText(ORGANISE_MESSAGE_TEXT);
        JLabel name = new JLabel(NAME_LABEL_TEXT + ":", 2);
        name.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        name.setForeground(FONT_COLOUR);
        name.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this._bsNameTextField = new JTextField();
        this._bsNameTextField.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        this._bsNameTextField.setColumns(30);
        Border inner = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        Border outer = BorderFactory.createLineBorder(Color.decode("#b7bdc6"));
        this._bsNameTextField.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this._bsNameTextField.setForeground(FONT_COLOUR);
        Locale locale = ServiceManager.getI18n().getUserLocale();
        if (!(locale == null || locale.toString().equalsIgnoreCase(Locale.JAPAN.toString()) || locale.toString().equalsIgnoreCase(Locale.JAPANESE.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINA.toString()) || locale.toString().equalsIgnoreCase(Locale.CHINESE.toString()))) {
            this._bsNameTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        NewTab.this._startBrainstormButton.doClick();
                    }
                }
            });
        }
        JPanel namePanel = new JPanel();
        namePanel.setOpaque(false);
        namePanel.setLayout(new FlowLayout(0, 0, 0));
        namePanel.add(name);
        namePanel.add(this._bsNameTextField);
        this._startBrainstormButton = new LabelButton(START_BRAINSTORMING_LABEL_TEXT);
        this._startBrainstormButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewTab.this.ideaInserter.start();
                NewTab.this._bsNameTextField.setText("");
            }
        });
        this._startBrainstormButton.setBackground(Color.decode("#2698B1"));
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.NewNewAction", (JComponent)this._startBrainstormButton);
        if (!ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
            this._startBrainstormButton.setEnabled(false);
        }
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap(namePanel));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap((JComponent)this._startBrainstormButton));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel createCIPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(TWO + DEVELOP_LABEL_TEXT + " ", 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)48.0f));
        heading.setForeground(FONT_COLOUR);
        JTextArea subheading = new JTextArea();
        subheading.setEditable(false);
        subheading.setCursor(null);
        subheading.setOpaque(false);
        subheading.setFocusable(false);
        subheading.setLineWrap(true);
        subheading.setWrapStyleWord(true);
        subheading.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        subheading.setForeground(FONT_COLOUR);
        subheading.setColumns(50);
        subheading.setText(DEVELOP_MESSAGE_TEXT);
        JPanel buttonPanel = this.createButtonPanel();
        JPanel pagedIdeaGridAndButtonPanelPanel = new JPanel();
        pagedIdeaGridAndButtonPanelPanel.setOpaque(false);
        pagedIdeaGridAndButtonPanelPanel.setLayout(new BorderLayout());
        pagedIdeaGridAndButtonPanelPanel.add((Component)this._ideaChooser, "Center");
        pagedIdeaGridAndButtonPanelPanel.add((Component)buttonPanel, "South");
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap(pagedIdeaGridAndButtonPanelPanel));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel createInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        final JPanel gridPanel = new JPanel(new GridLayout(2, 2, 20, 20));
        gridPanel.setOpaque(false);
        final Dimension maxSize = new Dimension(1000, 545);
        final Dimension minSize = new Dimension(530, 435);
        gridPanel.setPreferredSize(maxSize);
        gridPanel.setMinimumSize(maxSize);
        gridPanel.setMaximumSize(maxSize);
        JLabel label = new JLabel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.chooseView"), 2);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)25.0f));
        label.setForeground(Color.GRAY);
        JPanel labelWrap = new JPanel(new BorderLayout());
        labelWrap.setOpaque(false);
        labelWrap.add(label);
        labelWrap.setBorder(BorderFactory.createEmptyBorder(25, 0, 20, 0));
        final CanvasOptionsPanel capture = this.createFastCaptureOptionPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.win.ui.fastcapture.message"));
        final CanvasOptionsPanel brainstorm = this.createBrainstormOptionPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.win.ui.brainstorm.message"));
        final CanvasOptionsPanel mindmap = this.createProfessionalOptionPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.win.ui.mindmap.message"));
        final CanvasOptionsPanel timeline = this.createTimelineOptionPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.dozer.view.timeline.windows.startmessage"));
        JPanel captureWrap = new JPanel();
        captureWrap.add(capture);
        JPanel brainstormWrap = new JPanel();
        brainstormWrap.add(brainstorm);
        JPanel mindmapWrap = new JPanel();
        mindmapWrap.add(mindmap);
        JPanel timelineWrap = new JPanel();
        timelineWrap.add(timeline);
        DropShadowBorder dropShadow = new DropShadowBorder(UIManager.getColor("Control"), 1, 5, false, true, true, true);
        captureWrap.setBorder(dropShadow);
        brainstormWrap.setBorder(dropShadow);
        mindmapWrap.setBorder(dropShadow);
        timelineWrap.setBorder(dropShadow);
        gridPanel.add(captureWrap);
        gridPanel.add(brainstormWrap);
        gridPanel.add(mindmapWrap);
        gridPanel.add(timelineWrap);
        panel.add(labelWrap);
        panel.add(gridPanel);
        panel.add(Box.createVerticalGlue());
        JPanel wrapper = new JPanel(new FlowLayout(0));
        wrapper.add(panel);
        wrapper.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                super.ancestorResized(e);
                int width = e.getComponent().getWidth();
                int height = e.getComponent().getHeight();
                if (width < maxSize.width || height < maxSize.height) {
                    gridPanel.setPreferredSize(minSize);
                    gridPanel.setMinimumSize(minSize);
                    gridPanel.setMaximumSize(minSize);
                    capture.setCompact(true);
                    brainstorm.setCompact(true);
                    mindmap.setCompact(true);
                    timeline.setCompact(true);
                    gridPanel.revalidate();
                } else if (capture.isCompact()) {
                    gridPanel.setPreferredSize(maxSize);
                    gridPanel.setMinimumSize(maxSize);
                    gridPanel.setMaximumSize(maxSize);
                    capture.setCompact(false);
                    brainstorm.setCompact(false);
                    mindmap.setCompact(false);
                    timeline.setCompact(false);
                    gridPanel.revalidate();
                }
            }
        });
        return wrapper;
    }

    public final JLabel createHeading(String string) {
        JLabel heading = new JLabel(string, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)38.0f));
        heading.setForeground(FONT_COLOUR);
        heading.setMinimumSize(this.HEADING_SIZE);
        heading.setPreferredSize(this.HEADING_SIZE);
        heading.setMaximumSize(this.HEADING_SIZE);
        return heading;
    }

    public final JLabel createMessage(String string) {
        int MESSAGE_WIDTH = 425;
        String text = "<html><body style='width: " + String.valueOf(425) + "px; text-align:left'>" + string + "</html>";
        JLabel messageLabel = new JLabel(text);
        messageLabel.setBorder(BorderFactory.createEmptyBorder());
        messageLabel.setForeground(FONT_COLOUR);
        messageLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)13.0f));
        messageLabel.setMinimumSize(this.MESSAGE_SIZE);
        messageLabel.setPreferredSize(this.MESSAGE_SIZE);
        messageLabel.setMaximumSize(this.MESSAGE_SIZE);
        return messageLabel;
    }

    private JPanel createStyleOptions() {
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JRadioButton buz = new JRadioButton(STYLE_BUZAN_TEXT, true);
        JRadioButton pro = new JRadioButton(STYLE_PROF_TEXT, false);
        JRadioButton def = new JRadioButton(STYLE_DEFAULT_TEXT, false);
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exc) {
            // empty catch block
        }
        buz.setSelected(true);
        buz.setOpaque(false);
        buz.setForeground(FONT_COLOUR);
        buz.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        buz.setActionCommand(CREATIVE_THEME);
        pro.setOpaque(false);
        pro.setForeground(FONT_COLOUR);
        pro.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        pro.setActionCommand(PRO_THEME);
        def.setOpaque(false);
        def.setForeground(FONT_COLOUR);
        def.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        def.setActionCommand(GET_DEFAULT_THEME);
        JLabel styleLabel = new JLabel(STYLE_TEXT + ":");
        styleLabel.setForeground(FONT_COLOUR);
        styleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        this._styleGroup = new ButtonGroup();
        this._styleGroup.add(buz);
        this._styleGroup.add(pro);
        this._styleGroup.add(def);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        radioPanel.setOpaque(false);
        radioPanel.add(styleLabel);
        radioPanel.add(buz);
        radioPanel.add(pro);
        radioPanel.add(def);
        radioPanel.add(Box.createHorizontalGlue());
        return radioPanel;
    }

    private JPanel wrap(JComponent c, int align) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new FlowLayout(align, 0, 0));
        p.add(c);
        return p;
    }

    private JPanel wrap(JComponent c) {
        return this.wrap(c, 0);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 0));
        LabelButton browseButton = new LabelButton(BROWSE_LABEL_TEXT);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{null, NewTab.this.getThemeId()});
                    NewTab.this._fileMenu.getRibbon().showFileTab();
                    boolean success = ServiceManager.getImageService().getOpenImageService().insertImageFromFile(null, true);
                    if (success) {
                        NewTab.this._fileMenu.getRibbon().setSelectedIndex(1);
                    } else {
                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.CloseAction", new Object[]{true});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        browseButton.setBackground(Color.decode("#c6c6c6"));
        browseButton.setMaximumSize(browseButton.getPreferredSize());
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.NewNewAction", (JComponent)browseButton);
        if (!ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
            browseButton.setEnabled(false);
        }
        LabelButton startButton = new LabelButton(START_LABEL_TEXT);
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selected = NewTab.this._styleGroup.getSelection().getActionCommand();
                String themeId = selected == null ? NewTab.CREATIVE_THEME : (NewTab.GET_DEFAULT_THEME.equalsIgnoreCase(selected) ? ServiceManager.getPreferencesService().getCurrentUserPreferences().get("com.thinkbuzan.gaia.theme.defaultid", NewTab.CREATIVE_THEME) : (NewTab.CREATIVE_THEME.equalsIgnoreCase(selected) || NewTab.PRO_THEME.equalsIgnoreCase(selected) ? selected : NewTab.CREATIVE_THEME));
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewNewAction", new Object[]{NewTab.this._ideaChooser.getSelectedIdeaId(), themeId});
                NewTab.this._fileMenu.getRibbon().goToPreviousTab();
            }
        });
        ServiceManager.getActionManager().hookActionStateListener("com.thinkbuzan.gaia.actions.NewNewAction", (JComponent)startButton);
        if (!ServiceManager.getActionManager().isActionRegistered("com.thinkbuzan.gaia.actions.NewNewAction")) {
            startButton.setEnabled(false);
        }
        startButton.setBackground(Color.decode("#2698B1"));
        startButton.setMaximumSize(startButton.getPreferredSize());
        panel.add(this.createStyleOptions());
        panel.add(Box.createHorizontalGlue());
        panel.add((Component)browseButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)startButton);
        return panel;
    }

    private String getThemeId() {
        String selected;
        String themeId = "";
        themeId = this._professionalCanvasOptionPanel.isSelected() ? ((selected = this._styleGroup.getSelection().getActionCommand()) == null ? CREATIVE_THEME : (GET_DEFAULT_THEME.equalsIgnoreCase(selected) ? ServiceManager.getPreferencesService().getCurrentUserPreferences().get("com.thinkbuzan.gaia.theme.defaultid", CREATIVE_THEME) : (CREATIVE_THEME.equalsIgnoreCase(selected) || PRO_THEME.equalsIgnoreCase(selected) ? selected : CREATIVE_THEME))) : (this._brainstormCanvasOptionPanel.isSelected() ? BS_THEME : (this._timelineCanvasOptionPanel.isSelected() ? TIMELINE_THEME : FAST_CAPTURE_THEME));
        return themeId;
    }

    private String getCentralIdeaLabel() {
        String text = "";
        if (this._brainstormCanvasOptionPanel.isSelected()) {
            text = this._bsNameTextField.getText();
        } else if (this._fastCaptureOptionPanel.isSelected()) {
            text = this._fcNameTextField.getText();
        } else if (this._timelineCanvasOptionPanel.isSelected()) {
            text = this._tlNameTextField.getText();
        }
        return text;
    }

    private JPanel createLeftPanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return SIZE;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOUR);
                g.drawLine(this.getWidth() - 1, 5, this.getWidth() - 1, this.getHeight() - 5);
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 38, 0, 38));
        JLabel heading = new JLabel("1. " + NEW_VIEW_TEXT);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)20.0f));
        heading.setForeground(FONT_COLOUR);
        CanvasOptionsPanel fastcaptureOptionPanel = this.createFastCaptureOptionPanel(null);
        CanvasOptionsPanel brainstormOptionPanel = this.createBrainstormOptionPanel(null);
        CanvasOptionsPanel timelineOptionPanel = this.createTimelineOptionPanel(null);
        CanvasOptionsPanel professionalOptionPanel = this.createProfessionalOptionPanel(null);
        panel.add(Box.createVerticalStrut(10));
        panel.add(heading);
        panel.add(Box.createVerticalStrut(20));
        if (BundleLicenser.isFastCaptureLicensed()) {
            panel.add(fastcaptureOptionPanel);
            panel.add(Box.createVerticalStrut(10));
        }
        panel.add(brainstormOptionPanel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(professionalOptionPanel);
        panel.add(Box.createVerticalStrut(10));
        if (BundleLicenser.isTimelineLicensed()) {
            panel.add(timelineOptionPanel);
            panel.add(Box.createVerticalStrut(10));
        }
        return panel;
    }

    private CanvasOptionsPanel createFastCaptureOptionPanel(String description) {
        this._fastCaptureOptionPanel = description != null ? new CanvasOptionsPanel(5, FAST_CAPTURE_LABEL_TEXT, description) : new CanvasOptionsPanel(5, FAST_CAPTURE_LABEL_TEXT);
        this._fastCaptureOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewTab.this._fastCaptureOptionPanel.setSelected(true);
                NewTab.this._brainstormCanvasOptionPanel.setSelected(false);
                NewTab.this._professionalCanvasOptionPanel.setSelected(false);
                NewTab.this._timelineCanvasOptionPanel.setSelected(false);
                NewTab.this.remove(NewTab.this._fcPanel);
                NewTab.this.remove(NewTab.this._bsPanel);
                NewTab.this.remove(NewTab.this._ciPanel);
                NewTab.this.remove(NewTab.this._tlPanel);
                NewTab.this.remove(NewTab.this._infoPanel);
                NewTab.this.remove(NewTab.this._mainPanel);
                NewTab.this.add((Component)NewTab.this._mainPanel, "West");
                NewTab.this.add((Component)NewTab.this._fcPanel, "Center");
                NewTab.this.revalidate();
                NewTab.this.repaint();
            }
        });
        return this._fastCaptureOptionPanel;
    }

    private CanvasOptionsPanel createTimelineOptionPanel(String description) {
        this._timelineCanvasOptionPanel = description != null ? new CanvasOptionsPanel(7, TIMELINE_LABEL_TEXT, description) : new CanvasOptionsPanel(7, TIMELINE_LABEL_TEXT);
        this._timelineCanvasOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewTab.this._fastCaptureOptionPanel.setSelected(false);
                NewTab.this._brainstormCanvasOptionPanel.setSelected(false);
                NewTab.this._professionalCanvasOptionPanel.setSelected(false);
                NewTab.this._timelineCanvasOptionPanel.setSelected(true);
                NewTab.this.remove(NewTab.this._fcPanel);
                NewTab.this.remove(NewTab.this._bsPanel);
                NewTab.this.remove(NewTab.this._ciPanel);
                NewTab.this.remove(NewTab.this._tlPanel);
                NewTab.this.remove(NewTab.this._infoPanel);
                NewTab.this.remove(NewTab.this._mainPanel);
                NewTab.this.add((Component)NewTab.this._mainPanel, "West");
                NewTab.this.add((Component)NewTab.this._tlPanel, "Center");
                NewTab.this.revalidate();
                NewTab.this.repaint();
            }
        });
        return this._timelineCanvasOptionPanel;
    }

    private CanvasOptionsPanel createBrainstormOptionPanel(String description) {
        this._brainstormCanvasOptionPanel = description != null ? new CanvasOptionsPanel(0, ORGANISE_LABEL_TEXT, description) : new CanvasOptionsPanel(0, ORGANISE_LABEL_TEXT);
        this._brainstormCanvasOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewTab.this._fastCaptureOptionPanel.setSelected(false);
                NewTab.this._brainstormCanvasOptionPanel.setSelected(true);
                NewTab.this._professionalCanvasOptionPanel.setSelected(false);
                NewTab.this._timelineCanvasOptionPanel.setSelected(false);
                NewTab.this.remove(NewTab.this._fcPanel);
                NewTab.this.remove(NewTab.this._bsPanel);
                NewTab.this.remove(NewTab.this._ciPanel);
                NewTab.this.remove(NewTab.this._tlPanel);
                NewTab.this.remove(NewTab.this._infoPanel);
                NewTab.this.remove(NewTab.this._mainPanel);
                NewTab.this.add((Component)NewTab.this._mainPanel, "West");
                NewTab.this.add((Component)NewTab.this._bsPanel, "Center");
                NewTab.this.revalidate();
                NewTab.this.repaint();
            }
        });
        return this._brainstormCanvasOptionPanel;
    }

    private CanvasOptionsPanel createProfessionalOptionPanel(String description) {
        this._professionalCanvasOptionPanel = description != null ? new CanvasOptionsPanel(1, DEVELOP_LABEL_TEXT, description) : new CanvasOptionsPanel(1, DEVELOP_LABEL_TEXT);
        this._professionalCanvasOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewTab.this._fastCaptureOptionPanel.setSelected(false);
                NewTab.this._brainstormCanvasOptionPanel.setSelected(false);
                NewTab.this._professionalCanvasOptionPanel.setSelected(true);
                NewTab.this._timelineCanvasOptionPanel.setSelected(false);
                NewTab.this.remove(NewTab.this._fcPanel);
                NewTab.this.remove(NewTab.this._bsPanel);
                NewTab.this.remove(NewTab.this._ciPanel);
                NewTab.this.remove(NewTab.this._tlPanel);
                NewTab.this.remove(NewTab.this._infoPanel);
                NewTab.this.remove(NewTab.this._mainPanel);
                NewTab.this.add((Component)NewTab.this._mainPanel, "West");
                NewTab.this.add((Component)NewTab.this._ciPanel, "Center");
                NewTab.this.revalidate();
                NewTab.this.repaint();
            }
        });
        return this._professionalCanvasOptionPanel;
    }
}

