/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab;

import com.thinkbuzan.apollo.ui.core.win.component.LabelButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFilesPanel;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.onlineaccountaccessclient.AccountStatus;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineListener;
import com.thinkbuzan.gaia.recentfiles.RecentFiles;
import com.thinkbuzan.gaia.recentfiles.RecentFilesChangedListener;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.presentation.model.IPresentation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ShareOptionsPanel
extends JPanel
implements RecentFilesChangedListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RECENT_FILES = 5;
    private static final Color BUTTON_COLOUR = Color.decode("#699bcd");
    private transient String currentID = "sharePanel";
    private transient RecentFiles recentFiles;
    private final transient RecentFilesPanel recentLocal;
    private final transient RecentFilesPanel recentOnline;

    public ShareOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.white);
        this.recentLocal = new RecentFilesPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.recentFiles"), false, true);
        this.recentOnline = new RecentFilesPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.welcometab.recentsyncedmaps"), true, true);
        ServiceManager.addRecentFilesServiceListener(this.createServiceListener());
        IEditorViewListener listener = this.createEditorListener();
        ActionListener cancelListener = this.createCancelListener(listener);
        ActionListener localListener = this.createLocalOpenListener(listener, cancelListener);
        ActionListener cloudListener = this.createCloudOpenListener(listener, cancelListener);
        ActionListener recentListener = this.createRecentOpenListener(listener);
        this.recentLocal.addOpenListener(recentListener);
        this.recentOnline.addOpenListener(recentListener);
        LabelButton computer = new LabelButton(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.open"), localListener);
        computer.setBackground(BUTTON_COLOUR);
        LabelButton cloud = new LabelButton(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.guicommons.boundaryDialog.cloud"), cloudListener);
        cloud.setBackground(BUTTON_COLOUR);
        ServiceManager.addOnlineAccountAccessClientServiceListener(this.createOnlineListener(cloud));
        JPanel local = new JPanel(new FlowLayout(0, 20, 0));
        local.setOpaque(false);
        local.add((Component)computer);
        local.add((Component)cloud);
        local.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        local.setMaximumSize(new Dimension(Integer.MAX_VALUE, 450));
        JPanel recent = this.createRecentPanel();
        recent.setMaximumSize(new Dimension(Integer.MAX_VALUE, 450));
        this.add(recent);
        this.add(local);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createRecentPanel() {
        this.recentLocal.setVisible(!this.recentLocal.isEmpty());
        this.recentOnline.setVisible(!this.recentOnline.isEmpty());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JPanel w = new JPanel();
        w.setOpaque(false);
        w.setLayout(new BoxLayout(w, 0));
        panel.add((Component)w, "North");
        w.add(this.recentLocal);
        w.add(Box.createHorizontalStrut(50));
        w.add(this.recentOnline);
        return panel;
    }

    public void recentFilesChanged() {
        if (this.recentFiles != null) {
            EDTUtilities.runOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    List localMaps = ShareOptionsPanel.this.recentFiles.getFilteredRecentFiles(5, false);
                    List onlineMaps = ShareOptionsPanel.this.recentFiles.getFilteredRecentFiles(5, true);
                    ShareOptionsPanel.this.recentLocal.setRecentFiles(localMaps);
                    ShareOptionsPanel.this.recentOnline.setRecentFiles(onlineMaps);
                    ShareOptionsPanel.this.recentLocal.setVisible(!ShareOptionsPanel.this.recentLocal.isEmpty());
                    ShareOptionsPanel.this.recentOnline.setVisible(!ShareOptionsPanel.this.recentOnline.isEmpty());
                }
            });
        }
    }

    private ServiceAdapter<RecentFiles> createServiceListener() {
        return new ServiceAdapter<RecentFiles>(){

            public void serviceAdded(RecentFiles service) {
                super.serviceAdded((Object)service);
                ShareOptionsPanel.this.recentFiles = service;
                ShareOptionsPanel.this.recentFiles.addRecentFilesChangedListener((RecentFilesChangedListener)ShareOptionsPanel.this);
                ShareOptionsPanel.this.recentFilesChanged();
            }
        };
    }

    public final void setCurrentId(String idIn) {
        this.currentID = idIn;
    }

    private ActionListener createRecentOpenListener(final IEditorViewListener listener) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServiceManager.getEditorManager().addEditorViewListener(listener);
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)"failed to add editor listener", (Throwable)e1);
                }
            }
        };
    }

    private ActionListener createCloudOpenListener(final IEditorViewListener listener, final ActionListener cancelListener) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServiceManager.getEditorManager().addEditorViewListener(listener);
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)"failed to add editor listener", (Throwable)e1);
                }
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ShowCloudFilesDialog", new Object[]{cancelListener});
            }
        };
    }

    private ActionListener createLocalOpenListener(final IEditorViewListener listener, final ActionListener cancelListener) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServiceManager.getEditorManager().addEditorViewListener(listener);
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)"failed to add editor listener", (Throwable)e1);
                }
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ImportAction", new Object[]{cancelListener});
            }
        };
    }

    private ActionListener createCancelListener(final IEditorViewListener listener) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServiceManager.getEditorManager().removeEditorViewListener(listener);
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)"failed to remove editor listener", (Throwable)e1);
                }
            }
        };
    }

    private IEditorViewListener createEditorListener() {
        return new IEditorViewListener(){
            String lastId = null;

            public void editorChanged(final IEditorView editor) {
                if (editor == null) {
                    this.lastId = null;
                } else {
                    try {
                        if ("sharePanel".equalsIgnoreCase(ShareOptionsPanel.this.currentID)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ShowExportDialogAction", new Object[0]);
                                }
                            });
                            ServiceManager.getEditorManager().removeEditorViewListener((IEditorViewListener)this);
                        } else if (this.lastId != null && this.lastId.equalsIgnoreCase(editor.getId().toString())) {
                            if (editor.getPresentations() == null || editor.getPresentations().isEmpty()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewPresentationAction", new Object[0]);
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.PresentationViewAction", new Object[]{((IPresentation)editor.getPresentations().get(0)).getID().toString()});
                                    }
                                });
                            }
                            ServiceManager.getEditorManager().removeEditorViewListener((IEditorViewListener)this);
                            this.lastId = null;
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).warn((Object)"failed to remove editor listener", (Throwable)e);
                    }
                    this.lastId = editor.getId().toString();
                }
            }
        };
    }

    private IServiceListener<OnlineAccountAccessClient> createOnlineListener(final LabelButton cloud) {
        return new IServiceListener<OnlineAccountAccessClient>(){

            public void serviceRemoved(OnlineAccountAccessClient service) {
            }

            public void serviceAdded(OnlineAccountAccessClient service) {
                service.addOnlineListener(new OnlineListener(){

                    public void update(AccountStatus status) {
                        switch (status) {
                            case ONLINE_AUTHENTICATED: {
                                cloud.setEnabled(true);
                                break;
                            }
                            default: {
                                cloud.setEnabled(false);
                            }
                        }
                    }
                });
            }
        };
    }
}

