/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab;

import com.thinkbuzan.apollo.ui.core.win.component.LabelButton;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtab.CanvasOptionsPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.ScrollableTemplateGrid;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.template.ICategory;
import com.thinkbuzan.gaia.template.ITemplate;
import com.thinkbuzan.gaia.template.ITemplatesChangedListener;
import com.thinkbuzan.gaia.template.TemplateManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewFromTemplateTab
extends JPanel
implements IIdeaInserter {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 330;
    private static final Dimension SIZE = new Dimension(330, Integer.MAX_VALUE);
    private static final Color FONT_COLOUR = Color.decode("#4e4e4e");
    private static final Color BORDER_COLOUR = Color.decode("#c6c6c6");
    private static final int PADDING = 20;
    private static final int TEMPLATE = 0;
    private static final int WIZARD = 1;
    private int _selectedCanvas = 0;
    private ScrollableTemplateGrid _scrollableTemplateGrid;
    private CanvasOptionsPanel _templateCanvasOptionPanel;
    private CanvasOptionsPanel _wizardCanvasOptionPanel;
    private JPanel _templatePanel;
    private JPanel _wizardPanel;
    private FileMenu _fileMenu;
    private static final String OPTION_TWO_OPTIONS_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newtab.option2.options");
    private static final String PICK_TEMPLATE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newfromtemplatetab.picktemplate");
    private static final String IMPORT_TEMPLATE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newfromtemplatetab.importtemplate");
    private static final String GET_TRANSLATED_TEMPLATES_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.template.getTranslatedTemplates");
    private static final String START_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.projectview.start").toUpperCase();
    private static final String DELETE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.delete");
    private static final String OPTION_TWO_WIZARD_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newfromtemplatetab.option2.wizard");
    private static final String NEW_FROM_WIZARD_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newfromtemplatetab.createfromwizard");
    private static final String OPTION_ONE_TEMPLATE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newfromtemplatetab.option1.template");
    private static final String HOW_TO_START_PROJECT_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.newtab.start.how");
    private static final String TEMPLATE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.exportManager.templateExporter.templateTitle");
    private static final String WIZARD_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.wizards.wizard");

    public NewFromTemplateTab(FileMenu fileMenu) {
        this._fileMenu = fileMenu;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOUR));
        ServiceManager.addTemplateManagerServiceListener(new IServiceListener<TemplateManager>(){

            public void serviceRemoved(TemplateManager service) {
            }

            public void serviceAdded(TemplateManager service) {
                NewFromTemplateTab.this._templatePanel = NewFromTemplateTab.this.createTemplatePanel(service.getCategories());
                NewFromTemplateTab.this.add((Component)NewFromTemplateTab.this._templatePanel, "Center");
                service.addTemplatesChangedListener(NewFromTemplateTab.this.getTemplatesChangedListener());
            }
        });
        this._wizardPanel = this.createWizardPanel();
        this.add((Component)this.createLeftPanel(), "West");
    }

    private ITemplatesChangedListener getTemplatesChangedListener() {
        return new ITemplatesChangedListener(){

            public void templatesChanged() {
                try {
                    NewFromTemplateTab.this._scrollableTemplateGrid.refresh(ServiceManager.getTemplateManager().getCategories());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private JPanel createTemplatePanel(List<ICategory> categories) {
        this._scrollableTemplateGrid = new ScrollableTemplateGrid(categories, this);
        JPanel templateGridWrapper = new JPanel();
        templateGridWrapper.setOpaque(false);
        templateGridWrapper.setLayout(new BorderLayout());
        templateGridWrapper.add((Component)this._scrollableTemplateGrid, "Center");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(OPTION_TWO_OPTIONS_TEXT, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)24.0f));
        heading.setForeground(FONT_COLOUR);
        JLabel subheading = this.getLabel(PICK_TEMPLATE_TEXT);
        JPanel templateButtonsPanel = new JPanel();
        templateButtonsPanel.setOpaque(false);
        templateButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        templateButtonsPanel.setLayout(new FlowLayout(2, 0, 0));
        LabelButton importButton = new LabelButton(IMPORT_TEMPLATE_TEXT);
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ServiceManager.getTemplateManager().importTemplates((Component)MainFrameUtilities.getMainFrame());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        importButton.setBackground(Color.decode("#2698B1"));
        templateButtonsPanel.add((Component)importButton);
        templateButtonsPanel.add(Box.createHorizontalStrut(10));
        LabelButton translateButton = new LabelButton(GET_TRANSLATED_TEMPLATES_TEXT);
        translateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ShowTemplateDownloadDialogAction", new Object[0]);
            }
        });
        translateButton.setBackground(Color.decode("#2698B1"));
        templateButtonsPanel.add((Component)translateButton);
        JPanel buttonPanel = this.createButtonPanel();
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setOpaque(false);
        buttonPanelWrapper.setLayout(new FlowLayout(2, 0, 0));
        buttonPanelWrapper.add(buttonPanel);
        JPanel pagedIdeaGridAndButtonPanelPanel = new JPanel();
        pagedIdeaGridAndButtonPanelPanel.setOpaque(false);
        pagedIdeaGridAndButtonPanelPanel.setLayout(new BorderLayout());
        pagedIdeaGridAndButtonPanelPanel.add((Component)templateButtonsPanel, "North");
        pagedIdeaGridAndButtonPanelPanel.add((Component)templateGridWrapper, "Center");
        pagedIdeaGridAndButtonPanelPanel.add((Component)buttonPanelWrapper, "South");
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(this.wrap(pagedIdeaGridAndButtonPanelPanel));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(0, 0, 0));
        LabelButton startButton = new LabelButton(START_TEXT);
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewFromTemplateTab.this.start();
                NewFromTemplateTab.this._fileMenu.getRibbon().goToPreviousTab();
            }
        });
        startButton.setBackground(Color.decode("#2698B1"));
        LabelButton deleteButton = new LabelButton(DELETE_TEXT);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ITemplate selectedTemplate = NewFromTemplateTab.this._scrollableTemplateGrid.getSelectedTemplate();
                try {
                    String title = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.delete");
                    String message = MessageFormat.format(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.confirmDelete"), selectedTemplate.getName());
                    String acceptText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.yes");
                    String cancelText = ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.no");
                    ModalOptionDialog.SelectedModalOptionDialogOption option = ModalOptionDialog.showAcceptCancelDialog((Frame)MainFrameUtilities.getMainFrame(), (String)title, (String)message, (String)acceptText, (String)cancelText);
                    if (option == ModalOptionDialog.SelectedModalOptionDialogOption.ACCEPT) {
                        ServiceManager.getTemplateManager().deleteTemplate(selectedTemplate);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        deleteButton.setBackground(Color.decode("#de554e"));
        panel.add((Component)deleteButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)startButton);
        return panel;
    }

    public void start() {
        switch (this._selectedCanvas) {
            case 0: {
                File templateFolder = ServiceManager.getFileAccessService().getSharedFile(TemplateManager.TEMPLATE_SHARE_FOLDER);
                String templateFilename = this._scrollableTemplateGrid.getSelectedTemplateFilename();
                File templatePath = new File(templateFolder, templateFilename);
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.OpenTemplateAction", new Object[]{templatePath});
                break;
            }
            case 1: {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.NewFromWizardAction", new Object[0]);
            }
        }
        this._fileMenu.getRibbon().goToPreviousTab();
    }

    public void start(Image localSelected) {
    }

    private JPanel createWizardPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 42, 0, 0));
        JLabel heading = new JLabel(OPTION_TWO_WIZARD_TEXT, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)24.0f));
        heading.setForeground(FONT_COLOUR);
        JLabel subheading = this.getLabel(NEW_FROM_WIZARD_TEXT);
        LabelButton wizardButton = new LabelButton(START_TEXT);
        wizardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewFromTemplateTab.this.start();
            }
        });
        wizardButton.setBackground(Color.decode("#2698B1"));
        panel.add(this.wrap(heading));
        panel.add(this.wrap(subheading));
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.wrap((JComponent)wizardButton));
        panel.add(Box.createVerticalStrut(Integer.MAX_VALUE));
        return panel;
    }

    private JPanel wrap(JComponent c) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new FlowLayout(0, 0, 0));
        p.add(c);
        return p;
    }

    private JPanel createLeftPanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return SIZE;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOUR);
                g.drawLine(this.getWidth() - 1, 5, this.getWidth() - 1, this.getHeight() - 5);
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 38, 0, 38));
        JLabel heading = new JLabel(OPTION_ONE_TEMPLATE_TEXT, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)24.0f));
        heading.setForeground(FONT_COLOUR);
        JLabel subheading = this.getLabel(HOW_TO_START_PROJECT_TEXT);
        JPanel templateOptionPanel = this.createTemplateOptionPanel();
        JPanel wizardOptionPanel = this.createWizardOptionPanel();
        panel.add(heading);
        panel.add(subheading);
        panel.add(Box.createVerticalStrut(20));
        if (BundleLicenser.isTemplatesLicensed()) {
            panel.add(templateOptionPanel);
            panel.add(Box.createVerticalStrut(10));
        }
        if (BundleLicenser.isWizardsLicensed()) {
            panel.add(wizardOptionPanel);
        }
        return panel;
    }

    private JPanel createTemplateOptionPanel() {
        this._templateCanvasOptionPanel = new CanvasOptionsPanel(3, TEMPLATE_TEXT);
        this._templateCanvasOptionPanel.setSelected(true);
        this._templateCanvasOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewFromTemplateTab.this._templateCanvasOptionPanel.setSelected(true);
                NewFromTemplateTab.this._wizardCanvasOptionPanel.setSelected(false);
                NewFromTemplateTab.this.remove(NewFromTemplateTab.this._templatePanel);
                NewFromTemplateTab.this.remove(NewFromTemplateTab.this._wizardPanel);
                NewFromTemplateTab.this.add((Component)NewFromTemplateTab.this._templatePanel, "Center");
                NewFromTemplateTab.this._selectedCanvas = 0;
                NewFromTemplateTab.this.revalidate();
                NewFromTemplateTab.this.repaint();
            }
        });
        return this._templateCanvasOptionPanel;
    }

    private JPanel createWizardOptionPanel() {
        this._wizardCanvasOptionPanel = new CanvasOptionsPanel(4, WIZARD_TEXT);
        this._wizardCanvasOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewFromTemplateTab.this._templateCanvasOptionPanel.setSelected(false);
                NewFromTemplateTab.this._wizardCanvasOptionPanel.setSelected(true);
                NewFromTemplateTab.this.remove(NewFromTemplateTab.this._templatePanel);
                NewFromTemplateTab.this.remove(NewFromTemplateTab.this._wizardPanel);
                NewFromTemplateTab.this.add((Component)NewFromTemplateTab.this._wizardPanel, "Center");
                NewFromTemplateTab.this._selectedCanvas = 1;
                NewFromTemplateTab.this.revalidate();
                NewFromTemplateTab.this.repaint();
            }
        });
        return this._wizardCanvasOptionPanel;
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(text, 2);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        label.setForeground(FONT_COLOUR);
        return label;
    }
}

