/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.CategoryChangedListener;
import com.thinkbuzan.gaia.template.ICategory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CategoryChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 600;
    private static final int HEIGHT = 80;
    private ArrayList<CategoryChangedListener> _categoryChangedListeners = new ArrayList();
    private static final Color TEXT_COLOUR = Color.decode("#4e4e4e");
    private static final Color SELECTED_COLOUR = Color.decode("#f1f1f1");
    private static final Color HOVER_COLOUR = Color.decode("#f1f1f1");
    private static final Color BACKGROUND_COLOUR = Color.white;
    public static final String ALL = "all";
    private static final int PADDING = 5;
    private HashMap<ICategory, JLabel> _labels = new HashMap(7);
    private ICategory _selectedCategory;

    public CategoryChooserPanel(List<ICategory> categories) {
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 5, 0));
        for (ICategory category : categories) {
            this.addCategory(category);
        }
    }

    public void refresh(List<ICategory> categories) {
        this._labels.clear();
        for (Component component : this.getComponents()) {
            this.remove(component);
        }
        for (ICategory category : categories) {
            this.addCategory(category);
        }
    }

    public void addCategory(ICategory newCategory) {
        JLabel label = this.createLabel(newCategory.getName(), newCategory);
        this._labels.put(newCategory, label);
        this.add(label);
        if (this._labels.size() == 1) {
            this.selectCategory(newCategory);
            this._selectedCategory = newCategory;
        }
    }

    public JLabel getCategoryButton(String category) {
        return this._labels.get(category);
    }

    public void selectCategory(ICategory category) {
        JLabel label = this._labels.get(category);
        if (label != null && category != this._selectedCategory) {
            this.deselectAll();
            label.setBackground(SELECTED_COLOUR);
            this._selectedCategory = category;
            this.fireCategoryChanged(category);
        }
    }

    public void selectCategory(String categoryName) {
        ICategory chosen = null;
        for (ICategory category : this._labels.keySet()) {
            if (!category.getName().equals(categoryName)) continue;
            chosen = category;
            break;
        }
        if (chosen != null) {
            this.selectCategory(chosen);
        }
    }

    public void addCategoryChangedListener(CategoryChangedListener listener) {
        if (!this._categoryChangedListeners.contains(listener)) {
            this._categoryChangedListeners.add(listener);
        }
    }

    public void removeCategoryChangedListener(CategoryChangedListener listener) {
        this._categoryChangedListeners.remove(listener);
    }

    private void fireCategoryChanged(ICategory newCategory) {
        for (CategoryChangedListener categoryChangedListener : this._categoryChangedListeners) {
            categoryChangedListener.categoryChanged(newCategory);
        }
    }

    private JLabel createLabel(String text, final ICategory category) {
        final JLabel label = new JLabel(text);
        label.setOpaque(true);
        label.setBackground(BACKGROUND_COLOUR);
        label.setForeground(TEXT_COLOUR);
        label.setFont(ApplicationFont.getSafeFont((String)text, (int)0, (float)12.0f));
        label.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (CategoryChooserPanel.this._labels.get(CategoryChooserPanel.this._selectedCategory) == label) {
                    label.setBackground(SELECTED_COLOUR);
                } else {
                    label.setBackground(HOVER_COLOUR);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                if (CategoryChooserPanel.this._labels.get(CategoryChooserPanel.this._selectedCategory) == label) {
                    label.setBackground(SELECTED_COLOUR);
                } else {
                    label.setBackground(BACKGROUND_COLOUR);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                CategoryChooserPanel.this.selectCategory(category);
            }
        });
        return label;
    }

    private void deselectAll() {
        for (JLabel label : this._labels.values()) {
            label.setBackground(Color.white);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superDim = super.getPreferredSize();
        if (superDim != null) {
            return new Dimension(600, 80);
        }
        return new Dimension(600, 80);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

