/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser;

import com.thinkbuzan.apollo.dialogs.imagechooser.PageControlPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.AllTemplatesCategory;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.CategoryChangedListener;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.CategoryChooserPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.TemplateGrid;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.gaia.template.ICategory;
import com.thinkbuzan.gaia.template.ISubCategory;
import com.thinkbuzan.gaia.template.ITemplate;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PagedTemplateGrid
extends JPanel {
    private PageControlPanel _pageControls;
    private CategoryChooserPanel _categoryChooserPanel;
    private ArrayList<TemplateGrid> _templateGrids = new ArrayList();
    private TemplateGrid _currentGrid;
    private int _page;
    private JPanel _contentPanel;
    private IIdeaInserter _parentTab;

    public PagedTemplateGrid(List<ICategory> categories, IIdeaInserter parentTab) {
        this._parentTab = parentTab;
        this._pageControls = new PageControlPanel(ServiceManager.getI18n());
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 0, 0));
        this._contentPanel = new JPanel();
        this._contentPanel.setOpaque(false);
        this._contentPanel.setLayout(new BorderLayout());
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ICategory category : categories) {
            for (ISubCategory subcategory : category.getSubCategories()) {
                for (ITemplate template : subcategory.getTemplates()) {
                    templates.add(template);
                }
            }
        }
        categories.add(0, new AllTemplatesCategory(templates, ServiceManager.getI18n()));
        this._categoryChooserPanel = new CategoryChooserPanel(categories);
        this._categoryChooserPanel.addCategoryChangedListener(new CategoryChangedListener(){

            @Override
            public void categoryChanged(ICategory newCategory) {
                PagedTemplateGrid.this.addTemplatesForCategory(newCategory);
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        bottomPanel.add((Component)this._categoryChooserPanel, "West");
        bottomPanel.add((Component)this._pageControls, "East");
        this._contentPanel.add((Component)bottomPanel, "South");
        this.add(this._contentPanel);
        this.addTemplatesForCategory(categories.get(0));
    }

    public void refresh(List<ICategory> categories) {
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ICategory category : categories) {
            for (ISubCategory subcategory : category.getSubCategories()) {
                for (ITemplate template : subcategory.getTemplates()) {
                    templates.add(template);
                }
            }
        }
        categories.add(0, new AllTemplatesCategory(templates, ServiceManager.getI18n()));
        this._categoryChooserPanel.refresh(categories);
        this.addTemplatesForCategory(categories.get(0));
    }

    public CategoryChooserPanel getCategoryChooser() {
        return this._categoryChooserPanel;
    }

    public String getSelectedTemplateFilename() {
        return this._currentGrid.getSelectedTile().getTemplate().getFilename();
    }

    public void addCategory(ICategory newCategory) {
        this._categoryChooserPanel.addCategory(newCategory);
    }

    private void addTemplatesForCategory(ICategory category) {
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ISubCategory subcategory : category.getSubCategories()) {
            for (ITemplate template : subcategory.getTemplates()) {
                templates.add(template);
            }
        }
        this.addTemplatesToView(templates);
    }

    private void addTemplatesToView(List<ITemplate> templates) {
        this._templateGrids.clear();
        if (templates == null || templates.size() == 0) {
            this.revalidate();
            this.repaint();
            return;
        }
        ArrayList<ITemplate> _gridTemplates = new ArrayList<ITemplate>(18);
        int counter = 0;
        for (ITemplate template : templates) {
            _gridTemplates.add(template);
            if (++counter != 18) continue;
            counter = 0;
            this._templateGrids.add(new TemplateGrid(_gridTemplates, this._parentTab));
            _gridTemplates.clear();
        }
        if (_gridTemplates.size() > 0) {
            this._templateGrids.add(new TemplateGrid(_gridTemplates, this._parentTab));
        }
        this.initialisePageControls();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagedTemplateGrid.this.revalidate();
                PagedTemplateGrid.this.repaint();
            }
        });
    }

    private void initialisePageControls() {
        this._page = 0;
        if (this._currentGrid != null) {
            this._contentPanel.remove(this._currentGrid);
        }
        this._currentGrid = this._templateGrids.get(this._page);
        this._contentPanel.add((Component)this._currentGrid, "Center");
        this.updatePageLabel();
        this._pageControls.setStartAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagedTemplateGrid.this._page = 0;
                PagedTemplateGrid.this.updatePage();
            }
        });
        this._pageControls.setPreviousAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagedTemplateGrid.this._page--;
                if (PagedTemplateGrid.this._page < 0) {
                    PagedTemplateGrid.this._page = 0;
                    return;
                }
                PagedTemplateGrid.this.updatePage();
            }
        });
        this._pageControls.setNextAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagedTemplateGrid.this._page++;
                if (PagedTemplateGrid.this._page >= PagedTemplateGrid.this._templateGrids.size()) {
                    PagedTemplateGrid.this._page = PagedTemplateGrid.this._templateGrids.size() - 1;
                    return;
                }
                PagedTemplateGrid.this.updatePage();
            }
        });
        this._pageControls.setEndAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagedTemplateGrid.this._page = PagedTemplateGrid.this._templateGrids.size() - 1;
                PagedTemplateGrid.this.updatePage();
            }
        });
    }

    private void updatePage() {
        this._contentPanel.remove(this._currentGrid);
        int selectedIndex = this._currentGrid.getSelectedIndex();
        this._currentGrid = this._templateGrids.get(this._page);
        if (this._currentGrid.getTileCount() <= selectedIndex) {
            selectedIndex = this._currentGrid.getTileCount() - 1;
        }
        this._currentGrid.setSelectedIndex(selectedIndex);
        this._contentPanel.add((Component)this._currentGrid, "Center");
        this.updatePageLabel();
        this.repaint();
    }

    private void updatePageLabel() {
        this._pageControls.setPageLabel(this._page + 1, this._templateGrids.size());
    }

    public ITemplate getSelectedTemplate() {
        return this._currentGrid.getSelectedTile().getTemplate();
    }
}

