/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser;

import com.thinkbuzan.apollo.ui.core.win.component.CustomScrollBarUI;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.AllTemplatesCategory;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.CategoryChangedListener;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.CategoryChooserPanel;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.TemplateImageTile;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.gaia.template.ICategory;
import com.thinkbuzan.gaia.template.IPreviewImages;
import com.thinkbuzan.gaia.template.ISubCategory;
import com.thinkbuzan.gaia.template.ITemplate;
import com.thinkbuzan.gaia.template.PreviewImageSize;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.guielements.layout.WrapLayout;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;

public class ScrollableTemplateGrid
extends JPanel {
    private static final int GRID_MINIMUM_WIDTH = 300;
    private static final int GRID_MINIMUM_HEIGHT = 150;
    private static final int GRID_MAXIMUM_WIDTH = 900;
    private static final int GRID_MAXIMUM_HEIGHT = 500;
    private static final int GRID_PARENT_INSET_HORIZONTAL = 500;
    private static final int GRID_PARENT_INSET_VERTICAL = 250;
    private static final int GRID_PADDING = 50;
    private CategoryChooserPanel _categoryChooserPanel;
    private ArrayList<TemplateImageTile> _templateImageTiles = new ArrayList();
    private ITemplate _currentTemplate;
    private JPanel _contentPanel;
    private IIdeaInserter _parentTab;
    private JPanel _scrollablePanel;
    private JScrollPane _scrollPane;
    private JPanel _scrollPaneWrapper;
    IPreviewImages templatePreviewImageManager = null;

    public ScrollableTemplateGrid(List<ICategory> categories, IIdeaInserter parentTab) {
        try {
            this.templatePreviewImageManager = ServiceManager.getTemplateManager().getPreviewImages();
        }
        catch (Exception e1) {
            // empty catch block
        }
        this._parentTab = parentTab;
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 0, 0));
        this._contentPanel = new JPanel();
        this._contentPanel.setOpaque(false);
        this._contentPanel.setLayout(new BorderLayout());
        this._scrollablePanel = new JPanel();
        this._scrollablePanel.setOpaque(false);
        this._scrollablePanel.setLayout((LayoutManager)new WrapLayout(0, 10, 10));
        this._scrollPane = new JScrollPane(this._scrollablePanel);
        this._scrollPane.setOpaque(false);
        this._scrollPane.getViewport().setOpaque(false);
        this._scrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new CustomScrollBarUI());
        this._scrollPane.setHorizontalScrollBarPolicy(31);
        this._scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ICategory category : categories) {
            for (ISubCategory subcategory : category.getSubCategories()) {
                for (ITemplate template : subcategory.getTemplates()) {
                    templates.add(template);
                }
            }
        }
        categories.add(0, new AllTemplatesCategory(templates, ServiceManager.getI18n()));
        this._categoryChooserPanel = new CategoryChooserPanel(categories);
        this._categoryChooserPanel.addCategoryChangedListener(new CategoryChangedListener(){

            @Override
            public void categoryChanged(ICategory newCategory) {
                ScrollableTemplateGrid.this.addTemplatesForCategory(newCategory);
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        bottomPanel.add((Component)this._categoryChooserPanel, "West");
        this._contentPanel.add((Component)bottomPanel, "South");
        this._scrollPaneWrapper = new JPanel();
        this._scrollPaneWrapper.setOpaque(false);
        this._scrollPaneWrapper.setLayout(new BorderLayout());
        this._scrollPaneWrapper.setMinimumSize(new Dimension(300, 150));
        this._scrollPaneWrapper.setMaximumSize(new Dimension(900, 500));
        this._scrollPaneWrapper.setPreferredSize(new Dimension(800, 600));
        this._scrollPaneWrapper.add((Component)this._scrollPane, "Center");
        this._contentPanel.add((Component)this._scrollPaneWrapper, "Center");
        this.add((Component)this._contentPanel, "Center");
        this.addTemplatesForCategory(categories.get(0));
        this.setupParentResizeListener(MainFrameUtilities.getMainFrame());
        if (MainFrameUtilities.getMainFrame() != null) {
            this.resizeForParentDimensions(MainFrameUtilities.getMainFrame().getSize());
        }
    }

    private final void resizeForParentDimensions(Dimension parentPreferredSize) {
        Dimension spaceForGrid = new Dimension(parentPreferredSize.width - 500, parentPreferredSize.height - 250);
        int widthToUse = spaceForGrid.width - 50;
        int heightToUse = spaceForGrid.height - 50;
        widthToUse = Math.min(900, widthToUse);
        heightToUse = Math.min(500, heightToUse);
        widthToUse = Math.max(300, widthToUse);
        heightToUse = Math.max(150, heightToUse);
        final Dimension sizeAfterResize = new Dimension(widthToUse, heightToUse);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollableTemplateGrid.this._scrollPaneWrapper.setMinimumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._scrollPaneWrapper.setMaximumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._scrollPaneWrapper.setPreferredSize(sizeAfterResize);
                ScrollableTemplateGrid.this._scrollPane.setMinimumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._scrollPane.setMaximumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._scrollPane.setPreferredSize(sizeAfterResize);
                ScrollableTemplateGrid.this._contentPanel.setMinimumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._contentPanel.setMaximumSize(sizeAfterResize);
                ScrollableTemplateGrid.this._contentPanel.setPreferredSize(sizeAfterResize);
                ScrollableTemplateGrid.this._contentPanel.revalidate();
                ScrollableTemplateGrid.this._contentPanel.repaint();
                ScrollableTemplateGrid.this._scrollPane.revalidate();
                ScrollableTemplateGrid.this._scrollPane.repaint();
                ScrollableTemplateGrid.this._scrollPaneWrapper.revalidate();
                ScrollableTemplateGrid.this._scrollPaneWrapper.repaint();
                ScrollableTemplateGrid.this.revalidate();
                ScrollableTemplateGrid.this.repaint();
            }
        });
    }

    public final void setupParentResizeListener(Component parentComponent) {
        if (parentComponent != null) {
            parentComponent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    super.componentResized(e);
                    ScrollableTemplateGrid.this.resizeForParentDimensions(e.getComponent().getSize());
                }
            });
        }
    }

    public void refresh(List<ICategory> categories) {
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ICategory category : categories) {
            for (ISubCategory subcategory : category.getSubCategories()) {
                for (ITemplate template : subcategory.getTemplates()) {
                    templates.add(template);
                }
            }
        }
        categories.add(0, new AllTemplatesCategory(templates, ServiceManager.getI18n()));
        this._categoryChooserPanel.refresh(categories);
        this.addTemplatesForCategory(categories.get(0));
    }

    public CategoryChooserPanel getCategoryChooser() {
        return this._categoryChooserPanel;
    }

    public String getSelectedTemplateFilename() {
        return this._currentTemplate.getFilename();
    }

    public void addCategory(ICategory newCategory) {
        this._categoryChooserPanel.addCategory(newCategory);
    }

    private void addTemplatesForCategory(ICategory category) {
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        for (ISubCategory subcategory : category.getSubCategories()) {
            for (ITemplate template : subcategory.getTemplates()) {
                templates.add(template);
            }
        }
        this.addTemplatesToView(templates);
    }

    private void addTemplatesToView(List<ITemplate> templates) {
        this._scrollablePanel.removeAll();
        this._templateImageTiles.clear();
        if (templates == null || templates.size() == 0) {
            this.revalidate();
            this.repaint();
            return;
        }
        for (ITemplate template : templates) {
            ImageIcon temp = null;
            if (this.templatePreviewImageManager == null) continue;
            temp = new ImageIcon(this.templatePreviewImageManager.getPreviewImage(template, PreviewImageSize.SMALL));
            final TemplateImageTile templateImageTile = new TemplateImageTile(template, temp);
            templateImageTile.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() < 2) {
                        for (TemplateImageTile t : ScrollableTemplateGrid.this._templateImageTiles) {
                            t.setSelected(false);
                        }
                        templateImageTile.setSelected(true);
                        ScrollableTemplateGrid.this._currentTemplate = templateImageTile.getTemplate();
                    } else {
                        ScrollableTemplateGrid.this._parentTab.start();
                    }
                }
            });
            this._templateImageTiles.add(templateImageTile);
            this._scrollablePanel.add(templateImageTile);
        }
        if (this._templateImageTiles.size() > 0) {
            this._templateImageTiles.get(0).setSelected(true);
            this._currentTemplate = this._templateImageTiles.get(0).getTemplate();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollableTemplateGrid.this.revalidate();
                ScrollableTemplateGrid.this.repaint();
            }
        });
    }

    public ITemplate getSelectedTemplate() {
        return this._currentTemplate;
    }
}

