/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser;

import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser.TemplateImageTile;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.gaia.template.IPreviewImages;
import com.thinkbuzan.gaia.template.ITemplate;
import com.thinkbuzan.gaia.template.PreviewImageSize;
import com.thinkbuzan.pascal.services.editor.ideaimages.IIdeaInserter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TemplateGrid
extends JPanel {
    private static final int WIDTH = 810;
    private static final int HEIGHT = 369;
    private static final Dimension SIZE = new Dimension(810, 369);
    public static final int ROWS = 3;
    public static final int COLUMNS = 6;
    private ArrayList<TemplateImageTile> _tiles = new ArrayList(18);
    private TemplateImageTile _selectedTile;
    private int _selectedIndex;
    private IIdeaInserter _parentTab;

    public TemplateGrid(List<ITemplate> templates, IIdeaInserter parentTab) {
        this._parentTab = parentTab;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        JPanel tiles = new JPanel();
        tiles.setLayout(new BoxLayout(tiles, 1));
        tiles.setBackground(Color.white);
        IPreviewImages templatePreviewImageManager = null;
        try {
            templatePreviewImageManager = ServiceManager.getTemplateManager().getPreviewImages();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        JPanel row = null;
        int counter = 0;
        for (ITemplate template : templates) {
            if (counter == 18) break;
            if (counter % 6 == 0) {
                row = new JPanel();
                row.setOpaque(false);
                row.setLayout(new FlowLayout(0, 0, 0));
                tiles.add(row);
            }
            ImageIcon temp = new ImageIcon(templatePreviewImageManager.getPreviewImage(template, PreviewImageSize.SMALL));
            final TemplateImageTile tile = new TemplateImageTile(template, temp);
            this._tiles.add(tile);
            tile.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() < 2) {
                        for (TemplateImageTile t : TemplateGrid.this._tiles) {
                            t.setSelected(false);
                        }
                        tile.setSelected(true);
                        TemplateGrid.this._selectedTile = tile;
                        TemplateGrid.this._selectedIndex = TemplateGrid.this._tiles.indexOf(TemplateGrid.this._selectedTile);
                    } else {
                        TemplateGrid.this._parentTab.start();
                    }
                }
            });
            row.add(tile);
            if (counter == 0) {
                this._selectedTile = tile;
                tile.setSelected(true);
                this._selectedIndex = 0;
            }
            ++counter;
        }
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new FlowLayout(0, 0, 0));
        wrapper.setOpaque(false);
        wrapper.add(tiles);
        this.add(wrapper);
    }

    public void setSelectedIndex(int index) {
        this._selectedIndex = index;
        this._selectedTile = this._tiles.get(index);
        for (TemplateImageTile t : this._tiles) {
            t.setSelected(false);
        }
        this._selectedTile.setSelected(true);
    }

    public TemplateImageTile getSelectedTile() {
        return this._selectedTile;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    public int getTileCount() {
        return this._tiles.size();
    }
}

