/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.newtemplatetab.templatechooser;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.template.ITemplate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class TemplateImageTile
extends JPanel {
    private static final int CANVAS_OPTION_PANEL_WIDTH = 135;
    private static final int CANVAS_OPTION_PANEL_HEIGHT = 123;
    private static final Dimension SIZE = new Dimension(135, 123);
    private static final int BORDER_THICKNESS = 3;
    private static final Color BORDER_COLOUR = Color.decode("#b7bdc6");
    private static final Color BORDER_HOVER_COLOUR = Color.decode("#f1f1f1");
    private static final Color BORDER_SELECTED_COLOUR = Color.decode("#c2d4f2");
    private ITemplate _template;
    private Border _border;
    private Border _hoverBorder;
    private Border _selectedBorder;
    private boolean _selected;

    public ITemplate getTemplate() {
        return this._template;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
        if (this._selected) {
            this.setBorder(this._selectedBorder);
        } else {
            this.setBorder(this._border);
        }
    }

    public TemplateImageTile(ITemplate template, ImageIcon image) {
        this.setOpaque(false);
        this._template = template;
        Border innerBorder = BorderFactory.createLineBorder(BORDER_COLOUR);
        Border outerBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this._border = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        Border outerHoverBorder = BorderFactory.createLineBorder(BORDER_HOVER_COLOUR, 3);
        this._hoverBorder = BorderFactory.createCompoundBorder(outerHoverBorder, innerBorder);
        Border outerSelectedBorder = BorderFactory.createLineBorder(BORDER_SELECTED_COLOUR, 3);
        this._selectedBorder = BorderFactory.createCompoundBorder(outerSelectedBorder, innerBorder);
        this.setBorder(this._border);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (!TemplateImageTile.this._selected) {
                    TemplateImageTile.this.setBorder(TemplateImageTile.this._hoverBorder);
                } else {
                    TemplateImageTile.this.setBorder(TemplateImageTile.this._selectedBorder);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                if (!TemplateImageTile.this._selected) {
                    TemplateImageTile.this.setBorder(TemplateImageTile.this._border);
                } else {
                    TemplateImageTile.this.setBorder(TemplateImageTile.this._selectedBorder);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JLabel imageLabel = new JLabel(image);
        this.add((Component)imageLabel, "Center");
        JLabel textLabel = this.createTextLabel();
        this.add((Component)textLabel, "South");
    }

    private JLabel createTextLabel() {
        JLabel label = new JLabel(this._template.getName(), 0);
        label.setFont(ApplicationFont.getSafeFont((String)this._template.getName(), (int)0, (float)11.0f));
        label.setForeground(Color.decode("#4e4e4e"));
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }
}

