/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class OpenMenuItem
extends JPanel {
    private static final int HEIGHT = 60;
    private static final Dimension SIZE = new Dimension(Integer.MAX_VALUE, 60);
    private ArrayList<ActionListener> _actionListeners = new ArrayList(1);
    public boolean _selected = false;

    public void setSelected(boolean selected) {
        this._selected = selected;
        if (this._selected) {
            this.setBackground(Color.decode("#c2d5f2"));
        } else {
            this.setBackground(Color.white);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public OpenMenuItem(String text, ImageIcon icon) {
        this.setBackground(Color.white);
        this.setLayout(new BoxLayout(this, 1));
        Border inner = BorderFactory.createEmptyBorder(2, 5, 2, 0);
        MatteBorder outer = BorderFactory.createMatteBorder(0, 0, 0, 1, Color.decode("#c6c6c6"));
        this.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this.add(Box.createVerticalGlue());
        this.add(this.createIconLabel(text, icon));
        this.add(Box.createVerticalGlue());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!OpenMenuItem.this.isSelected()) {
                    OpenMenuItem.this.setBackground(Color.decode("#d5e1f2"));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (OpenMenuItem.this.isSelected()) {
                    OpenMenuItem.this.setBackground(Color.decode("#c2d5f2"));
                } else {
                    OpenMenuItem.this.setBackground(Color.white);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                OpenMenuItem.this.fireActionListeners(e);
            }
        });
    }

    private void fireActionListeners(MouseEvent e) {
        for (ActionListener listener : this._actionListeners) {
            listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "mouseClicked"));
        }
    }

    private JLabel createIconLabel(String text, ImageIcon icon) {
        JLabel label = new JLabel(text, icon, 2);
        label.setFont(ApplicationFont.getRegularFont((int)0, (float)16.0f));
        label.setIconTextGap(15);
        return label;
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null && !this._actionListeners.contains(listener)) {
            this._actionListeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this._actionListeners.remove(listener);
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }
}

