/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.OpenMenuItem;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFilesPanel;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.recentfiles.RecentFiles;
import com.thinkbuzan.gaia.recentfiles.RecentFilesChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OpenTab
extends JPanel
implements RecentFilesChangedListener {
    private static final long serialVersionUID = 1L;
    private FileMenu _fileMenu;
    public static final int MAX_RECENT_FILES = 5;
    private static final int WIDTH = 250;
    private static final Dimension SIZE = new Dimension(250, Integer.MAX_VALUE);
    private static final Color FONT_COLOUR = Color.decode("#4e4e4e");
    private static final Color BORDER_COLOUR = Color.decode("#c6c6c6");
    public static final String RECENT = "Recent";
    public static final String COMPUTER = "Computer";
    private OpenMenuItem _cloud;
    private OpenMenuItem _computer;
    private OpenMenuItem _dropbox;
    private OpenMenuItem _drive;
    private OpenMenuItem _biggerplate;
    private transient RecentFiles recentFiles;
    private final transient RecentFilesPanel recentLocal;
    private final transient RecentFilesPanel recentOnline;
    private static final String OPEN_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.open");
    private static final String COMPUTER_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.computer");
    private static final String CLOUD_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.immcloud");
    private static final String DROPBOX_BUTTON_TEXT = "Dropbox";
    private static final String DRIVE_BUTTON_TEXT = "Google Drive";

    public OpenTab(FileMenu fileMenu) {
        this._fileMenu = fileMenu;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOUR));
        this.recentLocal = new RecentFilesPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.welcometab.recentmindmaps"), false);
        this.recentOnline = new RecentFilesPanel(ServiceManager.getLocalizedText("com.thinkbuzan.i18n.common.welcometab.recentsyncedmaps"), true);
        ServiceManager.addRecentFilesServiceListener((IServiceListener<RecentFiles>)new ServiceAdapter<RecentFiles>(){

            public void serviceAdded(RecentFiles service) {
                super.serviceAdded((Object)service);
                OpenTab.this.recentFiles = service;
                OpenTab.this.recentFiles.addRecentFilesChangedListener((RecentFilesChangedListener)OpenTab.this);
                OpenTab.this.recentFilesChanged();
            }
        });
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createLeftPanel(), "West");
        this.add((Component)this.createRightPanel(), "Center");
    }

    private JPanel createRecentPanel() {
        this.recentLocal.setVisible(!this.recentLocal.isEmpty());
        this.recentOnline.setVisible(!this.recentOnline.isEmpty());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JPanel w = new JPanel();
        w.setOpaque(false);
        w.setLayout(new BoxLayout(w, 0));
        panel.add((Component)w, "North");
        w.add(this.recentLocal);
        w.add(Box.createHorizontalStrut(50));
        w.add(this.recentOnline);
        return panel;
    }

    public JPanel createTopPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(0, 0, 0));
        JLabel heading = new JLabel(OPEN_BUTTON_TEXT, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)36.0f));
        heading.setBorder(BorderFactory.createEmptyBorder(30, 30, 20, 0));
        heading.setForeground(FONT_COLOUR);
        panel.add(heading);
        return panel;
    }

    public JPanel createLeftPanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return SIZE;
            }

            @Override
            public Dimension getPreferredSize() {
                return SIZE;
            }

            @Override
            public Dimension getMaximumSize() {
                return SIZE;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOUR);
                g.drawLine(this.getWidth() - 1, 5, this.getWidth() - 1, this.getHeight() - 5);
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 30, 0, 0));
        this._computer = new OpenMenuItem(COMPUTER_BUTTON_TEXT, ResourceManager.getImageIcon("file/open-computer-30px.png", 0));
        this._computer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ImportAction", new Object[0]);
            }
        });
        this._cloud = new OpenMenuItem(CLOUD_BUTTON_TEXT, ResourceManager.getImageIcon("file/open-cloud-30px.png", 0));
        this._cloud.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ShowCloudFilesDialog", new Object[0]);
            }
        });
        panel.add(this._computer);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this._cloud);
        panel.add(Box.createVerticalStrut(20));
        if (BundleLicenser.isDropBoxLicensed()) {
            this._dropbox = new OpenMenuItem(DROPBOX_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-dropbox-30px.png", 0));
            this._dropbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.OpenFromDropBoxAction", new Object[0]);
                }
            });
            panel.add(this._dropbox);
            panel.add(Box.createVerticalStrut(5));
        }
        if (BundleLicenser.isGoogleDriveLicensed()) {
            this._drive = new OpenMenuItem(DRIVE_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-drive-30px.png", 0));
            this._drive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.OpenFromDriveAction", new Object[0]);
                }
            });
            panel.add(this._drive);
        }
        this._biggerplate = new OpenMenuItem("Biggerplate", ResourceManager.getImageIcon("file/biggerplate_30px.png", 0));
        this._biggerplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.OpenFromBiggerplateAction", new Object[0]);
            }
        });
        panel.add(Box.createVerticalStrut(20));
        panel.add(this._biggerplate);
        return panel;
    }

    public JPanel createRightPanel() {
        return this.createRecentPanel();
    }

    public void recentFilesChanged() {
        if (this.recentFiles != null) {
            EDTUtilities.runOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    List localMaps = OpenTab.this.recentFiles.getFilteredRecentFiles(5, false);
                    List onlineMaps = OpenTab.this.recentFiles.getFilteredRecentFiles(5, true);
                    OpenTab.this.recentLocal.setRecentFiles(localMaps);
                    OpenTab.this.recentOnline.setRecentFiles(onlineMaps);
                    OpenTab.this.recentLocal.setVisible(!OpenTab.this.recentLocal.isEmpty());
                    OpenTab.this.recentOnline.setVisible(!OpenTab.this.recentOnline.isEmpty());
                }
            });
        }
    }
}

