/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFileData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class RecentFilesCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 7565348491528448408L;
    private static final int BORDER_X = 2;
    private static final int BORDER_Y = 2;
    private static final Insets INSET = new Insets(5, 0, 5, 0);
    private static final Border BORDER = new EmptyBorder(INSET);
    private static final Border BASIC_BORDER = BorderFactory.createEmptyBorder(2, 0, 2, 0);
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final ImageIcon IMAGE = ResourceManager.getImageIcon("file/recent_map_file.png", 0);
    private static final Insets IMAGE_BORDER = new Insets(0, 0, 0, 5);
    private static final int SIZE = 170;
    private static final Color LIGHT = new Color(4040153);
    private static final Insets NAME_BORDER = new Insets(3, 0, 3, 0);
    private transient int maximum;
    private transient int hoverIndex = -1;
    private transient MouseAdapter handler;
    private transient boolean simpleRender = false;

    public RecentFilesCellRenderer() {
        this.setOpaque(false);
        this.setBorder(EMPTY_BORDER);
    }

    public final void setBasicRenderer(boolean value) {
        this.simpleRender = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        RecentFilesCellRenderer recentFilesCellRenderer = this;
        synchronized (recentFilesCellRenderer) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            if (value instanceof RecentFileData) {
                RecentFileData recentData = (RecentFileData)value;
                JPanel textPanel = new JPanel();
                textPanel.setOpaque(false);
                textPanel.setLayout(new BoxLayout(textPanel, 1));
                JLabel fileName = new JLabel(recentData.getName());
                fileName.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
                fileName.setBorder(new EmptyBorder(NAME_BORDER));
                if (this.simpleRender) {
                    panel.setBorder(BASIC_BORDER);
                    textPanel.add(fileName);
                } else {
                    panel.setBorder(BORDER);
                    JLabel imageLabel = new JLabel(IMAGE);
                    panel.add((Component)imageLabel, "West");
                    imageLabel.setBorder(new EmptyBorder(IMAGE_BORDER));
                    JLabel filePath = new JLabel(recentData.getPath());
                    filePath.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
                    filePath.setForeground(LIGHT);
                    textPanel.add(fileName);
                    textPanel.add(filePath);
                }
                panel.add((Component)textPanel, "Center");
                textPanel.setMaximumSize(new Dimension(170, textPanel.getMaximumSize().height));
            } else {
                this.setText("");
            }
            panel.setPreferredSize(new Dimension(this.maximum, panel.getPreferredSize().height));
            panel.setMaximumSize(new Dimension(this.maximum, panel.getPreferredSize().height));
            if (!isSelected && list != null) {
                panel.setOpaque(index == this.hoverIndex);
            }
            return panel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredHeight() {
        RecentFilesCellRenderer recentFilesCellRenderer = this;
        synchronized (recentFilesCellRenderer) {
            Component dummy = this.getListCellRendererComponent((JList)null, (Object)new RecentFileData("TestXg", "TestXg", "TestXg"), 0, false, false);
            return dummy.getPreferredSize().height;
        }
    }

    public void setRecentMaximum(int sizeIn) {
        this.maximum = sizeIn;
    }

    public MouseAdapter getHandler(JList list) {
        if (this.handler == null) {
            this.handler = new HoverMouseHandler(list);
        }
        return this.handler;
    }

    class HoverMouseHandler
    extends MouseAdapter {
        private final JList list;

        public HoverMouseHandler(JList list) {
            this.list = list;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHoverIndex(-1);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int index = this.list.locationToIndex(e.getPoint());
            if (this.list != null && this.list.getCellBounds(index, index) != null) {
                this.setHoverIndex(this.list.getCellBounds(index, index).contains(e.getPoint()) ? index : -1);
            } else {
                this.setHoverIndex(-1);
            }
        }

        private void setHoverIndex(int index) {
            if (RecentFilesCellRenderer.this.hoverIndex == index) {
                return;
            }
            RecentFilesCellRenderer.this.hoverIndex = index;
            this.list.repaint();
        }
    }
}

