/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab;

import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFileData;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFilesCellRenderer;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JList;

public class RecentFilesList
extends JList {
    private static final long serialVersionUID = -2174204676998845836L;
    private final transient RecentFilesCellRenderer renderer = new RecentFilesCellRenderer();
    private ActionListener listener;

    public RecentFilesList() {
        this(false);
    }

    public RecentFilesList(boolean basicRenderer) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.renderer.setBasicRenderer(basicRenderer);
        this.setCellRenderer(this.renderer);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                int index = RecentFilesList.this.getItemIndex(evt.getPoint());
                if (index >= 0 && index < RecentFilesList.this.getModel().getSize()) {
                    RecentFilesList.this.fireOpenListener();
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.ImportFileFromPathAction", new Object[]{((RecentFileData)RecentFilesList.this.getModel().getElementAt(index)).getPath()});
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                Cursor cursor = Cursor.getDefaultCursor();
                int index = RecentFilesList.this.getItemIndex(evt.getPoint());
                if (index >= 0 && index < RecentFilesList.this.getModel().getSize()) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                RecentFilesList.this.setCursor(cursor);
            }
        });
        this.addMouseListener(this.renderer.getHandler(this));
        this.addMouseMotionListener(this.renderer.getHandler(this));
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String text = null;
        int index = this.getItemIndex(evt.getPoint());
        if (index >= 0 && index < this.getModel().getSize()) {
            text = ((RecentFileData)this.getModel().getElementAt(index)).getTooltip();
        }
        return text;
    }

    private int getItemIndex(Point point) {
        Rectangle bounds;
        int index = this.locationToIndex(point);
        if (index >= 0 && index < this.getModel().getSize() && !(bounds = this.getCellBounds(index, index)).contains(point)) {
            index = -1;
        }
        return index;
    }

    public int getItemHeight() {
        return this.renderer.getPreferredHeight();
    }

    public final void addOpenListener(ActionListener openListener) {
        this.listener = openListener;
    }

    private void fireOpenListener() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "open"));
        }
    }
}

