/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFileData;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.opentab.RecentFilesList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class RecentFilesPanel
extends JPanel {
    private static final long serialVersionUID = 8473960854855780341L;
    private final transient JPanel header;
    private final transient RecentFilesList list;
    private transient boolean online;
    private static final int WIDTH = 300;

    public RecentFilesPanel(String title, boolean onlineFiles) {
        this(title, onlineFiles, false);
    }

    public RecentFilesPanel(String title, boolean onlineFiles, boolean basicRenderer) {
        super(new BorderLayout());
        this.online = onlineFiles;
        this.setBackground(Color.white);
        this.header = new JPanel();
        this.header.setOpaque(false);
        this.header.setLayout(new FlowLayout(0, 0, 0));
        JLabel titleLabel = new JLabel(title);
        if (basicRenderer) {
            titleLabel.setForeground(Color.decode("#4e4e4e").darker().darker());
            titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        } else {
            titleLabel.setForeground(Color.decode("#4e4e4e"));
        }
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)16.0f));
        this.header.add(titleLabel);
        this.add((Component)this.header, "North");
        this.list = new RecentFilesList(basicRenderer);
        JPanel listWrapper = new JPanel(new BorderLayout());
        listWrapper.setOpaque(false);
        listWrapper.setBorder(BorderFactory.createEmptyBorder());
        listWrapper.add((Component)this.list, "Center");
        this.add((Component)listWrapper, "Center");
    }

    public boolean isEmpty() {
        return this.list.getModel().getSize() == 0;
    }

    public ListModel getModel() {
        return this.list.getModel();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superDim = super.getPreferredSize();
        int listHeight = this.list.getModel().getSize() * this.list.getItemHeight() + this.header.getSize().height;
        int max = Math.max(listHeight, superDim.height);
        return new Dimension(300, max);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(300, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 0);
    }

    public void setRecentFiles(List<String> files) {
        DefaultListModel<RecentFileData> model = new DefaultListModel<RecentFileData>();
        if (files != null) {
            for (String filePath : files) {
                File file = new File(filePath);
                RecentFileData data = this.online ? new RecentFileData(filePath, file.getName(), file.getName()) : new RecentFileData(filePath, file.getName(), file.getAbsolutePath());
                model.addElement(data);
            }
        }
        this.list.setModel(model);
    }

    public void addOpenListener(ActionListener openListener) {
        this.list.addOpenListener(openListener);
    }
}

