/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.savetab;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.apollo.ui.win.frame.ui.assets.ResourceManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.TabbedRibbon;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.FileMenu;
import com.thinkbuzan.apollo.ui.win.frame.ui.tabs.file.savetab.SaveMenuItem;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SaveTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FileMenu _fileMenu;
    private static final int WIDTH = 250;
    private static final Dimension SIZE = new Dimension(250, Integer.MAX_VALUE);
    private static final Color FONT_COLOUR = Color.decode("#4e4e4e");
    private static final Color BORDER_COLOUR = Color.decode("#c6c6c6");
    public static final String RECENT = "Recent";
    public static final String COMPUTER = "Computer";
    private SaveMenuItem _cloud;
    private SaveMenuItem _computer;
    private SaveMenuItem _template;
    private SaveMenuItem _dropbox;
    private SaveMenuItem _drive;
    private static final String SAVE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.save");
    private static final String COMPUTER_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.computer");
    private static final String CLOUD_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.boundaryDialog.cloud");
    private static final String TEMPLATE_BUTTON_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.exportManager.templateExporter.templateTitle");
    private static final String DROPBOX_BUTTON_TEXT = "Dropbox";
    private static final String DRIVE_BUTTON_TEXT = "Google Drive";

    public SaveTab(FileMenu fileMenu) {
        this._fileMenu = fileMenu;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOUR));
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createLeftPanel(), "West");
        this.add((Component)this.createRightPanel(), "Center");
    }

    public JPanel createTopPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(0, 0, 0));
        JLabel heading = new JLabel(SAVE_TEXT, 2);
        heading.setFont(ApplicationFont.getRegularFont((int)0, (float)36.0f));
        heading.setBorder(BorderFactory.createEmptyBorder(30, 30, 20, 0));
        heading.setForeground(FONT_COLOUR);
        panel.add(heading);
        return panel;
    }

    public JPanel createLeftPanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return SIZE;
            }

            @Override
            public Dimension getPreferredSize() {
                return SIZE;
            }

            @Override
            public Dimension getMaximumSize() {
                return SIZE;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOUR);
                g.drawLine(this.getWidth() - 1, 5, this.getWidth() - 1, this.getHeight() - 5);
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 30, 0, 0));
        this._computer = new SaveMenuItem(COMPUTER_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-computer-30px.png", 0));
        this._computer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveAsAction", new Object[0]);
            }
        });
        this._cloud = new SaveMenuItem(CLOUD_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-cloud-30px.png", 0));
        this._cloud.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedRibbon tabbedRibbon = SaveTab.this._fileMenu.getRibbon();
                if (tabbedRibbon != null) {
                    tabbedRibbon.goToPreviousTab();
                }
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveOnlineAction", new Object[0]);
            }
        });
        this._template = new SaveMenuItem(TEMPLATE_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-template-30px.png", 30));
        this._template.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveAsTemplateAction", new Object[0]);
            }
        });
        panel.add(this._computer);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this._cloud);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this._template);
        panel.add(Box.createVerticalStrut(20));
        if (BundleLicenser.isDropBoxLicensed()) {
            this._dropbox = new SaveMenuItem(DROPBOX_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-dropbox-30px.png", 30));
            this._dropbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveAsDropBoxAction", new Object[0]);
                }
            });
            panel.add(this._dropbox);
            panel.add(Box.createVerticalStrut(5));
        }
        if (BundleLicenser.isGoogleDriveLicensed()) {
            this._drive = new SaveMenuItem(DRIVE_BUTTON_TEXT, ResourceManager.getImageIcon("file/save-drive-30px.png", 30));
            this._drive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SaveAsDriveAction", new Object[0]);
                }
            });
            panel.add(this._drive);
        }
        return panel;
    }

    public JPanel createRightPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }
}

