/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools;

import com.thinkbuzan.apollo.ui.win.frame.ui.RibbonSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.tools.SignInButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.tools.SignOutButton;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.gaia.onlineaccountaccessclient.AccountStatus;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineListener;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class AccountSection
extends RibbonSection {
    private static final String TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.account");
    private static final int BUTTON_INDEX = 1;
    private SignInButton _signInButton = new SignInButton();
    private SignOutButton _signOutButton = new SignOutButton();

    public AccountSection() {
        super(TITLE);
        this.getContentPanel().setLayout(new BoxLayout(this.getContentPanel(), 0));
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
        this.addButtonBasedOnAccountStatus();
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
    }

    private void addButtonBasedOnAccountStatus() {
        ServiceManager.addOnlineAccountAccessClientServiceListener(new IServiceListener<OnlineAccountAccessClient>(){

            public void serviceRemoved(OnlineAccountAccessClient service) {
            }

            public void serviceAdded(OnlineAccountAccessClient service) {
                service.addOnlineListener(new OnlineListener(){

                    public void update(AccountStatus status) {
                        switch (status) {
                            case ONLINE_AUTHENTICATED: {
                                AccountSection.this.removeButtons();
                                AccountSection.this.getContentPanel().add((Component)((Object)AccountSection.this._signOutButton), 1);
                                break;
                            }
                            default: {
                                AccountSection.this.removeButtons();
                                AccountSection.this.getContentPanel().add((Component)((Object)AccountSection.this._signInButton), 1);
                            }
                        }
                    }
                });
            }
        });
    }

    private void removeButtons() {
        this.getContentPanel().remove((Component)((Object)this._signInButton));
        this.getContentPanel().remove((Component)((Object)this._signOutButton));
    }
}

