/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.frame.ui.tabs.tools;

import com.thinkbuzan.apollo.ui.win.frame.ui.RibbonSection;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.tools.LockButton;
import com.thinkbuzan.apollo.ui.win.frame.ui.buttons.tools.UnlockButton;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MapSection
extends RibbonSection {
    private static final long serialVersionUID = -5969238977473978066L;
    private static final String TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.map");
    private static final int BUTTON_INDEX = 1;
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.ProtectMapAction";
    private final transient LockButton _lockButton;
    private final transient UnlockButton _unlockButton;
    private transient boolean active = false;

    public MapSection() {
        super(TITLE);
        Callable<Void> lockListener = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MapSection.this.update();
                return null;
            }
        };
        this._lockButton = new LockButton(lockListener);
        this._unlockButton = new UnlockButton(lockListener);
        this.addEditorServiceListener();
        this.update();
    }

    private void addEditorServiceListener() {
        ServiceManager.getActionManager().hookActionStateListener(ACTION_ID, (JComponent)this);
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<IEditorManager>(){

            public void serviceRemoved(IEditorManager service) {
            }

            public void serviceAdded(IEditorManager service) {
                try {
                    ServiceManager.getEditorManager().addEditorViewListener(new IEditorViewListener(){

                        public void editorChanged(IEditorView editor) {
                            if (editor != null) {
                                MapSection.this.updateButtonStateForEditor();
                                MapSection.this.active = true;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn((Object)("Unable to find editor: " + e.getMessage()));
                }
            }
        });
    }

    public void update() {
        this.getContentPanel().removeAll();
        this.getContentPanel().setLayout(new BoxLayout(this.getContentPanel(), 0));
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
        this.updateButtonStateForEditor();
        this.getContentPanel().add(Box.createRigidArea(new Dimension(5, 5)));
    }

    private void removeButtons() {
        this.getContentPanel().remove((Component)((Object)this._lockButton));
        this.getContentPanel().remove((Component)((Object)this._unlockButton));
    }

    private void updateButtonStateForEditor() {
        if (this.active) {
            try {
                IEditorView editor = ServiceManager.getEditorManager().getCurrentEditorComponent();
                if (editor != null && editor.isMapProtected()) {
                    this.removeButtons();
                    this.getContentPanel().add((Component)((Object)this._unlockButton), 1);
                } else {
                    this.removeButtons();
                    this.getContentPanel().add((Component)((Object)this._lockButton), 1);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to find editor: " + e.getMessage()));
            }
        }
    }
}

