/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.osgi;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.phoenix.licensing.LicenseState;
import com.thinkbuzan.phoenix.licensing.PluginLicense;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import org.osgi.framework.BundleContext;

public final class BundleLicenser {
    private static final String PROJECT_VIEW_LICENSE_ID = "com.thinkbuzan.license.gaia.projectview";
    private static final String THREED_VIEW_LICENSE_ID = "com.thinkbuzan.license.gaia.3dview";
    private static final String PRESENTATION_VIEW_LICENSE_ID = "com.thinkbuzan.license.gaia.presentationview";
    private static final String THREED_PRESENTATION_VIEW_LICENSE_ID = "com.thinkbuzan.license.gaia.presentationview.3d";
    private static final String TEXT_VIEW_LICENSE_ID = "com.thinkbuzan.license.gaia.textview";
    private static final String BRANCH_ART_LICENSE_ID = "com.thinkbuzan.license.pascal.branchart";
    private static final String SMARTLAYOUT_LICENSE_ID = "com.thinkbuzan.license.gaia.smartlayout";
    private static final String SNIPPETS_LICENSE_ID = "com.thinkbuzan.license.phoenix.mappartspanel";
    private static final String PIN_LICENSE_ID = "com.thinkbuzan.license.gaia.branchfreeze";
    private static final String BACKGROUND_LICENSE_ID = "com.thinkbuzan.license.gaia.backgroundcolour";
    private static final String FREEHAND_LICENSE_ID = "com.thinkbuzan.license.gaia.freehand";
    private static final String EXPANDCOLLAPSE_LICENSE_ID = "com.thinkbuzan.license.gaia.expandcollapse";
    private static final String FOCUSINOUT_LICENSE_ID = "com.thinkbuzan.license.gaia.focusonout";
    private static final String FILTERING_LICENSE_ID = "com.thinkbuzan.license.gaia.mapfiltering";
    private static final String STYLES_LICENSE_ID = "com.thinkbuzan.license.gaia.styles";
    private static final String MULTIMAPS_LICENSE_ID = "com.thinkbuzan.license.gaia.multimap";
    private static final String CHILDMAPS_LICENSE_ID = "com.thinkbuzan.license.gaia.childmaps";
    private static final String BRAINSTORMING_LICENSE_ID = "com.thinkbuzan.license.view.brainstorm";
    private static final String FORMATDIALOG_LICENSE_ID = "com.thinkbuzan.license.phoenix.formatdialog";
    private static final String COMMENTS_LICENSE_ID = "com.thinkbuzan.license.gaia.mapcomments";
    private static final String WIZARDS_LICENSE_ID = "com.thinkbuzan.license.gaia.wizards";
    private static final String TEMPLATES_LICENSE_ID = "com.thinkbuzan.license.gaia.templates";
    private static final String CONDENSE_LICENSE_ID = "com.thinkbuzan.license.gaia.condense";
    private static final String FAST_CAPTURE_LICENSE_ID = "com.thinkbuzan.license.view.fastcapture";
    private static final String OUTLINE_PANEL_LICENSE_ID = "com.thinkbuzan.license.gaia.outlinepanel";
    private static final String BACKGROUND_IMAGE_LICENSE_ID = "com.thinkbuzan.license.orion.backgroundimage";
    private static final String INTEGRATION_DRIVE_LICENSE_ID = "com.thinkbuzan.license.integrations.drive";
    private static final String INTEGRATION_DROPBOX_LICENSE_ID = "com.thinkbuzan.license.integrations.dropbox";
    private static final String INTEGRATION_EVERNOTE_LICENSE_ID = "com.thinkbuzan.license.integrations.evernote";
    private static final String ULTIMATE_VERSION_LICENSE_ID = "com.thinkbuzan.license.gaia.edition.ultimate";
    private static final String HOMESTUDENT_VERSION_LICENSE_ID = "com.thinkbuzan.license.gaia.edition.homeandstudent";
    private static final String TIMELINE_LICENSE_ID = "com.thinkbuzan.license.view.fastcapture";
    private static transient PluginLicenseService pluginLicenseService;

    private BundleLicenser() {
    }

    public static void initLicenser(BundleContext context) {
        pluginLicenseService = (PluginLicenseService)new OSGiService(context, PluginLicenseService.class).get();
    }

    public static boolean isPresentationViewLicensed() {
        return BundleLicenser.isIdLicensed(PRESENTATION_VIEW_LICENSE_ID);
    }

    public static boolean is3dPresentationViewLicensed() {
        return BundleLicenser.isIdLicensed(THREED_PRESENTATION_VIEW_LICENSE_ID);
    }

    public static boolean isProjectViewLicensed() {
        return BundleLicenser.isIdLicensed(PROJECT_VIEW_LICENSE_ID);
    }

    public static boolean is3DViewLicensed() {
        return BundleLicenser.isIdLicensed(THREED_VIEW_LICENSE_ID);
    }

    public static boolean isTextViewLicensed() {
        return BundleLicenser.isIdLicensed(TEXT_VIEW_LICENSE_ID);
    }

    public static boolean isBranchArtLicensed() {
        return BundleLicenser.isIdLicensed(BRANCH_ART_LICENSE_ID);
    }

    public static boolean isSmartLayoutLicensed() {
        return BundleLicenser.isIdLicensed(SMARTLAYOUT_LICENSE_ID);
    }

    public static boolean isMapSnippetsLicensed() {
        return BundleLicenser.isIdLicensed(SNIPPETS_LICENSE_ID);
    }

    public static boolean isBranchPinningLicensed() {
        return BundleLicenser.isIdLicensed(PIN_LICENSE_ID);
    }

    public static boolean isBackgroundLicensed() {
        return BundleLicenser.isIdLicensed(BACKGROUND_LICENSE_ID);
    }

    public static boolean isFreehandLicensed() {
        return BundleLicenser.isIdLicensed(FREEHAND_LICENSE_ID);
    }

    public static boolean isExpandCollapseLicensed() {
        return BundleLicenser.isIdLicensed(EXPANDCOLLAPSE_LICENSE_ID);
    }

    public static boolean isFocusInOutLicensed() {
        return BundleLicenser.isIdLicensed(FOCUSINOUT_LICENSE_ID);
    }

    public static boolean isFilteringLicensed() {
        return BundleLicenser.isIdLicensed(FILTERING_LICENSE_ID);
    }

    public static boolean isStylesLicensed() {
        return BundleLicenser.isIdLicensed(STYLES_LICENSE_ID);
    }

    public static boolean isMultiMapsLicensed() {
        return BundleLicenser.isIdLicensed(MULTIMAPS_LICENSE_ID);
    }

    public static boolean isChildMapsLicensed() {
        return BundleLicenser.isIdLicensed(CHILDMAPS_LICENSE_ID);
    }

    public static boolean isBrainstormingLicensed() {
        return BundleLicenser.isIdLicensed(BRAINSTORMING_LICENSE_ID);
    }

    public static boolean isFastCaptureLicensed() {
        return BundleLicenser.isIdLicensed("com.thinkbuzan.license.view.fastcapture");
    }

    public static boolean isFormatDialogLicensed() {
        return BundleLicenser.isIdLicensed(FORMATDIALOG_LICENSE_ID);
    }

    public static boolean isCommentsLicensed() {
        return BundleLicenser.isIdLicensed(COMMENTS_LICENSE_ID);
    }

    public static boolean isWizardsLicensed() {
        return BundleLicenser.isIdLicensed(WIZARDS_LICENSE_ID);
    }

    public static boolean isTemplatesLicensed() {
        return BundleLicenser.isIdLicensed(TEMPLATES_LICENSE_ID);
    }

    public static boolean isCondenseLicensed() {
        return BundleLicenser.isIdLicensed(CONDENSE_LICENSE_ID);
    }

    public static boolean isOutlinePanelLicensed() {
        return BundleLicenser.isIdLicensed(OUTLINE_PANEL_LICENSE_ID);
    }

    public static boolean isBackgroundImageLicensed() {
        return BundleLicenser.isIdLicensed(BACKGROUND_IMAGE_LICENSE_ID);
    }

    public static boolean isGoogleDriveLicensed() {
        return BundleLicenser.isIdLicensed(INTEGRATION_DRIVE_LICENSE_ID);
    }

    public static boolean isDropBoxLicensed() {
        return BundleLicenser.isIdLicensed(INTEGRATION_DROPBOX_LICENSE_ID);
    }

    public static boolean isEvernoteLicensed() {
        return BundleLicenser.isIdLicensed(INTEGRATION_EVERNOTE_LICENSE_ID);
    }

    public static boolean isUltimateVersion() {
        return BundleLicenser.isIdLicensed(ULTIMATE_VERSION_LICENSE_ID);
    }

    public static boolean isHomeAndStudentVersion() {
        return BundleLicenser.isIdLicensed(HOMESTUDENT_VERSION_LICENSE_ID);
    }

    public static boolean isTimelineLicensed() {
        return BundleLicenser.isIdLicensed("com.thinkbuzan.license.view.fastcapture");
    }

    private static boolean isLicenseActive(PluginLicense pluginLicense) {
        return pluginLicense != null && LicenseState.valid.equals((Object)pluginLicense.getState());
    }

    public static boolean isIdLicensed(String licenseId) {
        return pluginLicenseService != null && BundleLicenser.isLicenseActive(pluginLicenseService.getPluginLicense(licenseId));
    }
}

