/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.ActionMissingException;
import com.buzanonline.chaos.action.IAction;
import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.apollo.ui.win.action.CollapseRibbonAction;
import com.thinkbuzan.apollo.ui.win.action.ShowFileMenuNewFromTemplateTabAction;
import com.thinkbuzan.apollo.ui.win.action.ShowFileMenuNewTabAction;
import com.thinkbuzan.apollo.ui.win.action.ShowFileMenuOpenTabAction;
import com.thinkbuzan.apollo.ui.win.action.ShowNextEditorComponentAction;
import com.thinkbuzan.apollo.ui.win.action.ShowPreviousEditorComponentAction;
import com.thinkbuzan.apollo.ui.win.action.ToggleFullScreenAction;
import com.thinkbuzan.apollo.ui.win.action.ToggleMapOverviewPanelAction;
import com.thinkbuzan.apollo.ui.win.editor.EditorTabManager;
import com.thinkbuzan.apollo.ui.win.frame.ui.MindMapFrame;
import com.thinkbuzan.apollo.ui.win.osgi.BundleLicenser;
import com.thinkbuzan.apollo.ui.win.osgi.ServiceManager;
import com.thinkbuzan.apollo.ui.win.shortcuts.ShortcutHandler;
import com.thinkbuzan.apollo.ui.win.sidepanels.SidePanelHandler;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceNotAvailableException;
import com.thinkbuzan.chaos.preload.IPreloadContext;
import com.thinkbuzan.chaos.preload.IStartRequestListener;
import com.thinkbuzan.chaos.preload.Preload;
import com.thinkbuzan.chaos.splash.SplashService;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.shortcutmanager.ShortcutManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.gaia.ui.sidepanels.IPanelHandler;
import com.thinkbuzan.gaia.ui.sidepanels.SidePanelManager;
import com.thinkbuzan.pascal.services.editor.IEditorTabManager;
import com.thinkbuzan.pascal.services.nativelibs.INativeLibraryManager;
import com.thinkbuzan.pascal.services.overlay.IGlobalOverlayManager;
import com.thinkbuzan.pascal.services.overlay.IOverlayManager;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class OSGiManager
implements BundleActivator {
    private static final transient Logger LOGGER = Logger.getLogger(OSGiManager.class);
    private static final transient int WINDOW_WIDTH = 1300;
    private static final transient int WINDOW_HEIGHT = 700;
    private static final int MIN_WIDTH = 800;
    private static final int MIN_HEIGHT = 450;
    private static final String SHUTDOWN_ACTION = "com.thinkbuzan.gaia.actions.ShutdownAction";
    private transient AtomicBoolean startRequestedBoolean;
    private transient Lock startRequestedLock;
    private transient Condition startRequestedCondition;
    private transient JFrame frame;

    public final void start(BundleContext bundleContext) throws Exception {
        ServiceManager.setupPendingServices(bundleContext);
        BundleLicenser.initLicenser(bundleContext);
        this.registerServicesWithServiceManager(bundleContext);
        OSGiService nativeLibService = new OSGiService(bundleContext, INativeLibraryManager.class);
        try {
            ((INativeLibraryManager)nativeLibService.get()).updateNativeLibraries();
        }
        catch (ServiceNotAvailableException exc) {
            LOGGER.warn((Object)"No INativeLibraryManager has been registered! native libraries will not be updated");
        }
        catch (Exception exc) {
            LOGGER.warn((Object)"could not update native libraries!", (Throwable)exc);
        }
        nativeLibService.close();
        ShortcutHandler.createShortcuts();
        this.frame = new MindMapFrame();
        EditorTabManager editorTabManager = new EditorTabManager((MindMapFrame)this.frame);
        bundleContext.registerService(IEditorTabManager.class.getName(), (Object)editorTabManager, null);
        bundleContext.registerService(IGlobalOverlayManager.class.getName(), (Object)this.frame, null);
        ServiceManager.addSidePanelManagerServiceListener((IServiceListener<SidePanelManager>)new ServiceAdapter<SidePanelManager>(){

            public void serviceAdded(SidePanelManager service) {
                super.serviceAdded((Object)service);
                service.registerHandler((IPanelHandler)new SidePanelHandler(service, (MindMapFrame)OSGiManager.this.frame));
            }
        });
        this.frame.setDefaultCloseOperation(0);
        this.frame.setMinimumSize(new Dimension(800, 450));
        boolean maximised = ServiceManager.getPreferencesService().getCurrentUserPreferences().getBoolean("FRAME_MAXIMISED", false);
        int x = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_POS_X", 0);
        int y = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_POS_Y", 0);
        int w = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_WIDTH", 1300);
        int h = ServiceManager.getPreferencesService().getCurrentUserPreferences().getInt("FRAME_HEIGHT", 700);
        Rectangle bounds = new Rectangle(x, y, w, h);
        this.frame.setBounds(bounds);
        this.frame.setExtendedState(0);
        if (maximised) {
            ((MindMapFrame)this.frame).maximise();
        } else {
            ((MindMapFrame)this.frame).setMinimiseBounds(bounds);
            ((MindMapFrame)this.frame).minimise();
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                try {
                    ServiceManager.getPreferencesService().getCurrentUserPreferences().putBoolean("FRAME_MAXIMISED", ((MindMapFrame)OSGiManager.this.frame).isMaximised());
                    ServiceManager.getActionManager().runAction(OSGiManager.SHUTDOWN_ACTION, new Object[0]);
                }
                catch (ActionMissingException exc) {
                    Logger.getLogger(OSGiManager.class).error((Object)"Can not shutdown until shutdown action is registered!");
                }
            }
        });
        MainFrameUtilities.setMainFrame((Frame)this.frame);
        this.addStartListener(bundleContext);
        this.registerActions(bundleContext);
        Thread guiLoaderThread = this.createGUILoaderThread(bundleContext);
        guiLoaderThread.start();
        ShortcutHandler.installShortcuts(this.frame);
    }

    public final void stop(BundleContext bundleContext) throws Exception {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        ServiceManager.closePendingServices();
    }

    private void registerServicesWithServiceManager(BundleContext bundleContext) {
        OSGiService licenseService = new OSGiService(bundleContext, PluginLicenseService.class);
        ServiceManager.setPluginLicenseService((PluginLicenseService)licenseService.get());
        licenseService.close();
        this.checkLicense(ServiceManager.getPluginLicenseService());
        OSGiService i18nService = new OSGiService(bundleContext, I18n.class);
        ServiceManager.setI18nService((I18n)i18nService.get());
        i18nService.close();
        OSGiService prefsService = new OSGiService(bundleContext, PreferencesService.class);
        ServiceManager.setPreferencesService((PreferencesService)prefsService.get());
        prefsService.close();
        OSGiService actionMan = new OSGiService(bundleContext, ActionManager.class);
        ServiceManager.setActionManager((ActionManager)actionMan.get());
        actionMan.close();
        OSGiService overlayManager = new OSGiService(bundleContext, IOverlayManager.class);
        ServiceManager.setOverlayManager((IOverlayManager)overlayManager.get());
        overlayManager.close();
        OSGiService fileAccessService = new OSGiService(bundleContext, FileAccessService.class);
        ServiceManager.setFileAccessService((FileAccessService)fileAccessService.get());
        fileAccessService.close();
        OSGiService shortcutService = new OSGiService(bundleContext, ShortcutManager.class);
        ServiceManager.setShortcutManager((ShortcutManager)shortcutService.get());
        shortcutService.close();
    }

    private void registerActions(BundleContext bundleContext) {
        ServiceManager.getActionManager().addAction((IAction)new ShowFileMenuNewTabAction((MindMapFrame)this.frame));
        ServiceManager.getActionManager().addAction((IAction)new ShowFileMenuNewFromTemplateTabAction((MindMapFrame)this.frame));
        ServiceManager.getActionManager().addAction((IAction)new ShowFileMenuOpenTabAction((MindMapFrame)this.frame));
        ServiceManager.getActionManager().addAction((IAction)new ShowNextEditorComponentAction(bundleContext));
        ServiceManager.getActionManager().addAction((IAction)new ShowPreviousEditorComponentAction(bundleContext));
        ServiceManager.getActionManager().addAction((IAction)new CollapseRibbonAction((MindMapFrame)this.frame));
        ServiceManager.getActionManager().addAction((IAction)new ToggleFullScreenAction((MindMapFrame)this.frame));
        ServiceManager.getActionManager().addAction((IAction)new ToggleMapOverviewPanelAction((MindMapFrame)this.frame, ((MindMapFrame)this.frame).getMapOutlinePanel()));
    }

    private void checkLicense(PluginLicenseService pluginLicenseService) {
        try {
            if (!pluginLicenseService.isLicenseValid(false)) {
                LOGGER.error((Object)"Invalid license detected, shutting down");
                this.forceShutdown();
            }
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Problem getting the licensing info, shutting down", (Throwable)ex);
            this.forceShutdown();
        }
    }

    private void forceShutdown() {
        try {
            ServiceManager.getActionManager().runAction(SHUTDOWN_ACTION, new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Could not run shutdown action, forcing stop", (Throwable)ex);
            System.exit(1);
        }
    }

    private void addStartListener(BundleContext context) {
        this.startRequestedBoolean = new AtomicBoolean();
        this.startRequestedLock = new ReentrantLock();
        this.startRequestedCondition = this.startRequestedLock.newCondition();
        OSGiService preloadService = new OSGiService(context, Preload.class);
        Preload preload = (Preload)preloadService.get();
        preload.addStartRequestListener(new IStartRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startRequested(IPreloadContext preloadContext) {
                OSGiManager.this.startRequestedLock.lock();
                try {
                    OSGiManager.this.startRequestedBoolean.set(true);
                    OSGiManager.this.startRequestedCondition.signal();
                }
                finally {
                    OSGiManager.this.startRequestedLock.unlock();
                }
            }
        });
    }

    private Thread createGUILoaderThread(final BundleContext bundleContext) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug((Object)"blocking until start requested");
                    this.blockUntilStartRequested();
                    OSGiService splashService = new OSGiService(bundleContext, SplashService.class);
                    ((SplashService)splashService.get()).setVisible(false);
                    splashService.close();
                    OSGiManager.this.frame.setVisible(true);
                    ServiceManager.addOnlineAccountAccessClientServiceListener((IServiceListener<OnlineAccountAccessClient>)new ServiceAdapter<OnlineAccountAccessClient>(){

                        public void serviceAdded(OnlineAccountAccessClient service) {
                            service.silentSignIn();
                        }
                    });
                }
                catch (Exception exc) {
                    LOGGER.error((Object)"Could not create the mac UI");
                    LOGGER.error((Object)("Message: " + exc.getMessage()));
                    for (StackTraceElement ste : exc.getStackTrace()) {
                        LOGGER.error((Object)ste);
                    }
                    OSGiManager.this.forceShutdown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void blockUntilStartRequested() throws InterruptedException {
                OSGiManager.this.startRequestedLock.lock();
                try {
                    while (!OSGiManager.this.startRequestedBoolean.get()) {
                        OSGiManager.this.startRequestedCondition.await();
                    }
                }
                finally {
                    OSGiManager.this.startRequestedLock.unlock();
                }
            }
        }, "GUILoaderThread");
    }
}

