/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.apollo.ui.win.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.PendingServiceManager;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceAdapter;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.recentfiles.RecentFiles;
import com.thinkbuzan.gaia.shortcutmanager.ShortcutManager;
import com.thinkbuzan.gaia.tdviewinterface.TDViewInterface;
import com.thinkbuzan.gaia.template.TemplateManager;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import com.thinkbuzan.gaia.ui.sidepanels.SidePanelManager;
import com.thinkbuzan.gaia.version.VersionManager;
import com.thinkbuzan.pascal.services.cloud.ICloudAreaFactory;
import com.thinkbuzan.pascal.services.contacts.IAuthenticatedUserManager;
import com.thinkbuzan.pascal.services.contacts.IContactsAreaFactory;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.hints.IHintController;
import com.thinkbuzan.pascal.services.hints.IHintFactory;
import com.thinkbuzan.pascal.services.images.IImageService;
import com.thinkbuzan.pascal.services.notifications.INotificationController;
import com.thinkbuzan.pascal.services.overlay.IOverlayManager;
import com.thinkbuzan.pascal.services.preferences.PreferencesAreaManager;
import com.thinkbuzan.pascal.services.styles.IStylesPopupService;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public final class ServiceManager {
    private static final List<PendingServiceManager<?>> PENDING_SERVICES = new ArrayList();
    private static PendingServiceManager<IEditorManager> editorService;
    private static PendingServiceManager<OnlineAccountAccessClient> oaacService;
    private static PendingServiceManager<RecentFiles> recentFilesService;
    private static PendingServiceManager<INotificationController> notificationsService;
    private static PendingServiceManager<IContactsAreaFactory> contactsAreaService;
    private static PendingServiceManager<PreferencesAreaManager> prefsAreaManager;
    private static PendingServiceManager<IAuthenticatedUserManager> userHandler;
    private static PendingServiceManager<ICloudAreaFactory> cloudAreaService;
    private static PendingServiceManager<VersionManager> versionService;
    private static PendingServiceManager<TemplateManager> templatesService;
    private static PendingServiceManager<IHintController> hintControllerService;
    private static PendingServiceManager<IHintFactory> hintFactoryService;
    private static PendingServiceManager<SidePanelManager> sidePanelService;
    private static PendingServiceManager<IStylesPopupService> stylesPopupService;
    private static PendingServiceManager<TDViewInterface> tdViewInterface;
    private static PendingServiceManager<ThemeManager> themeManagerService;
    private static PendingServiceManager<IImageService> imageService;
    private static PreferencesService prefsService;
    private static ActionManager actionMan;
    private static IOverlayManager overlayManager;
    private static PluginLicenseService licenseService;
    private static FileAccessService fileAccess;
    private static I18n i18n;
    private static ShortcutManager shortcutManager;
    private static VersionManager versionManager;

    private ServiceManager() {
    }

    public static String getLocalizedText(String key) {
        return ServiceManager.getI18n().getLocalizedText(key);
    }

    public static String getLocalizedText(String key, Object ... args) {
        return ServiceManager.getI18n().getLocalizedText(key, args);
    }

    public static PreferencesService getPreferencesService() {
        return prefsService;
    }

    public static void setPreferencesService(PreferencesService preferencesService) {
        prefsService = preferencesService;
    }

    public static ActionManager getActionManager() {
        return actionMan;
    }

    public static void setActionManager(ActionManager actionManIn) {
        actionMan = actionManIn;
    }

    public static IOverlayManager getOverlayManager() {
        return overlayManager;
    }

    public static void setOverlayManager(IOverlayManager overlayManagerIn) {
        overlayManager = overlayManagerIn;
    }

    public static PluginLicenseService getPluginLicenseService() {
        return licenseService;
    }

    public static void setPluginLicenseService(PluginLicenseService licenseServiceIn) {
        licenseService = licenseServiceIn;
    }

    public static FileAccessService getFileAccessService() {
        return fileAccess;
    }

    public static void setFileAccessService(FileAccessService fileAccessIn) {
        fileAccess = fileAccessIn;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public static void setI18nService(I18n i18nSevice) {
        i18n = i18nSevice;
    }

    public static ShortcutManager getShortcutManager() {
        return shortcutManager;
    }

    public static void setShortcutManager(ShortcutManager shortcutManagerIn) {
        shortcutManager = shortcutManagerIn;
    }

    public static void setupPendingServices(BundleContext bundleContext) {
        editorService = new PendingServiceManager(new OSGiService(bundleContext, IEditorManager.class));
        PENDING_SERVICES.add(editorService);
        oaacService = new PendingServiceManager(new OSGiService(bundleContext, OnlineAccountAccessClient.class));
        PENDING_SERVICES.add(oaacService);
        recentFilesService = new PendingServiceManager(new OSGiService(bundleContext, RecentFiles.class));
        PENDING_SERVICES.add(recentFilesService);
        notificationsService = new PendingServiceManager(new OSGiService(bundleContext, INotificationController.class));
        PENDING_SERVICES.add(notificationsService);
        contactsAreaService = new PendingServiceManager(new OSGiService(bundleContext, IContactsAreaFactory.class));
        PENDING_SERVICES.add(contactsAreaService);
        prefsAreaManager = new PendingServiceManager(new OSGiService(bundleContext, PreferencesAreaManager.class));
        PENDING_SERVICES.add(prefsAreaManager);
        userHandler = new PendingServiceManager(new OSGiService(bundleContext, IAuthenticatedUserManager.class));
        PENDING_SERVICES.add(userHandler);
        cloudAreaService = new PendingServiceManager(new OSGiService(bundleContext, ICloudAreaFactory.class));
        PENDING_SERVICES.add(cloudAreaService);
        versionService = new PendingServiceManager(new OSGiService(bundleContext, VersionManager.class));
        PENDING_SERVICES.add(versionService);
        templatesService = new PendingServiceManager(new OSGiService(bundleContext, TemplateManager.class));
        PENDING_SERVICES.add(templatesService);
        hintControllerService = new PendingServiceManager(new OSGiService(bundleContext, IHintController.class));
        PENDING_SERVICES.add(hintControllerService);
        hintFactoryService = new PendingServiceManager(new OSGiService(bundleContext, IHintFactory.class));
        PENDING_SERVICES.add(hintFactoryService);
        sidePanelService = new PendingServiceManager(new OSGiService(bundleContext, SidePanelManager.class));
        PENDING_SERVICES.add(sidePanelService);
        stylesPopupService = new PendingServiceManager(new OSGiService(bundleContext, IStylesPopupService.class));
        PENDING_SERVICES.add(stylesPopupService);
        tdViewInterface = new PendingServiceManager(new OSGiService(bundleContext, TDViewInterface.class));
        PENDING_SERVICES.add(tdViewInterface);
        themeManagerService = new PendingServiceManager(new OSGiService(bundleContext, ThemeManager.class));
        PENDING_SERVICES.add(themeManagerService);
        imageService = new PendingServiceManager(new OSGiService(bundleContext, IImageService.class));
        PENDING_SERVICES.add(imageService);
    }

    public static void closePendingServices() {
        for (PendingServiceManager<?> service : PENDING_SERVICES) {
            service.close();
        }
        PENDING_SERVICES.clear();
    }

    public static IEditorManager getEditorManager() throws Exception {
        if (editorService == null || editorService.getService() == null) {
            throw new IllegalStateException("Cannot access IEditorManager service until it has been registered!");
        }
        return (IEditorManager)editorService.getService();
    }

    public static ThemeManager getThemeManager() throws Exception {
        if (themeManagerService == null || themeManagerService.getService() == null) {
            throw new IllegalStateException("Cannot access ThemeManager service until it has been registered!");
        }
        return (ThemeManager)themeManagerService.getService();
    }

    public static IImageService getImageService() throws Exception {
        if (imageService == null || imageService.getService() == null) {
            throw new IllegalStateException("Cannot access imageService service until it has been registered!");
        }
        return (IImageService)imageService.getService();
    }

    public static TemplateManager getTemplateManager() throws Exception {
        if (templatesService == null || templatesService.getService() == null) {
            throw new IllegalStateException("Cannot access TemplateManager service until it has been registered!");
        }
        return (TemplateManager)templatesService.getService();
    }

    public static VersionManager getVersionManager() throws Exception {
        if (versionService == null || versionService.getService() == null) {
            throw new IllegalStateException("Cannot access VersionManager service until it has been registered!");
        }
        return (VersionManager)versionService.getService();
    }

    public static OnlineAccountAccessClient getOnlineAccountAccess() throws Exception {
        if (oaacService == null || oaacService.getService() == null) {
            throw new IllegalStateException("Cannot access OnlineAccountAccessClient service until it has been registered!");
        }
        return (OnlineAccountAccessClient)oaacService.getService();
    }

    public static void addEditorManagerServiceListener(IServiceListener<IEditorManager> listener) {
        if (editorService != null) {
            editorService.addListener(listener);
        }
    }

    public static void addOnlineAccountAccessClientServiceListener(IServiceListener<OnlineAccountAccessClient> listener) {
        oaacService.addListener(listener);
    }

    public static void addRecentFilesServiceListener(IServiceListener<RecentFiles> listener) {
        recentFilesService.addListener(listener);
    }

    public static void addNotificationControllerServiceListener(IServiceListener<INotificationController> listener) {
        notificationsService.addListener(listener);
    }

    public static void addContactsAreaServiceListener(ServiceAdapter<IContactsAreaFactory> listener) {
        contactsAreaService.addListener(listener);
    }

    public static void addPreferencesAreaManagerServiceListener(IServiceListener<PreferencesAreaManager> listener) {
        prefsAreaManager.addListener(listener);
    }

    public static void addUserHandlerServiceListener(IServiceListener<IAuthenticatedUserManager> listener) {
        userHandler.addListener(listener);
    }

    public static void addCloudAreaServiceListener(ServiceAdapter<ICloudAreaFactory> listener) {
        cloudAreaService.addListener(listener);
    }

    public static void addVersionManagerServiceListener(IServiceListener<VersionManager> listener) {
        versionService.addListener(listener);
    }

    public static void addTemplateManagerServiceListener(IServiceListener<TemplateManager> listener) {
        templatesService.addListener(listener);
    }

    public static void addHintControllerServiceListener(IServiceListener<IHintController> listener) {
        hintControllerService.addListener(listener);
    }

    public static void addHintFactoryServiceListener(IServiceListener<IHintFactory> listener) {
        hintFactoryService.addListener(listener);
    }

    public static void addSidePanelManagerServiceListener(IServiceListener<SidePanelManager> listener) {
        sidePanelService.addListener(listener);
    }

    public static void addStylesPopupServiceListener(IServiceListener<IStylesPopupService> listener) {
        stylesPopupService.addListener(listener);
    }

    public static void addTDViewInterfaceServiceListener(IServiceListener<TDViewInterface> listener) {
        tdViewInterface.addListener(listener);
    }

    public static PendingServiceManager<TDViewInterface> getPendingTDViewInterface() {
        return tdViewInterface;
    }

    public static void addThemeManagerServiceListener(IServiceListener<ThemeManager> listener) {
        themeManagerService.addListener(listener);
    }

    public static void addImageServiceListener(IServiceListener<IImageService> listener) {
        imageService.addListener(listener);
    }
}

