/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.presentation.animation;

import com.buzanonline.chaos.guiutilities.math.IEasing;
import com.buzanonline.chaos.guiutilities.math.InOutEasing;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.swing.util.mxAnimation;
import com.thinkbuzan.phoenix.presentation.animation.AnimationProgressData;
import com.thinkbuzan.phoenix.presentation.animation.AnimationType;
import com.thinkbuzan.phoenix.presentation.controller.PresentationController;
import com.thinkbuzan.phoenix.presentation.controller.PresentationViewController;
import com.thinkbuzan.phoenix.presentation.editor.AbstractPresentationEditor;
import com.thinkbuzan.phoenix.presentation.model.CellVisibiltyMode;
import com.thinkbuzan.phoenix.presentation.model.Presentation;
import com.thinkbuzan.phoenix.presentation.model.SlideGroup;
import com.thinkbuzan.phoenix.presentation.model.UnknownPropertyStore;
import com.thinkbuzan.phoenix.presentation.model.ZoomData;
import com.thinkbuzan.phoenix.presentation.utils.CellUtils;
import com.thinkbuzan.phoenix.presentation.utils.Validator;
import com.thinkbuzan.phoenix.presentation.utils.Validator$ValidatorPair;
import com.thinkbuzan.phoenix.presentation.utils.ZoomUtils;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Animation
extends mxAnimation {
    private static final Logger a;
    private final transient List<mmCell> b;
    private final transient List<mmCell> c;
    private final transient IEasing d;
    private final transient AbstractPresentationEditor e;
    private final transient Presentation f;
    private final transient int g;
    private final transient SlideGroup h;
    private final transient SlideGroup i;
    private final transient Point2D j;
    private final transient double k;
    private final transient double l;
    private final transient Point2D m;
    private final transient double n;
    private final transient double o;
    private final transient AnimationProgressData p;
    private transient boolean q;
    private transient long r;
    public static boolean s;
    private static final String[] A;

    public Animation(AbstractPresentationEditor abstractPresentationEditor, Presentation presentation, SlideGroup slideGroup, SlideGroup slideGroup2, int n2, Rectangle rectangle, AnimationProgressData animationProgressData, AnimationType animationType) {
        List<mmCell> list;
        ZoomData zoomData;
        boolean bl = s;
        this.b = new ArrayList<mmCell>();
        this.c = new ArrayList<mmCell>();
        this.d = new InOutEasing();
        this.q = false;
        Validator.validateParamsNotNull(new Validator$ValidatorPair(abstractPresentationEditor, A[4]), new Validator$ValidatorPair(presentation, A[1]), new Validator$ValidatorPair(slideGroup, A[5]), new Validator$ValidatorPair(slideGroup2, A[3]), new Validator$ValidatorPair(rectangle, A[6]), new Validator$ValidatorPair(animationProgressData, A[2]));
        this.e = abstractPresentationEditor;
        this.f = presentation;
        this.h = slideGroup;
        this.i = slideGroup2;
        this.g = n2;
        this.p = animationProgressData;
        this.j = this.p.getCenter();
        this.k = this.p.getZoom();
        this.l = this.p.getRotation();
        switch (animationType) {
            case RECAP: {
                zoomData = ZoomUtils.getZoomForCells(this.f, this.getPresentationEditor().getPainter(), rectangle, this.getPresentation().getVisibleCells(this.i, this.getPresentationEditor().getPainter(), CellVisibiltyMode.CURRENT_AND_PREVIOUS));
                this.o = 0.0;
                list = this.f.getVisibleCells(this.i, this.getPresentationEditor().getPainter(), this.a());
                if (!bl) break;
                UnknownPropertyStore.c = !UnknownPropertyStore.c;
            }
            case ZOOM_TO_VISIBLE: {
                list = this.f.getVisibleCells(this.i, this.getPresentationEditor().getPainter());
                zoomData = ZoomUtils.getZoomForCells(this.f, this.getPresentationEditor().getPainter(), rectangle, list);
                this.o = 0.0;
                if (!bl) break;
            }
            default: {
                zoomData = ZoomUtils.getZoomForSlideGroup(this.f, this.getPresentationEditor().getPainter(), rectangle, this.i);
                this.o = this.i.getTwoDSettings().getRotation();
                list = this.f.getVisibleCells(this.i, this.getPresentationEditor().getPainter(), this.f.getSettings().getCellVisibilityMode());
            }
        }
        this.m = zoomData.getCenter();
        this.n = zoomData.getZoomLevel();
        List<mmCell> list2 = this.getPresentationEditor().getGraphPainter().getVisibleCells();
        this.b.addAll(CellUtils.getIncomingCells(list2, list));
        this.c.addAll(CellUtils.getOutgoingCells(list2, list));
    }

    private CellVisibiltyMode a() {
        CellVisibiltyMode cellVisibiltyMode = this.f.getSettings().getCellVisibilityMode();
        if (CellVisibiltyMode.CURRENT_ONLY.equals((Object)cellVisibiltyMode)) {
            cellVisibiltyMode = CellVisibiltyMode.CURRENT_AND_PREVIOUS;
        }
        return cellVisibiltyMode;
    }

    protected static AnimationProgressData getDefaultStartProgressData(AbstractPresentationEditor abstractPresentationEditor) {
        return new AnimationProgressData(abstractPresentationEditor.getCurrentViewLocation(), abstractPresentationEditor.getZoomLevel(), abstractPresentationEditor.getRotation());
    }

    protected static Rectangle getDefaultViewRect(AbstractPresentationEditor abstractPresentationEditor) {
        return abstractPresentationEditor.getVisibleRect();
    }

    public abstract void updateProgress(double var1);

    public final void startAnimation() {
        this.r = -1L;
        super.startAnimation();
    }

    public final void updateAnimation() {
        double d2;
        long l2 = System.currentTimeMillis();
        if (this.r < 0L) {
            this.r = l2 + (long)this.getDuration();
        }
        if ((d2 = 1.0 - (double)(this.r - l2) / (double)this.getDuration()) >= 1.0) {
            this.stopAnimation();
            return;
        }
        this.doUpdateAnimation(d2);
        this.repaintCurrentPreviews();
        super.updateAnimation();
    }

    public final void doUpdateAnimation(double d2) {
        boolean bl = s;
        if (d2 < 0.0) {
            return;
        }
        if (d2 >= 1.0) {
            this.doStopAnimation();
            return;
        }
        if (!this.q) {
            for (mmCell mmCell2 : this.getCellChangeIn()) {
                this.getPresentationEditor().setVisible(mmCell2, true);
                if (!bl) continue;
            }
            this.q = true;
        }
        this.updateProgress(d2);
        this.b();
        if (!this.getCellChangeIn().isEmpty() || !this.getCellChangeOut().isEmpty()) {
            float f2 = this.getEasing().map((float)d2);
            float f3 = Math.min(1.0f, f2);
            float f4 = Math.max(0.0f, 1.0f - f3);
            this.getPresentationEditor().setTranslucency(this.getCellChangeIn(), f3);
            this.getPresentationEditor().setTranslucency(this.getCellChangeOut(), f4);
        }
    }

    private void b() {
        this.getPresentationEditor().setZoomLevel(this.getProgressData().getZoom());
        this.getPresentationEditor().revalidate();
        this.getPresentationEditor().scrollPointToCentre(this.getProgressData().getCenter());
        this.getPresentationEditor().setRotation(this.getProgressData().getRotation(), this.getProgressData().getCenter());
    }

    public final void stopAnimation() {
        if (this.timer == null) {
            return;
        }
        super.stopAnimation();
        this.doStopAnimation();
        this.getPresentationEditor().revalidate();
        this.repaintCurrentPreviews();
    }

    public final void doStopAnimation() {
        boolean bl = s;
        this.getPresentationEditor().clearTransluency();
        for (mmCell mmCell2 : this.getCellChangeIn()) {
            this.getPresentationEditor().setVisible(mmCell2, true);
            if (!bl) continue;
        }
        for (mmCell mmCell2 : this.getCellChangeOut()) {
            this.getPresentationEditor().setVisible(mmCell2, false);
            if (!bl) continue;
        }
        this.getProgressData().setCenter(this.getEndPoint());
        this.getProgressData().setZoom(this.getEndScale());
        this.getProgressData().setRotation(this.getEndRotation());
        this.b();
        this.getPresentationEditor().setOverlayImage(null);
    }

    public final void forceStop() {
        boolean bl = s;
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.timer = null;
        try {
            this.getPresentationEditor().clearTransluency();
            for (mmCell mmCell2 : this.getCellChangeIn()) {
                this.getPresentationEditor().setVisible(mmCell2, true);
                if (!bl) continue;
            }
            for (mmCell mmCell2 : this.getCellChangeOut()) {
                this.getPresentationEditor().setVisible(mmCell2, false);
                if (!bl) continue;
            }
            this.getPresentationEditor().setOverlayImage(null);
            this.repaintCurrentPreviews();
        }
        catch (Exception exception) {
            a.warn((Object)A[0], (Throwable)exception);
        }
    }

    public final AbstractPresentationEditor getPresentationEditor() {
        return this.e;
    }

    public final Presentation getPresentation() {
        return this.f;
    }

    public final void repaintCurrentPreviews() {
        Animation.c().repaintCurrentPreviews();
    }

    private static PresentationController c() {
        return PresentationViewController.getInstance().getPresentationController();
    }

    public final AnimationProgressData getProgressData() {
        return this.p;
    }

    public final int getDuration() {
        return this.g;
    }

    public final Point2D getStartPoint() {
        return this.j;
    }

    public final double getStartScale() {
        return this.k;
    }

    public final double getStartRotation() {
        return this.l;
    }

    public final Point2D getEndPoint() {
        return this.m;
    }

    public final double getEndScale() {
        return this.n;
    }

    public final double getEndRotation() {
        return this.o;
    }

    public final SlideGroup getStartSlideGroup() {
        return this.h;
    }

    public final SlideGroup getEndSlideGroup() {
        return this.i;
    }

    public final List<mmCell> getCellChangeIn() {
        return this.b;
    }

    public final List<mmCell> getCellChangeOut() {
        return this.c;
    }

    public final IEasing getEasing() {
        return this.d;
    }

    public final double getRotationForFraction(float f2, double d2, double d3) {
        float f3 = Math.max(f2, 0.0f);
        f3 = Math.min(f3, 1.0f);
        double d4 = d3 - d2;
        if (d4 > Math.PI) {
            while ((d4 -= Math.PI * 2) > Math.PI) {
            }
        } else if (d4 <= -Math.PI) {
            while ((d4 += Math.PI * 2) <= -Math.PI) {
            }
        }
        double d5 = d2 + d4 * (double)f3;
        return d5;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block76: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block75: {
                char[] cArray3;
                Object var0;
                block74: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block73: {
                        char[] cArray5;
                        block72: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block71: {
                                char[] cArray7;
                                block70: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block69: {
                                        char[] cArray9;
                                        block68: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block67: {
                                                char[] cArray11;
                                                block66: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block65: {
                                                        char[] cArray13;
                                                        block64: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block63: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray15 = "yQS~c\u001c@@dvTW\u0001w~N@H\u007fv\u001cBOx|]WH~\u007f\u001cWN1bHLQ0".toCharArray();
                                                                n4 = 0;
                                                                int n17 = cArray15.length;
                                                                cArray14 = cArray15;
                                                                n16 = n17;
                                                                if (n17 <= 1) break block63;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block64;
                                                            }
                                                            do {
                                                                char[] cArray16 = cArray14;
                                                                char[] cArray17 = cArray14;
                                                                int n18 = n4;
                                                                while (true) {
                                                                    int n19;
                                                                    char c2 = cArray16[n18];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n19 = 60;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n19 = 35;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n19 = 33;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n19 = 17;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n19 = 17;
                                                                        }
                                                                    }
                                                                    cArray16[n18] = (char)(c2 ^ n19);
                                                                    ++n4;
                                                                    cArray14 = cArray17;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray17 = cArray14;
                                                                    n15 = n16;
                                                                    n18 = n16;
                                                                    cArray16 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[0] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray18 = "LQDbtRW@exSM".toCharArray();
                                                        n4 = 0;
                                                        int n20 = cArray18.length;
                                                        cArray12 = cArray18;
                                                        n14 = n20;
                                                        if (n20 <= 1) break block65;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block66;
                                                    }
                                                    do {
                                                        char[] cArray19 = cArray12;
                                                        char[] cArray20 = cArray12;
                                                        int n21 = n4;
                                                        while (true) {
                                                            int n22;
                                                            char c3 = cArray19[n21];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n22 = 60;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n22 = 35;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n22 = 33;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n22 = 17;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n22 = 17;
                                                                }
                                                            }
                                                            cArray19[n21] = (char)(c3 ^ n22);
                                                            ++n4;
                                                            cArray12 = cArray20;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray20 = cArray12;
                                                            n13 = n14;
                                                            n21 = n14;
                                                            cArray19 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[1] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray21 = "OW@celQNvcYPRUpHB".toCharArray();
                                                n4 = 0;
                                                int n23 = cArray21.length;
                                                cArray10 = cArray21;
                                                n12 = n23;
                                                if (n23 <= 1) break block67;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block68;
                                            }
                                            do {
                                                char[] cArray22 = cArray10;
                                                char[] cArray23 = cArray10;
                                                int n24 = n4;
                                                while (true) {
                                                    int n25;
                                                    char c4 = cArray22[n24];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n25 = 60;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n25 = 35;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n25 = 33;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n25 = 17;
                                                            break;
                                                        }
                                                        default: {
                                                            n25 = 17;
                                                        }
                                                    }
                                                    cArray22[n24] = (char)(c4 ^ n25);
                                                    ++n4;
                                                    cArray10 = cArray23;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray23 = cArray10;
                                                    n11 = n12;
                                                    n24 = n12;
                                                    cArray22 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[2] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray24 = "YMEX\u007f".toCharArray();
                                        n4 = 0;
                                        int n26 = cArray24.length;
                                        cArray8 = cArray24;
                                        n10 = n26;
                                        if (n26 <= 1) break block69;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block70;
                                    }
                                    do {
                                        char[] cArray25 = cArray8;
                                        char[] cArray26 = cArray8;
                                        int n27 = n4;
                                        while (true) {
                                            int n28;
                                            char c5 = cArray25[n27];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n28 = 60;
                                                    break;
                                                }
                                                case 1: {
                                                    n28 = 35;
                                                    break;
                                                }
                                                case 2: {
                                                    n28 = 33;
                                                    break;
                                                }
                                                case 3: {
                                                    n28 = 17;
                                                    break;
                                                }
                                                default: {
                                                    n28 = 17;
                                                }
                                            }
                                            cArray25[n27] = (char)(c5 ^ n28);
                                            ++n4;
                                            cArray8 = cArray26;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray26 = cArray8;
                                            n9 = n10;
                                            n27 = n10;
                                            cArray25 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[3] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray27 = "YGHe~NjO".toCharArray();
                                n4 = 0;
                                int n29 = cArray27.length;
                                cArray6 = cArray27;
                                n8 = n29;
                                if (n29 <= 1) break block71;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block72;
                            }
                            do {
                                char[] cArray28 = cArray6;
                                char[] cArray29 = cArray6;
                                int n30 = n4;
                                while (true) {
                                    int n31;
                                    char c6 = cArray28[n30];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n31 = 60;
                                            break;
                                        }
                                        case 1: {
                                            n31 = 35;
                                            break;
                                        }
                                        case 2: {
                                            n31 = 33;
                                            break;
                                        }
                                        case 3: {
                                            n31 = 17;
                                            break;
                                        }
                                        default: {
                                            n31 = 17;
                                        }
                                    }
                                    cArray28[n30] = (char)(c6 ^ n31);
                                    ++n4;
                                    cArray6 = cArray29;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray29 = cArray6;
                                    n7 = n8;
                                    n30 = n8;
                                    cArray28 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[4] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray30 = "OW@ceuM".toCharArray();
                        n4 = 0;
                        int n32 = cArray30.length;
                        cArray4 = cArray30;
                        n6 = n32;
                        if (n32 <= 1) break block73;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block74;
                    }
                    do {
                        char[] cArray31 = cArray4;
                        char[] cArray32 = cArray4;
                        int n33 = n4;
                        while (true) {
                            int n34;
                            char c7 = cArray31[n33];
                            switch (n4 % 5) {
                                case 0: {
                                    n34 = 60;
                                    break;
                                }
                                case 1: {
                                    n34 = 35;
                                    break;
                                }
                                case 2: {
                                    n34 = 33;
                                    break;
                                }
                                case 3: {
                                    n34 = 17;
                                    break;
                                }
                                default: {
                                    n34 = 17;
                                }
                            }
                            cArray31[n33] = (char)(c7 ^ n34);
                            ++n4;
                            cArray4 = cArray32;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray32 = cArray4;
                            n5 = n6;
                            n33 = n6;
                            cArray31 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[5] = new String(cArray3).intern();
                var0 = null;
                char[] cArray33 = "JJDfCY@U".toCharArray();
                n4 = 0;
                int n35 = cArray33.length;
                cArray2 = cArray33;
                n3 = n35;
                if (n35 <= 1) break block75;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block76;
            }
            do {
                char[] cArray34 = cArray2;
                char[] cArray35 = cArray2;
                int n36 = n4;
                while (true) {
                    int n37;
                    char c8 = cArray34[n36];
                    switch (n4 % 5) {
                        case 0: {
                            n37 = 60;
                            break;
                        }
                        case 1: {
                            n37 = 35;
                            break;
                        }
                        case 2: {
                            n37 = 33;
                            break;
                        }
                        case 3: {
                            n37 = 17;
                            break;
                        }
                        default: {
                            n37 = 17;
                        }
                    }
                    cArray34[n36] = (char)(c8 ^ n37);
                    ++n4;
                    cArray2 = cArray35;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray35 = cArray2;
                    n2 = n3;
                    n36 = n3;
                    cArray34 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[6] = new String(cArray).intern();
        A = stringArray;
        a = Logger.getLogger(Animation.class);
    }
}

