/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.presentation.editor;

import com.mxgraph.mindmap.model.mmBoundaryCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.swing.mmGraphComponent;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.mxgraph.mindmap.util.mmUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.phoenix.presentation.builder.controller.PresentationBuilderController;
import com.thinkbuzan.phoenix.presentation.editor.AbstractGraphPainter;
import com.thinkbuzan.phoenix.presentation.editor.e;
import com.thinkbuzan.phoenix.presentation.handler.AbstractEditorHandler;
import com.thinkbuzan.phoenix.presentation.maps.AbstractPresentationMindMap;
import com.thinkbuzan.phoenix.presentation.model.Presentation;
import com.thinkbuzan.phoenix.presentation.model.SlideGroup;
import com.thinkbuzan.phoenix.presentation.model.UnknownPropertyStore;
import com.thinkbuzan.phoenix.presentation.model.ZoomData;
import com.thinkbuzan.phoenix.presentation.utils.CellUtils;
import com.thinkbuzan.phoenix.presentation.utils.Validator;
import com.thinkbuzan.phoenix.presentation.utils.Validator$ValidatorPair;
import com.thinkbuzan.phoenix.presentation.utils.ZoomUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditor
extends JPanel {
    private static final long serialVersionUID = 3372148149536810383L;
    private final transient Object a = new Object();
    private final transient e b = new e(this);
    private final transient Point2D.Double c = new Point2D.Double(0.0, 0.0);
    private final transient PresentationBuilderController d;
    private transient double e;
    private transient double f;
    private final transient JScrollPane g;
    private final transient AbstractEditorHandler h;
    private transient AbstractGraphPainter i;
    private transient AbstractPresentationMindMap j;
    private transient mmGraphComponent k;
    public static int l;
    private static final String[] z;

    public AbstractEditor(PresentationBuilderController presentationBuilderController) {
        Validator.validateNotNull(new Validator$ValidatorPair(presentationBuilderController, z[1]));
        this.d = presentationBuilderController;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setFocusable(true);
        this.g = this.createScrollPane();
        this.g.getViewport().setView(this.b);
        this.add((Component)this.g, z[0]);
        this.h = this.createEditorHandler();
        if (this.h != null) {
            this.h.install(this.b);
        }
        this.setMap(this.d.getStartingEditorMap());
    }

    private void a(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.i != null) {
            this.i.paint(graphics2D, null);
        }
    }

    public final PresentationBuilderController getBuilderController() {
        return this.d;
    }

    public final JPanel getGraphView() {
        return this.b;
    }

    public abstract JScrollPane createScrollPane();

    public abstract AbstractGraphPainter createPainter(AbstractPresentationMindMap var1);

    public abstract AbstractEditorHandler createEditorHandler();

    public abstract void paintOverlay(Graphics var1);

    public abstract void updateZoom(Presentation var1, SlideGroup var2);

    public abstract double getMaxZoom();

    public abstract double getMinZoom();

    public abstract Presentation getCurrentPresentation();

    public abstract boolean paintBackgroundImageAndLogo();

    public final Object getLock() {
        return this.a;
    }

    public final IEditorComponent getEditorComponent() {
        return this.j.getClonedEditorComponent();
    }

    public final Color getGraphBackground() {
        return this.b.getBackground();
    }

    public final AbstractGraphPainter getPainter() {
        return this.i;
    }

    public final AbstractEditorHandler getHandler() {
        return this.h;
    }

    public final Point2D.Double getOffset() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMap(AbstractPresentationMindMap abstractPresentationMindMap) {
        if (abstractPresentationMindMap == null) {
            return;
        }
        Object object = this.a;
        synchronized (object) {
            this.j = abstractPresentationMindMap;
            this.i = this.createPainter(abstractPresentationMindMap);
            this.b.setBackground(abstractPresentationMindMap.getClonedEditorComponent().getBackgroundColor());
            this.k = abstractPresentationMindMap.getClonedEditorComponent().getGraphComponent();
            Dimension dimension = this.k.getPreferredSize();
            double d2 = this.k.getGraph().getView().getScale();
            this.c.x = dimension.getWidth() * 0.25;
            this.c.y = dimension.getHeight() * 0.25;
            this.e = (dimension.getWidth() + 2.0 * this.c.x) / d2;
            this.f = (dimension.getHeight() + 2.0 * this.c.y) / d2;
            this.a();
        }
    }

    public mmGraphComponent getGraphComponent() {
        return this.k;
    }

    private void a() {
        int n2 = (int)(this.e * this.i.getScale());
        int n3 = (int)(this.f * this.i.getScale());
        Rectangle rectangle = this.g.getViewport().getViewRect();
        n2 = Math.max(rectangle.width, n2);
        n3 = Math.max(rectangle.height, n3);
        this.b.setPreferredSize(new Dimension(n2, n3));
        this.g.revalidate();
    }

    public final void scrollToFirstCI() {
        if (this.j != null) {
            Rectangle rectangle;
            IEditorComponent iEditorComponent = this.j.getClonedEditorComponent();
            mmCell mmCell2 = null;
            if (iEditorComponent.getFloatingIdeas() != null && !iEditorComponent.getFloatingIdeas().isEmpty()) {
                mmCell2 = (mmCell)iEditorComponent.getFloatingIdeas().get(0);
            } else if (iEditorComponent.getFloatingImages() != null && !iEditorComponent.getFloatingImages().isEmpty()) {
                mmCell2 = (mmCell)iEditorComponent.getFloatingImages().get(0);
            } else if (iEditorComponent.getFloatingTexts() != null && !iEditorComponent.getFloatingTexts().isEmpty()) {
                mmCell2 = (mmCell)iEditorComponent.getFloatingTexts().get(0);
            } else if (iEditorComponent.getFlowchartCells() != null && !iEditorComponent.getFlowchartCells().isEmpty()) {
                mmCell2 = (mmCell)iEditorComponent.getFlowchartCells().get(0);
            }
            if (mmCell2 != null && (rectangle = ZoomUtils.getBounds(this.getPainter(), mmCell2)) != null) {
                this.scrollPointToCentre(new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY()));
            }
        }
    }

    public final void zoomIn() {
        this.a(this.getZoomLevel() + 0.15);
    }

    public final void zoomOut() {
        this.a(this.getZoomLevel() - 0.15);
    }

    public final void zoomTo(double d2) {
        this.a(d2);
    }

    private void a(double d2) {
        double d3 = d2;
        d3 = Math.max(d3, this.getMinZoom());
        d3 = Math.min(d3, this.getMaxZoom());
        double d4 = this.i.getScale();
        Rectangle rectangle = this.g.getViewport().getViewRect();
        double d5 = rectangle.getCenterX();
        double d6 = rectangle.getCenterY();
        int n2 = (int)(d5 * (d3 / d4) - (double)(rectangle.width / 2));
        int n3 = (int)(d6 * (d3 / d4) - (double)(rectangle.height / 2));
        n2 = Math.max(n2, 0);
        n3 = Math.max(n3, 0);
        Point point = new Point(n2, n3);
        this.i.setScale(d3);
        this.a();
        this.g.getViewport().setViewPosition(point);
        this.b.repaint();
    }

    public final double getZoomLevel() {
        return this.i.getScale();
    }

    public final void zoomToFit(ZoomData zoomData) {
        if (zoomData == null) {
            return;
        }
        this.setZoomLevel(zoomData.getZoomLevel());
        this.g.getViewport().revalidate();
        this.scrollPointToCentre(zoomData.getCenter());
    }

    public final void scrollPointToCentre(Point2D point2D) {
        int n2 = l;
        Dimension dimension = this.g.getViewport().getExtentSize();
        double d2 = dimension.getWidth() / 2.0;
        double d3 = dimension.getHeight() / 2.0;
        double d4 = this.i.getScale();
        double d5 = point2D.getX() * d4 - d2;
        double d6 = point2D.getY() * d4 - d3;
        d5 = Math.min(d5, (double)(this.b.getPreferredSize().width - dimension.width));
        d6 = Math.min(d6, (double)(this.b.getPreferredSize().height - dimension.height));
        d5 = Math.max(d5, 0.0);
        d6 = Math.max(d6, 0.0);
        this.g.getViewport().getView().setLocation(new Point((int)(-d5), (int)(-d6)));
        if (UnknownPropertyStore.c) {
            l = ++n2;
        }
    }

    public final List<mmCell> getChildCells(mmCell mmCell2) {
        return CellUtils.getChildCells(mmCell2, true);
    }

    public final Object[] getBranchesForCloud(mmBoundaryCell mmBoundaryCell2) {
        int n2 = l;
        int n3 = mmBoundaryCell2.getEdgeCount();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i2 = 0; i2 < n3; ++i2) {
            mxICell mxICell2 = mmBoundaryCell2.getEdgeAt(i2);
            mxICell mxICell3 = mxICell2.getTerminal(true);
            hashSet.add(mxICell3);
            if (!(mxICell3 instanceof mmBranchCell)) continue;
            for (Object e2 : mmUtils.getSubtree((Object)((mmBranchCell)mxICell3).getTarget())) {
                if (e2 instanceof mmBranchCell && !hashSet.contains(e2) && ((mmBranchCell)e2).getTarget() != null) {
                    hashSet.add(e2);
                }
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return hashSet.toArray();
    }

    public static String getLabel(Object object) {
        String string = null;
        if (object instanceof mmCell) {
            string = PropertyUtilities.getText((mmICell)((mmICell)object));
        }
        if (string == null) {
            return object.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearTransluency() {
        Object object = this.a;
        synchronized (object) {
            this.i.clearTransluency();
        }
    }

    public final void setTranslucency(List<mmCell> list, float f2) {
        int n2 = l;
        for (mmCell mmCell2 : list) {
            this.setTranslucency(mmCell2, f2);
            if (n2 == 0) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTranslucency(mmCell mmCell2, float f2) {
        Object object = this.a;
        synchronized (object) {
            if (this.i.getState(mmCell2) == null) {
                return;
            }
            this.i.setTranslucency((mxCell)mmCell2, f2);
        }
    }

    public final JScrollPane getScrollPane() {
        return this.g;
    }

    public final Point2D getCurrentViewLocation() {
        Rectangle rectangle = this.g.getViewport().getViewRect();
        return new Point2D.Double(rectangle.getCenterX() / this.i.getScale(), rectangle.getCenterY() / this.i.getScale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setZoomLevel(double d2) {
        Object object = this.a;
        synchronized (object) {
            this.i.setScale(d2);
            int n2 = (int)(this.e * this.i.getScale());
            int n3 = (int)(this.f * this.i.getScale());
            Rectangle rectangle = this.g.getViewport().getViewRect();
            n2 = Math.max(rectangle.width, n2);
            n3 = Math.max(rectangle.height, n3);
            this.b.setPreferredSize(new Dimension(n2, n3));
        }
    }

    public void release() {
        if (this.i != null) {
            this.i.release();
            this.i = null;
        }
        this.j = null;
        if (this.k != null) {
            this.k = null;
        }
    }

    static void a(AbstractEditor abstractEditor, Graphics graphics) {
        abstractEditor.a(graphics);
    }

    static JScrollPane a(AbstractEditor abstractEditor) {
        return abstractEditor.g;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "w\u000f\u0017ytF".toCharArray();
                        n4 = 0;
                        int n7 = cArray5.length;
                        cArray4 = cArray5;
                        n6 = n7;
                        if (n7 <= 1) break block18;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n8 = n4;
                        while (true) {
                            int n9;
                            char c2 = cArray6[n8];
                            switch (n4 % 5) {
                                case 0: {
                                    n9 = 52;
                                    break;
                                }
                                case 1: {
                                    n9 = 106;
                                    break;
                                }
                                case 2: {
                                    n9 = 121;
                                    break;
                                }
                                case 3: {
                                    n9 = 13;
                                    break;
                                }
                                default: {
                                    n9 = 17;
                                }
                            }
                            cArray6[n8] = (char)(c2 ^ n9);
                            ++n4;
                            cArray4 = cArray7;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray7 = cArray4;
                            n5 = n6;
                            n8 = n6;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "V\u001f\u0010auQ\u0018:b\u007f@\u0018\u0016a}Q\u00180c".toCharArray();
                n4 = 0;
                int n10 = cArray8.length;
                cArray2 = cArray8;
                n3 = n10;
                if (n10 <= 1) break block20;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n11 = n4;
                while (true) {
                    int n12;
                    char c3 = cArray9[n11];
                    switch (n4 % 5) {
                        case 0: {
                            n12 = 52;
                            break;
                        }
                        case 1: {
                            n12 = 106;
                            break;
                        }
                        case 2: {
                            n12 = 121;
                            break;
                        }
                        case 3: {
                            n12 = 13;
                            break;
                        }
                        default: {
                            n12 = 17;
                        }
                    }
                    cArray9[n11] = (char)(c3 ^ n12);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n11 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
    }
}

