/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.presentation.model;

import com.thinkbuzan.phoenix.presentation.audio.model.AudioMode;
import com.thinkbuzan.phoenix.presentation.model.AnimationSpeed;
import com.thinkbuzan.phoenix.presentation.model.BackgroundImage;
import com.thinkbuzan.phoenix.presentation.model.CellVisibiltyMode;
import com.thinkbuzan.phoenix.presentation.model.Logo;
import com.thinkbuzan.phoenix.presentation.model.LogoPosition;
import com.thinkbuzan.phoenix.presentation.model.Transition;
import com.thinkbuzan.phoenix.presentation.model.TraversalType;
import com.thinkbuzan.phoenix.presentation.model.ViewMode;
import com.thinkbuzan.phoenix.presentation.utils.ZoomUtils;
import java.util.UUID;

public final class PresentationTemplateData {
    private transient boolean a = false;
    private transient TraversalType b = TraversalType.BRANCH_BY_BRANCH;
    private transient AnimationSpeed c = AnimationSpeed.SLOW;
    private transient ViewMode d = ViewMode.TWO_D;
    private transient Transition e = Transition.BOUNCE_OUT;
    private transient CellVisibiltyMode f = CellVisibiltyMode.CURRENT_AND_PREVIOUS;
    private transient int g = 15;
    private transient UUID h = null;
    private transient AudioMode i = AudioMode.NONE;
    private transient double j = 1.0;
    private transient Logo k;
    private transient LogoPosition l = LogoPosition.BOTTOM_RIGHT;
    private transient BackgroundImage m;

    public PresentationTemplateData() {
    }

    public PresentationTemplateData(PresentationTemplateData presentationTemplateData) {
        if (presentationTemplateData != null) {
            this.c = presentationTemplateData.getAnimationSpeed();
            this.i = presentationTemplateData.getAudioMode();
            this.a = presentationTemplateData.isAutoOpenLinks();
            this.g = presentationTemplateData.getAutoPlayDelay();
            this.h = presentationTemplateData.getSkyBoxID();
            this.e = presentationTemplateData.getTransition();
            this.b = presentationTemplateData.getTraversalType();
            this.d = presentationTemplateData.getViewMode();
            this.f = presentationTemplateData.getCellVisibilityMode();
            this.j = presentationTemplateData.getDefaultZoom();
            this.k = presentationTemplateData.getLogo();
            this.l = presentationTemplateData.getLogoPosition();
            this.m = presentationTemplateData.getBackgroundImage();
        }
    }

    public boolean isAutoOpenLinks() {
        return this.a;
    }

    public TraversalType getTraversalType() {
        return this.b;
    }

    public AnimationSpeed getAnimationSpeed() {
        return this.c;
    }

    public ViewMode getViewMode() {
        return this.d;
    }

    public Transition getTransition() {
        return this.e;
    }

    public void setAutoOpenLinks(boolean bl) {
        this.a = bl;
    }

    public void setTraversalType(TraversalType traversalType) {
        this.b = traversalType;
    }

    public void setAnimationSpeed(AnimationSpeed animationSpeed) {
        this.c = animationSpeed;
    }

    public void setViewMode(ViewMode viewMode) {
        this.d = viewMode;
    }

    public void setTransition(Transition transition) {
        this.e = transition;
    }

    public void setCellVisibilityMode(CellVisibiltyMode cellVisibiltyMode) {
        this.f = cellVisibiltyMode;
    }

    public CellVisibiltyMode getCellVisibilityMode() {
        return this.f;
    }

    public void setAutoPlayDelay(int n2) {
        this.g = this.a(n2);
    }

    private int a(int n2) {
        int n3 = Math.max(0, n2);
        return Math.min(n3, 600);
    }

    public int getAutoPlayDelay() {
        return this.g;
    }

    public void setSkyBoxID(UUID uUID) {
        this.h = uUID;
    }

    public UUID getSkyBoxID() {
        return this.h;
    }

    public void setAudioMode(AudioMode audioMode) {
        this.i = audioMode;
    }

    public AudioMode getAudioMode() {
        return this.i;
    }

    public double getDefaultZoom() {
        return this.j;
    }

    public void setDefaultZoom(double d2) {
        this.j = ZoomUtils.clampScale(d2);
    }

    public Logo getLogo() {
        return this.k;
    }

    public void setLogo(Logo logo) {
        this.k = logo;
    }

    public LogoPosition getLogoPosition() {
        return this.l;
    }

    public void setLogoPosition(LogoPosition logoPosition) {
        this.l = logoPosition;
    }

    public BackgroundImage getBackgroundImage() {
        return this.m;
    }

    public void setBackgroundImage(BackgroundImage backgroundImage) {
        this.m = backgroundImage;
    }
}

