/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.presentation.utils;

import com.mxgraph.mindmap.model.mmBoundaryCell;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmImageCell;
import com.mxgraph.mindmap.model.mmRelationshipCell;
import com.mxgraph.model.mxCell;
import com.thinkbuzan.phoenix.presentation.editor.AbstractGraphPainter;
import com.thinkbuzan.phoenix.presentation.model.Presentation;
import com.thinkbuzan.phoenix.presentation.model.SlideGroup;
import com.thinkbuzan.phoenix.presentation.model.TwoDSettings;
import com.thinkbuzan.phoenix.presentation.model.ZoomData;
import com.thinkbuzan.phoenix.presentation.utils.Validator$ValidatorPair;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZoomUtils {
    public static final double MAX_SLIDE_ZOOM = 20.0;
    public static final double MIN_SLIDE_ZOOM = 0.05;
    public static final double SCALE_FACTOR = 0.2;
    public static final Rectangle DEFAULT_VIEW_RECT = new Rectangle(0, 0, 1920, 1080);

    private ZoomUtils() {
    }

    public static ZoomData getZoomForSlideGroup(Presentation presentation, AbstractGraphPainter abstractGraphPainter, Rectangle rectangle, SlideGroup slideGroup) {
        return ZoomUtils.getZoomForSlideGroup(presentation, abstractGraphPainter, rectangle, slideGroup, true);
    }

    public static ZoomData getZoomForSlideGroup(Presentation presentation, AbstractGraphPainter abstractGraphPainter, Rectangle rectangle, SlideGroup slideGroup, boolean bl) {
        ZoomData zoomData = ZoomUtils.getZoomForCells(presentation, abstractGraphPainter, rectangle, slideGroup.getMMCells(), bl);
        ZoomData zoomData2 = null;
        if (zoomData != null) {
            double d2 = zoomData.getZoomLevel() * slideGroup.getTwoDSettings().getZoomAdjustmentFactor();
            d2 = ZoomUtils.clampScale(d2);
            double d3 = zoomData.getDefaultBounds().getX() + zoomData.getDefaultBounds().getWidth() * slideGroup.getTwoDSettings().getXPosition();
            double d4 = zoomData.getDefaultBounds().getY() + zoomData.getDefaultBounds().getHeight() * slideGroup.getTwoDSettings().getYPosition();
            zoomData2 = new ZoomData(d2, new Point2D.Double(d3, d4), zoomData.getDefaultBounds());
        }
        return zoomData2;
    }

    public static ZoomData getZoomForCells(Presentation presentation, AbstractGraphPainter abstractGraphPainter, Rectangle rectangle, List<mmCell> list) {
        return ZoomUtils.getZoomForCells(presentation, abstractGraphPainter, rectangle, list, true);
    }

    public static ZoomData getZoomForCells(Presentation presentation, AbstractGraphPainter abstractGraphPainter, Rectangle rectangle, List<mmCell> list, boolean bl) {
        if (rectangle.getWidth() < 2.0 || rectangle.getHeight() < 2.0 || list == null || list.isEmpty()) {
            return null;
        }
        Rectangle2D rectangle2D = ZoomUtils.a(abstractGraphPainter, list, bl);
        if (rectangle2D == null) {
            return null;
        }
        double d2 = (double)rectangle.width / rectangle2D.getWidth();
        double d3 = (double)rectangle.height / rectangle2D.getHeight();
        double d4 = d2;
        if (d3 < d2) {
            d4 = d3;
        }
        d4 *= presentation.getSettings().getDefaultZoom().doubleValue();
        d4 = ZoomUtils.a(d4);
        return new ZoomData(d4, new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()), rectangle2D);
    }

    private static double a(double d2) {
        return d2 * 0.8;
    }

    public static double clampScale(double d2) {
        double d3 = Math.min(d2, 20.0);
        d3 = Math.max(d3, 0.05);
        return d3;
    }

    public static Rectangle2D getBoundsForGroup(Presentation presentation, AbstractGraphPainter abstractGraphPainter, SlideGroup slideGroup, Double d2) {
        return ZoomUtils.getBoundsForGroup(presentation, abstractGraphPainter, slideGroup, d2, true);
    }

    public static Rectangle2D getBoundsForGroup(Presentation presentation, AbstractGraphPainter abstractGraphPainter, SlideGroup slideGroup, Double d2, boolean bl) {
        Rectangle2D rectangle2D;
        block2: {
            double d3;
            double d4;
            double d5;
            double d6;
            block4: {
                double d7;
                block3: {
                    rectangle2D = ZoomUtils.a(presentation, ZoomUtils.a(abstractGraphPainter, slideGroup.getMMCells(), bl), slideGroup.getTwoDSettings());
                    if (d2 == null || !(d2 > 0.0) || rectangle2D == null || !(rectangle2D.getWidth() > 0.0) || !(rectangle2D.getHeight() > 0.0)) break block2;
                    d6 = rectangle2D.getX();
                    d5 = rectangle2D.getY();
                    d4 = rectangle2D.getWidth();
                    if (!(d4 / (d3 = rectangle2D.getHeight()) > d2)) break block3;
                    d3 = d4 / d2;
                    d7 = d3 - rectangle2D.getHeight();
                    d5 -= d7 / 2.0;
                    if (!Validator$ValidatorPair.c) break block4;
                }
                d4 = d3 * d2;
                d7 = d4 - rectangle2D.getWidth();
                d6 -= d7 / 2.0;
            }
            rectangle2D = new Rectangle2D.Double(d6, d5, d4, d3);
        }
        return rectangle2D;
    }

    private static Rectangle2D a(Presentation presentation, Rectangle2D rectangle2D, TwoDSettings twoDSettings) {
        if (rectangle2D == null || twoDSettings == null) {
            return rectangle2D;
        }
        double d2 = rectangle2D.getX() + rectangle2D.getWidth() * twoDSettings.getXPosition();
        double d3 = rectangle2D.getY() + rectangle2D.getHeight() * twoDSettings.getYPosition();
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        double d4 = ZoomUtils.a(presentation.getSettings().getDefaultZoom()) * twoDSettings.getZoomAdjustmentFactor();
        d4 = ZoomUtils.clampScale(d4);
        double d5 = rectangle2D.getWidth() / d4;
        double d6 = rectangle2D.getHeight() / d4;
        double d7 = ((Point2D)double_).getX() - d5 / 2.0;
        double d8 = ((Point2D)double_).getY() - d6 / 2.0;
        return new Rectangle2D.Double(d7, d8, d5, d6);
    }

    private static Rectangle2D a(AbstractGraphPainter abstractGraphPainter, List<mmCell> list, boolean bl) {
        Rectangle rectangle;
        block4: {
            boolean bl2;
            block3: {
                bl2 = Validator$ValidatorPair.c;
                if (abstractGraphPainter != null && list != null && !list.isEmpty()) break block3;
                rectangle = null;
                if (!bl2) break block4;
            }
            rectangle = ZoomUtils.getBounds(abstractGraphPainter, list.get(0), bl);
            for (mmCell mmCell2 : list) {
                block5: {
                    Rectangle rectangle2;
                    block6: {
                        rectangle2 = ZoomUtils.getBounds(abstractGraphPainter, mmCell2, bl);
                        if (rectangle2 == null) break block5;
                        if (rectangle != null) break block6;
                        rectangle = rectangle2;
                        if (!bl2) break block5;
                    }
                    rectangle.add((Rectangle2D)rectangle2);
                }
                if (!bl2) continue;
            }
        }
        return rectangle;
    }

    public static Rectangle getBounds(AbstractGraphPainter abstractGraphPainter, mmCell mmCell2) {
        return ZoomUtils.getBounds(abstractGraphPainter, mmCell2, true);
    }

    public static Rectangle getBounds(AbstractGraphPainter abstractGraphPainter, mmCell mmCell2, boolean bl) {
        boolean bl2 = Validator$ValidatorPair.c;
        Rectangle rectangle = abstractGraphPainter.getExtendedCellBounds((mxCell)mmCell2, bl);
        List<mmCell> list = ZoomUtils.a(mmCell2);
        for (mmCell mmCell3 : list) {
            if (mmCell3 instanceof mmBoundaryCell && !bl2 || mmCell3 instanceof mmRelationshipCell && !bl2) continue;
            Rectangle rectangle2 = abstractGraphPainter.getExtendedCellBounds((mxCell)mmCell3, bl);
            if (rectangle2 != null) {
                rectangle.add(rectangle2);
            }
            if (!bl2) continue;
        }
        return rectangle;
    }

    private static List<mmCell> a(mmCell mmCell2) {
        boolean bl = Validator$ValidatorPair.c;
        LinkedList<mmCell> linkedList = new LinkedList<mmCell>();
        if (mmCell2 instanceof mmBranchCell) {
            Object object;
            ArrayList<mmImageCell> arrayList;
            Object object22;
            mmBranchCell mmBranchCell2 = (mmBranchCell)mmCell2;
            mmBranchBoxCell mmBranchBoxCell2 = mmBranchCell2.getBoxBranch();
            if (mmBranchBoxCell2 != null) {
                linkedList.add((mmCell)mmBranchBoxCell2);
            }
            List list = mmBranchCell2.getImages();
            for (Object object22 : list) {
                linkedList.add((mmCell)object22);
                if (!bl) continue;
            }
            if (mmBranchBoxCell2 != null) {
                arrayList = new ArrayList<mmImageCell>();
                for (int i2 = 0; i2 < mmBranchBoxCell2.getChildCount(); ++i2) {
                    object = mmBranchBoxCell2.getChildAt(i2);
                    if (!(object instanceof mmImageCell)) continue;
                    arrayList.add((mmImageCell)object);
                    if (!bl) continue;
                }
                linkedList.addAll(arrayList);
            }
            arrayList = mmBranchCell2.getRelationships();
            object22 = arrayList.iterator();
            while (object22.hasNext()) {
                object = (mmRelationshipCell)object22.next();
                linkedList.add((mmCell)object);
                if (!bl) continue;
            }
            if ((object22 = mmBranchCell2.getBoundaries()) != null) {
                object = object22.iterator();
                while (object.hasNext()) {
                    mmBoundaryCell mmBoundaryCell2 = (mmBoundaryCell)object.next();
                    linkedList.add((mmCell)mmBoundaryCell2);
                    if (!bl) continue;
                }
            }
        }
        return linkedList;
    }

    public static Rectangle2D getBoundsForGroupCells(AbstractGraphPainter abstractGraphPainter, SlideGroup slideGroup) {
        return ZoomUtils.getBoundsForGroupCells(abstractGraphPainter, slideGroup, true);
    }

    public static Rectangle2D getBoundsForGroupCells(AbstractGraphPainter abstractGraphPainter, SlideGroup slideGroup, boolean bl) {
        return ZoomUtils.a(abstractGraphPainter, slideGroup.getMMCells(), bl);
    }
}

