/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.javafx.helper;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SynchronousJFXCaller<T> {
    private final Callable<T> callable;

    public SynchronousJFXCaller(Callable<T> callable) {
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T call(long l, TimeUnit timeUnit) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        jDialog.setUndecorated(true);
        jDialog.setOpacity(0.0f);
        jDialog.setDefaultCloseOperation(0);
        CountDownLatch countDownLatch2 = new CountDownLatch(1);
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> {
            CountDownLatch countDownLatch3 = countDownLatch;
            synchronized (countDownLatch3) {
                if (atomicBoolean.get()) {
                    return null;
                }
                countDownLatch.countDown();
            }
            try {
                countDownLatch3 = this.callable.call();
                return countDownLatch3;
            }
            finally {
                countDownLatch2.await();
                SwingUtilities.invokeLater(() -> jDialog.setVisible(false));
            }
        });
        Platform.runLater(futureTask);
        if (!countDownLatch.await(l, timeUnit)) {
            CountDownLatch countDownLatch3 = countDownLatch;
            synchronized (countDownLatch3) {
                if (!countDownLatch.await(0L, TimeUnit.MILLISECONDS)) {
                    atomicBoolean.set(true);
                    throw new IllegalStateException("JavaFX was shut down or is unresponsive");
                }
            }
        }
        SwingUtilities.invokeLater(() -> countDownLatch2.countDown());
        jDialog.setVisible(true);
        jDialog.dispose();
        try {
            return (T)futureTask.get();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError("Unexpected exception type", throwable);
        }
    }
}

