/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.javafx.helper;

import com.thinkbuzan.dozer.javafx.helper.IDirectoryFunction;
import com.thinkbuzan.dozer.javafx.helper.SynchronousJFXCaller;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javafx.stage.DirectoryChooser;

public class SynchronousJFXDirectoryChooser {
    private final Supplier<DirectoryChooser> directoryChooserFactory;

    public static SynchronousJFXDirectoryChooser getDirectoryChooser(String string) {
        SynchronousJFXDirectoryChooser synchronousJFXDirectoryChooser = new SynchronousJFXDirectoryChooser(() -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(string);
            return directoryChooser;
        });
        return synchronousJFXDirectoryChooser;
    }

    public SynchronousJFXDirectoryChooser(Supplier<DirectoryChooser> supplier) {
        this.directoryChooserFactory = supplier;
    }

    public Object showDialog(Object object) {
        if (object instanceof IDirectoryFunction) {
            return this.showDialog((IDirectoryFunction)object, 1L, TimeUnit.SECONDS);
        }
        return null;
    }

    public File showDialog(IDirectoryFunction iDirectoryFunction) {
        return this.showDialog(iDirectoryFunction, 1L, TimeUnit.SECONDS);
    }

    public File showDialog(IDirectoryFunction iDirectoryFunction, long l, TimeUnit timeUnit) {
        Callable<File> callable = () -> {
            DirectoryChooser directoryChooser = this.directoryChooserFactory.get();
            return iDirectoryFunction.apply(directoryChooser);
        };
        SynchronousJFXCaller<File> synchronousJFXCaller = new SynchronousJFXCaller<File>(callable);
        try {
            return synchronousJFXCaller.call(l, timeUnit);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception exception) {
            throw new AssertionError("Got unexpected checked exception from SynchronousJFXCaller.call()", exception);
        }
    }

    public File showOpenDialog() {
        return this.showDialog((DirectoryChooser directoryChooser) -> directoryChooser.showDialog(null));
    }
}

