/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.javafx.helper;

import com.thinkbuzan.dozer.javafx.helper.IFileFunction;
import com.thinkbuzan.dozer.javafx.helper.SynchronousJFXCaller;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javafx.stage.FileChooser;

public class SynchronousJFXFileChooser {
    private final Supplier<FileChooser> fileChooserFactory;

    public static SynchronousJFXFileChooser getFileChooser(String string) {
        SynchronousJFXFileChooser synchronousJFXFileChooser = new SynchronousJFXFileChooser(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(string);
            return fileChooser;
        });
        return synchronousJFXFileChooser;
    }

    public SynchronousJFXFileChooser(Supplier<FileChooser> supplier) {
        this.fileChooserFactory = supplier;
    }

    public Object showDialog(Object object) {
        if (object instanceof IFileFunction) {
            return this.showDialog((IFileFunction)object, 1L, TimeUnit.SECONDS);
        }
        return null;
    }

    public <T> T showDialog(IFileFunction iFileFunction) {
        return this.showDialog(iFileFunction, 1L, TimeUnit.SECONDS);
    }

    private <T> T showDialog(IFileFunction iFileFunction, long l, TimeUnit timeUnit) {
        Callable<Object> callable = () -> {
            FileChooser fileChooser = this.fileChooserFactory.get();
            return iFileFunction.apply(fileChooser);
        };
        SynchronousJFXCaller<Object> synchronousJFXCaller = new SynchronousJFXCaller<Object>(callable);
        try {
            return (T)synchronousJFXCaller.call(l, timeUnit);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception exception) {
            throw new AssertionError("Got unexpected checked exception from SynchronousJFXCaller.call()", exception);
        }
    }

    public File showOpenDialog() {
        return (File)this.showDialog((FileChooser fileChooser) -> {
            File file = fileChooser.showOpenDialog(null);
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(file);
            return arrayList;
        });
    }

    public File showSaveDialog() {
        return (File)this.showDialog((FileChooser fileChooser) -> {
            File file = fileChooser.showSaveDialog(null);
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(file);
            return arrayList;
        });
    }

    public List<File> showOpenMultipleDialog() {
        return (List)this.showDialog((FileChooser fileChooser) -> fileChooser.showOpenMultipleDialog(null));
    }
}

