/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.mapstorage.impl;

import com.thinkbuzan.gaia.mapstorage.Storage;
import com.thinkbuzan.gaia.mapstorage.impl.ProtectedFileStorageHelper;
import com.thinkbuzan.gaia.mapstorage.impl.Validator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileStorage
implements Storage {
    private static final Logger a;
    private final transient String b;
    private final transient List<String> c = new LinkedList<String>();
    private final String d;
    public static final String ILLEGAL_CHARACTERS;
    public static final Pattern COMPILED_REGEX;
    public static int e;
    private static final String[] z;

    public AbstractFileStorage(String string, String string2) {
        Validator.validateNotEmpty(string, z[2]);
        Validator.validateNotEmpty(string2, z[1]);
        this.b = string2;
        this.d = string;
    }

    public final void addFile(String string) throws IOException {
        File file = this.getFile(string);
        if (!file.exists()) {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
        this.c.add(string);
    }

    @Override
    public final String getStorageId() {
        return this.b;
    }

    @Override
    public final boolean create() {
        File file = new File(this.getRootLocation());
        if (file.exists()) {
            return false;
        }
        boolean bl = file.mkdirs();
        if (!bl) {
            a.fatal((Object)(z[0] + file));
        }
        return bl;
    }

    @Override
    public final boolean remove(String string) {
        boolean bl;
        block3: {
            File file;
            block2: {
                file = this.getFile(string);
                bl = file.delete();
                if (!bl) break block2;
                this.c.remove(string);
                if (Validator.a == 0) break block3;
            }
            a.warn((Object)(z[6] + file + z[5]));
        }
        return bl;
    }

    public final File getFile(String string) {
        return new File(this.getRootLocation() + File.separator + string);
    }

    @Override
    public final boolean remove() {
        a.debug((Object)(z[4] + this + " " + this.getRootLocation()));
        try {
            ProtectedFileStorageHelper.getInstance().destroyUnencryptedFiles(this.getStorageId());
            FileUtils.deleteDirectory((File)new File(this.getRootLocation()));
            this.c.clear();
        }
        catch (IOException iOException) {
            a.warn((Object)(z[3] + this + " " + this.getRootLocation()), (Throwable)iOException);
            return false;
        }
        return true;
    }

    @Override
    public final String getRootLocation() {
        return this.d + File.separator + this.b;
    }

    @Override
    public final boolean exist(String string) {
        return this.c.contains(string);
    }

    protected final void validateName(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException(z[8]);
        }
        Matcher matcher = COMPILED_REGEX.matcher(string);
        if (matcher.find()) {
            throw new IllegalArgumentException(z[7]);
        }
    }

    @Override
    public final void reset() {
        this.c.clear();
        File file = new File(this.getRootLocation());
        this.a(this.c, file);
    }

    private void a(List<String> list, File file) {
        File[] fileArray;
        int n = Validator.a;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.a(list, file2);
                if (n == 0) continue;
            }
            list.add(file2.getAbsolutePath().substring(this.getRootLocation().length() + 1));
            if (n == 0) continue;
        }
    }

    @Override
    public final List<String> getAllData() {
        return Collections.unmodifiableList(this.c);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block109: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block108: {
                char[] cArray3;
                Object var0;
                block107: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block106: {
                        char[] cArray5;
                        block105: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block104: {
                                char[] cArray7;
                                block103: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block102: {
                                        char[] cArray9;
                                        block101: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block100: {
                                                char[] cArray11;
                                                block99: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block98: {
                                                        char[] cArray13;
                                                        block97: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block96: {
                                                                char[] cArray15;
                                                                block95: {
                                                                    int n16;
                                                                    int n17;
                                                                    char[] cArray16;
                                                                    block94: {
                                                                        char[] cArray17;
                                                                        block93: {
                                                                            int n18;
                                                                            int n19;
                                                                            char[] cArray18;
                                                                            block92: {
                                                                                char[] cArray19;
                                                                                block91: {
                                                                                    int n20;
                                                                                    int n21;
                                                                                    char[] cArray20;
                                                                                    block90: {
                                                                                        stringArray = new String[9];
                                                                                        var0 = null;
                                                                                        char[] cArray21 = "G\u001e^Jo>\u0018<<,A".toCharArray();
                                                                                        n3 = 0;
                                                                                        int n22 = cArray21.length;
                                                                                        cArray20 = cArray21;
                                                                                        n21 = n22;
                                                                                        if (n22 <= 1) break block90;
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                        if (n21 <= n3) break block91;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray22 = cArray20;
                                                                                        char[] cArray23 = cArray20;
                                                                                        int n23 = n3;
                                                                                        while (true) {
                                                                                            int n24;
                                                                                            char c = cArray22[n23];
                                                                                            switch (n3 % 5) {
                                                                                                case 0: {
                                                                                                    n24 = 28;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n24 = 36;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n24 = 2;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n24 = 96;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n24 = 80;
                                                                                                }
                                                                                            }
                                                                                            cArray22[n23] = (char)(c ^ n24);
                                                                                            ++n3;
                                                                                            cArray20 = cArray23;
                                                                                            n21 = n21;
                                                                                            if (n21 != 0) break;
                                                                                            cArray23 = cArray20;
                                                                                            n20 = n21;
                                                                                            n23 = n21;
                                                                                            cArray22 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                    } while (n21 > n3);
                                                                                }
                                                                                ILLEGAL_CHARACTERS = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray24 = "\u007fKw\f4<Jm\u0014p\u007fVg\u0001$y\u0004f\t\"yGv\u000f\"e\u0004k\u000epoPm\u00121{A\"\f?\u007fEv\t?r\u0004".toCharArray();
                                                                                n3 = 0;
                                                                                int n25 = cArray24.length;
                                                                                cArray18 = cArray24;
                                                                                n19 = n25;
                                                                                if (n25 <= 1) break block92;
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                                if (n19 <= n3) break block93;
                                                                            }
                                                                            do {
                                                                                char[] cArray25 = cArray18;
                                                                                char[] cArray26 = cArray18;
                                                                                int n26 = n3;
                                                                                while (true) {
                                                                                    int n27;
                                                                                    char c = cArray25[n26];
                                                                                    switch (n3 % 5) {
                                                                                        case 0: {
                                                                                            n27 = 28;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n27 = 36;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n27 = 2;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n27 = 96;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n27 = 80;
                                                                                        }
                                                                                    }
                                                                                    cArray25[n26] = (char)(c ^ n27);
                                                                                    ++n3;
                                                                                    cArray18 = cArray26;
                                                                                    n19 = n19;
                                                                                    if (n19 != 0) break;
                                                                                    cArray26 = cArray18;
                                                                                    n18 = n19;
                                                                                    n26 = n19;
                                                                                    cArray25 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                            } while (n19 > n3);
                                                                        }
                                                                        stringArray[0] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray27 = "]Fq\u0014\"}Gv&9pAQ\u0014?nEe\u0005|<Ic\u0010\u0019X\u0004a\u0001><Jm\u0014p~A\"\u000e%pH".toCharArray();
                                                                        n3 = 0;
                                                                        int n28 = cArray27.length;
                                                                        cArray16 = cArray27;
                                                                        n17 = n28;
                                                                        if (n28 <= 1) break block94;
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                        if (n17 <= n3) break block95;
                                                                    }
                                                                    do {
                                                                        char[] cArray28 = cArray16;
                                                                        char[] cArray29 = cArray16;
                                                                        int n29 = n3;
                                                                        while (true) {
                                                                            int n30;
                                                                            char c = cArray28[n29];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n30 = 28;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n30 = 36;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n30 = 2;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n30 = 96;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n30 = 80;
                                                                                }
                                                                            }
                                                                            cArray28[n29] = (char)(c ^ n30);
                                                                            ++n3;
                                                                            cArray16 = cArray29;
                                                                            n17 = n17;
                                                                            if (n17 != 0) break;
                                                                            cArray29 = cArray16;
                                                                            n16 = n17;
                                                                            n29 = n17;
                                                                            cArray28 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                    } while (n17 > n3);
                                                                }
                                                                stringArray[1] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray30 = "]Fq\u0014\"}Gv&9pAQ\u0014?nEe\u0005|<Vm\u000f$XMp\u00053hKp\u0019\u0019r\u0004a\u0001><Jm\u0014p~A\"\u000e%pH".toCharArray();
                                                                n3 = 0;
                                                                int n31 = cArray30.length;
                                                                cArray14 = cArray30;
                                                                n15 = n31;
                                                                if (n31 <= 1) break block96;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block97;
                                                            }
                                                            do {
                                                                char[] cArray31 = cArray14;
                                                                char[] cArray32 = cArray14;
                                                                int n32 = n3;
                                                                while (true) {
                                                                    int n33;
                                                                    char c = cArray31[n32];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n33 = 28;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n33 = 36;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n33 = 2;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n33 = 96;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n33 = 80;
                                                                        }
                                                                    }
                                                                    cArray31[n32] = (char)(c ^ n33);
                                                                    ++n3;
                                                                    cArray14 = cArray32;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray32 = cArray14;
                                                                    n14 = n15;
                                                                    n32 = n15;
                                                                    cArray31 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[2] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray33 = "\u007fKw\f4<Jm\u0014pnAo\u000f&y\u0004q\u0014?nEe\u0005p".toCharArray();
                                                        n3 = 0;
                                                        int n34 = cArray33.length;
                                                        cArray12 = cArray33;
                                                        n13 = n34;
                                                        if (n34 <= 1) break block98;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block99;
                                                    }
                                                    do {
                                                        char[] cArray34 = cArray12;
                                                        char[] cArray35 = cArray12;
                                                        int n35 = n3;
                                                        while (true) {
                                                            int n36;
                                                            char c = cArray34[n35];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n36 = 28;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n36 = 36;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n36 = 2;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n36 = 96;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n36 = 80;
                                                                }
                                                            }
                                                            cArray34[n35] = (char)(c ^ n36);
                                                            ++n3;
                                                            cArray12 = cArray35;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray35 = cArray12;
                                                            n12 = n13;
                                                            n35 = n13;
                                                            cArray34 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[3] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray36 = "nAo\u000f&uJe@#hKp\u00017y\u0004".toCharArray();
                                                n3 = 0;
                                                int n37 = cArray36.length;
                                                cArray10 = cArray36;
                                                n11 = n37;
                                                if (n37 <= 1) break block100;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block101;
                                            }
                                            do {
                                                char[] cArray37 = cArray10;
                                                char[] cArray38 = cArray10;
                                                int n38 = n3;
                                                while (true) {
                                                    int n39;
                                                    char c = cArray37[n38];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n39 = 28;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n39 = 36;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n39 = 2;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n39 = 96;
                                                            break;
                                                        }
                                                        default: {
                                                            n39 = 80;
                                                        }
                                                    }
                                                    cArray37[n38] = (char)(c ^ n39);
                                                    ++n3;
                                                    cArray10 = cArray38;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray38 = cArray10;
                                                    n10 = n11;
                                                    n38 = n11;
                                                    cArray37 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[4] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray39 = "<Bp\u000f=<Bk\f5<Wv\u000f\"}Cg".toCharArray();
                                        n3 = 0;
                                        int n40 = cArray39.length;
                                        cArray8 = cArray39;
                                        n9 = n40;
                                        if (n40 <= 1) break block102;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block103;
                                    }
                                    do {
                                        char[] cArray40 = cArray8;
                                        char[] cArray41 = cArray8;
                                        int n41 = n3;
                                        while (true) {
                                            int n42;
                                            char c = cArray40[n41];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n42 = 28;
                                                    break;
                                                }
                                                case 1: {
                                                    n42 = 36;
                                                    break;
                                                }
                                                case 2: {
                                                    n42 = 2;
                                                    break;
                                                }
                                                case 3: {
                                                    n42 = 96;
                                                    break;
                                                }
                                                default: {
                                                    n42 = 80;
                                                }
                                            }
                                            cArray40[n41] = (char)(c ^ n42);
                                            ++n3;
                                            cArray8 = cArray41;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray41 = cArray8;
                                            n8 = n9;
                                            n41 = n9;
                                            cArray40 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[5] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray42 = "\u007fKw\f4<Jm\u0014pnAo\u000f&y\u0004".toCharArray();
                                n3 = 0;
                                int n43 = cArray42.length;
                                cArray6 = cArray42;
                                n7 = n43;
                                if (n43 <= 1) break block104;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block105;
                            }
                            do {
                                char[] cArray43 = cArray6;
                                char[] cArray44 = cArray6;
                                int n44 = n3;
                                while (true) {
                                    int n45;
                                    char c = cArray43[n44];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n45 = 28;
                                            break;
                                        }
                                        case 1: {
                                            n45 = 36;
                                            break;
                                        }
                                        case 2: {
                                            n45 = 2;
                                            break;
                                        }
                                        case 3: {
                                            n45 = 96;
                                            break;
                                        }
                                        default: {
                                            n45 = 80;
                                        }
                                    }
                                    cArray43[n44] = (char)(c ^ n45);
                                    ++n3;
                                    cArray6 = cArray44;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray44 = cArray6;
                                    n6 = n7;
                                    n44 = n7;
                                    cArray43 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[6] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray45 = "rEo\u0005p\u007fEl@>sP\"\u0003?rPc\t><Mn\f5{En@3tEp\u00013hAp\u0013p&\u0004 Zp6\u0004=@r<\u0018\"^p`\u0006".toCharArray();
                        n3 = 0;
                        int n46 = cArray45.length;
                        cArray4 = cArray45;
                        n5 = n46;
                        if (n46 <= 1) break block106;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block107;
                    }
                    do {
                        char[] cArray46 = cArray4;
                        char[] cArray47 = cArray4;
                        int n47 = n3;
                        while (true) {
                            int n48;
                            char c = cArray46[n47];
                            switch (n3 % 5) {
                                case 0: {
                                    n48 = 28;
                                    break;
                                }
                                case 1: {
                                    n48 = 36;
                                    break;
                                }
                                case 2: {
                                    n48 = 2;
                                    break;
                                }
                                case 3: {
                                    n48 = 96;
                                    break;
                                }
                                default: {
                                    n48 = 80;
                                }
                            }
                            cArray46[n47] = (char)(c ^ n48);
                            ++n3;
                            cArray4 = cArray47;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray47 = cArray4;
                            n4 = n5;
                            n47 = n5;
                            cArray46 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[7] = new String(cArray3).intern();
                var0 = null;
                char[] cArray48 = "lEp\u0001=<Jc\r5<Iw\u0013$<Fg@>sP\"\u0005=lP{@#hVk\u000e7".toCharArray();
                n3 = 0;
                int n49 = cArray48.length;
                cArray2 = cArray48;
                n2 = n49;
                if (n49 <= 1) break block108;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block109;
            }
            do {
                char[] cArray49 = cArray2;
                char[] cArray50 = cArray2;
                int n50 = n3;
                while (true) {
                    int n51;
                    char c = cArray49[n50];
                    switch (n3 % 5) {
                        case 0: {
                            n51 = 28;
                            break;
                        }
                        case 1: {
                            n51 = 36;
                            break;
                        }
                        case 2: {
                            n51 = 2;
                            break;
                        }
                        case 3: {
                            n51 = 96;
                            break;
                        }
                        default: {
                            n51 = 80;
                        }
                    }
                    cArray49[n50] = (char)(c ^ n51);
                    ++n3;
                    cArray2 = cArray50;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray50 = cArray2;
                    n = n2;
                    n50 = n2;
                    cArray49 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[8] = new String(cArray).intern();
        z = stringArray;
        a = Logger.getLogger(AbstractFileStorage.class);
        COMPILED_REGEX = Pattern.compile(ILLEGAL_CHARACTERS);
    }
}

