/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.mapstorage.impl;

import com.thinkbuzan.gaia.mapstorage.IMMFileType;
import com.thinkbuzan.gaia.mapstorage.MapStorage;
import com.thinkbuzan.gaia.mapstorage.MapStorageListener;
import com.thinkbuzan.gaia.mapstorage.Storage;
import com.thinkbuzan.gaia.mapstorage.impl.FileStorage;
import com.thinkbuzan.gaia.mapstorage.impl.Validator;
import com.thinkbuzan.gaia.mapstorage.impl.util.MapStorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public final class MapStorageImpl
implements MapStorage {
    private static final Logger a;
    private static final Random b;
    private transient Storage c;
    private final List<MapStorageListener> d = new CopyOnWriteArrayList<MapStorageListener>();
    private final ReentrantLock e = new ReentrantLock();
    private static final String[] z;

    public MapStorageImpl(Storage storage) {
        if (storage == null) {
            throw new IllegalArgumentException(z[10]);
        }
        this.c = storage;
    }

    public String generateUniqueName(IMMFileType iMMFileType) {
        int n = Validator.a;
        for (int i = 0; i < 10; ++i) {
            int n2 = b.nextInt(100000000) + 100000000;
            String string = String.valueOf(n2);
            if (iMMFileType == IMMFileType.ICO) {
                string = string.concat(z[19]);
            }
            if (this.c.exist(iMMFileType.getLocation() + File.separator + string)) continue;
            return string;
        }
        throw new IllegalStateException(z[18]);
    }

    public boolean updateFile(String string, IMMFileType iMMFileType, File file) {
        FileInputStream fileInputStream;
        Validator.validateFileReadable(file, z[0]);
        if (!this.c.exist(iMMFileType.getLocation() + File.separator + string)) {
            a.warn((Object)(z[1] + string));
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        return this.updateData(string, iMMFileType, fileInputStream);
    }

    public String addFile(IMMFileType iMMFileType, File file) {
        FileInputStream fileInputStream;
        Validator.validateFileReadable(file, z[17]);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return this.addData(iMMFileType, fileInputStream);
    }

    public OutputStream add(String string, IMMFileType iMMFileType) {
        Validator.validateNotEmpty(string, z[8]);
        Validator.validateNotNull((Object)iMMFileType, z[7]);
        return this.c.add(iMMFileType.getLocation() + File.separator + string);
    }

    public InputStream read(String string, IMMFileType iMMFileType) {
        Validator.validateNotEmpty(string, z[8]);
        Validator.validateNotNull((Object)iMMFileType, z[7]);
        return this.c.read(iMMFileType.getLocation() + File.separator + string);
    }

    public File readFile(String string, IMMFileType iMMFileType) {
        Validator.validateNotEmpty(string, z[8]);
        Validator.validateNotNull((Object)iMMFileType, z[7]);
        return this.c.readFile(iMMFileType.getLocation() + File.separator + string);
    }

    public OutputStream update(String string, IMMFileType iMMFileType) {
        Validator.validateNotEmpty(string, z[8]);
        Validator.validateNotNull((Object)iMMFileType, z[7]);
        return this.c.update(iMMFileType.getLocation() + File.separator + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String string, IMMFileType iMMFileType) {
        Validator.validateNotEmpty(string, z[8]);
        Validator.validateNotNull((Object)iMMFileType, z[7]);
        this.lock();
        try {
            boolean bl = this.c.remove(iMMFileType.getLocation() + File.separator + string);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addData(IMMFileType iMMFileType, InputStream inputStream) {
        Validator.validateNotNull((Object)iMMFileType, z[5]);
        Validator.validateNotNull(inputStream, z[2]);
        String string = this.generateUniqueName(iMMFileType);
        OutputStream outputStream = this.add(string, iMMFileType);
        if (outputStream == null) {
            a.error((Object)z[4]);
            return null;
        }
        try {
            MapStorageUtils.copyStream(inputStream, outputStream);
        }
        catch (IOException iOException) {
            String string2;
            try {
                a.error((Object)(z[3] + inputStream));
                string2 = null;
            }
            catch (Throwable throwable) {
                MapStorageUtils.closeQuietly(inputStream, outputStream);
                throw throwable;
            }
            MapStorageUtils.closeQuietly(inputStream, outputStream);
            return string2;
        }
        MapStorageUtils.closeQuietly(inputStream, outputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(String string, IMMFileType iMMFileType, InputStream inputStream) {
        Validator.validateNotNull(string, z[6]);
        Validator.validateNotNull((Object)iMMFileType, z[5]);
        Validator.validateNotNull(inputStream, z[2]);
        OutputStream outputStream = this.update(string, iMMFileType);
        if (outputStream == null) {
            a.error((Object)z[4]);
            return false;
        }
        try {
            MapStorageUtils.copyStream(inputStream, outputStream);
        }
        catch (IOException iOException) {
            boolean bl;
            try {
                a.error((Object)(z[3] + inputStream));
                bl = false;
            }
            catch (Throwable throwable) {
                MapStorageUtils.closeQuietly(inputStream, outputStream);
                throw throwable;
            }
            MapStorageUtils.closeQuietly(inputStream, outputStream);
            return bl;
        }
        MapStorageUtils.closeQuietly(inputStream, outputStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        this.lock();
        try {
            boolean bl = this.c.remove();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public Storage getStorage() {
        return this.c;
    }

    public void setStorage(Storage storage) {
        Validator.validateNotNull(storage, z[9]);
        this.c = storage;
        this.a();
    }

    private void a() {
        int n = Validator.a;
        for (MapStorageListener mapStorageListener : this.d) {
            mapStorageListener.storageChanged();
            if (n == 0) continue;
        }
    }

    public boolean isProtected() {
        return this.c.isProtected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapStorage clone(String string, String string2) {
        FileStorage fileStorage;
        Storage storage;
        block10: {
            block9: {
                Validator.validateNotEmpty(string, z[16]);
                Validator.validateNotEmpty(string2, z[13]);
                storage = this.getStorage();
                if (!(storage instanceof FileStorage)) break block9;
                fileStorage = new FileStorage(string2, string);
                if (Validator.a == 0) break block10;
            }
            throw new UnsupportedOperationException(z[12]);
        }
        if (!fileStorage.create()) {
            a.warn((Object)(z[11] + storage + z[14] + fileStorage.getRootLocation()));
            return null;
        }
        File file = new File(storage.getRootLocation());
        File file2 = new File(fileStorage.getRootLocation());
        MapStorageImpl mapStorageImpl = this;
        synchronized (mapStorageImpl) {
            try {
                FileUtils.copyDirectory((File)file, (File)file2);
            }
            catch (IOException iOException) {
                a.error((Object)z[15], (Throwable)iOException);
                return null;
            }
        }
        fileStorage.reset();
        return new MapStorageImpl(fileStorage);
    }

    public boolean tryLock() {
        return this.e.tryLock();
    }

    public void lock() {
        this.e.lock();
    }

    public void unlock() {
        this.e.unlock();
    }

    public void addListener(MapStorageListener mapStorageListener) {
        this.d.add(mapStorageListener);
    }

    public void removeListener(MapStorageListener mapStorageListener) {
        this.d.remove(mapStorageListener);
    }

    public boolean exists(IMMFileType iMMFileType, String string) {
        return this.c.exist(iMMFileType.getLocation() + File.separator + string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block219: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block218: {
                char[] cArray3;
                Object var0;
                block217: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block216: {
                        char[] cArray5;
                        block215: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block214: {
                                char[] cArray7;
                                block213: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block212: {
                                        char[] cArray9;
                                        block211: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block210: {
                                                char[] cArray11;
                                                block209: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block208: {
                                                        char[] cArray13;
                                                        block207: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block206: {
                                                                char[] cArray15;
                                                                block205: {
                                                                    int n16;
                                                                    int n17;
                                                                    char[] cArray16;
                                                                    block204: {
                                                                        char[] cArray17;
                                                                        block203: {
                                                                            int n18;
                                                                            int n19;
                                                                            char[] cArray18;
                                                                            block202: {
                                                                                char[] cArray19;
                                                                                block201: {
                                                                                    int n20;
                                                                                    int n21;
                                                                                    char[] cArray20;
                                                                                    block200: {
                                                                                        char[] cArray21;
                                                                                        block199: {
                                                                                            int n22;
                                                                                            int n23;
                                                                                            char[] cArray22;
                                                                                            block198: {
                                                                                                char[] cArray23;
                                                                                                block197: {
                                                                                                    int n24;
                                                                                                    int n25;
                                                                                                    char[] cArray24;
                                                                                                    block196: {
                                                                                                        char[] cArray25;
                                                                                                        block195: {
                                                                                                            int n26;
                                                                                                            int n27;
                                                                                                            char[] cArray26;
                                                                                                            block194: {
                                                                                                                char[] cArray27;
                                                                                                                block193: {
                                                                                                                    int n28;
                                                                                                                    int n29;
                                                                                                                    char[] cArray28;
                                                                                                                    block192: {
                                                                                                                        char[] cArray29;
                                                                                                                        block191: {
                                                                                                                            int n30;
                                                                                                                            int n31;
                                                                                                                            char[] cArray30;
                                                                                                                            block190: {
                                                                                                                                char[] cArray31;
                                                                                                                                block189: {
                                                                                                                                    int n32;
                                                                                                                                    int n33;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block188: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block187: {
                                                                                                                                            int n34;
                                                                                                                                            int n35;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block186: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block185: {
                                                                                                                                                    int n36;
                                                                                                                                                    int n37;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block184: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block183: {
                                                                                                                                                            int n38;
                                                                                                                                                            int n39;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block182: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block181: {
                                                                                                                                                                    int n40;
                                                                                                                                                                    int n41;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block180: {
                                                                                                                                                                        stringArray = new String[20];
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray41 = "Ts\u0003(*v`\u0012\u001c;7g\u0003\u001f?mw5\u00122|".toCharArray();
                                                                                                                                                                        n3 = 0;
                                                                                                                                                                        int n42 = cArray41.length;
                                                                                                                                                                        cArray40 = cArray41;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                        if (n42 <= 1) break block180;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n40 = n41;
                                                                                                                                                                        if (n41 <= n3) break block181;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray42 = cArray40;
                                                                                                                                                                        char[] cArray43 = cArray40;
                                                                                                                                                                        int n43 = n3;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n44;
                                                                                                                                                                            char c = cArray42[n43];
                                                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n44 = 25;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n44 = 18;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n44 = 115;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n44 = 123;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n44 = 94;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray42[n43] = (char)(c ^ n44);
                                                                                                                                                                            ++n3;
                                                                                                                                                                            cArray40 = cArray43;
                                                                                                                                                                            n41 = n41;
                                                                                                                                                                            if (n41 != 0) break;
                                                                                                                                                                            cArray43 = cArray40;
                                                                                                                                                                            n40 = n41;
                                                                                                                                                                            n43 = n41;
                                                                                                                                                                            cArray42 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n40 = n41;
                                                                                                                                                                    } while (n41 > n3);
                                                                                                                                                                }
                                                                                                                                                                stringArray[0] = new String(cArray39).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray44 = "lb\u0017\u001a*p|\u0014[0vfS\u001e&pa\u0007\u00120~2\u0015\u00122|2".toCharArray();
                                                                                                                                                                n3 = 0;
                                                                                                                                                                int n45 = cArray44.length;
                                                                                                                                                                cArray38 = cArray44;
                                                                                                                                                                n39 = n45;
                                                                                                                                                                if (n45 <= 1) break block182;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n38 = n39;
                                                                                                                                                                if (n39 <= n3) break block183;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray45 = cArray38;
                                                                                                                                                                char[] cArray46 = cArray38;
                                                                                                                                                                int n46 = n3;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n47;
                                                                                                                                                                    char c = cArray45[n46];
                                                                                                                                                                    switch (n3 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n47 = 25;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n47 = 18;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n47 = 115;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n47 = 123;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n47 = 94;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray45[n46] = (char)(c ^ n47);
                                                                                                                                                                    ++n3;
                                                                                                                                                                    cArray38 = cArray46;
                                                                                                                                                                    n39 = n39;
                                                                                                                                                                    if (n39 != 0) break;
                                                                                                                                                                    cArray46 = cArray38;
                                                                                                                                                                    n38 = n39;
                                                                                                                                                                    n46 = n39;
                                                                                                                                                                    cArray45 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n38 = n39;
                                                                                                                                                            } while (n39 > n3);
                                                                                                                                                        }
                                                                                                                                                        stringArray[1] = new String(cArray37).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray47 = "is\u0001\u001a39v\u0012\u000f?9q\u0012\u0015~w}\u0007[<|2\u001d\u000e2u".toCharArray();
                                                                                                                                                        n3 = 0;
                                                                                                                                                        int n48 = cArray47.length;
                                                                                                                                                        cArray36 = cArray47;
                                                                                                                                                        n37 = n48;
                                                                                                                                                        if (n48 <= 1) break block184;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n36 = n37;
                                                                                                                                                        if (n37 <= n3) break block185;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray48 = cArray36;
                                                                                                                                                        char[] cArray49 = cArray36;
                                                                                                                                                        int n49 = n3;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n50;
                                                                                                                                                            char c = cArray48[n49];
                                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n50 = 25;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n50 = 18;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n50 = 115;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n50 = 123;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n50 = 94;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray48[n49] = (char)(c ^ n50);
                                                                                                                                                            ++n3;
                                                                                                                                                            cArray36 = cArray49;
                                                                                                                                                            n37 = n37;
                                                                                                                                                            if (n37 != 0) break;
                                                                                                                                                            cArray49 = cArray36;
                                                                                                                                                            n36 = n37;
                                                                                                                                                            n49 = n37;
                                                                                                                                                            cArray48 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n36 = n37;
                                                                                                                                                    } while (n37 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[2] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray50 = "z}\u0006\u0017:9|\u001c\u000f~xv\u0017[:xf\u0012[".toCharArray();
                                                                                                                                                n3 = 0;
                                                                                                                                                int n51 = cArray50.length;
                                                                                                                                                cArray34 = cArray50;
                                                                                                                                                n35 = n51;
                                                                                                                                                if (n51 <= 1) break block186;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n34 = n35;
                                                                                                                                                if (n35 <= n3) break block187;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray51 = cArray34;
                                                                                                                                                char[] cArray52 = cArray34;
                                                                                                                                                int n52 = n3;
                                                                                                                                                while (true) {
                                                                                                                                                    int n53;
                                                                                                                                                    char c = cArray51[n52];
                                                                                                                                                    switch (n3 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n53 = 25;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n53 = 18;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n53 = 115;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n53 = 123;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n53 = 94;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray51[n52] = (char)(c ^ n53);
                                                                                                                                                    ++n3;
                                                                                                                                                    cArray34 = cArray52;
                                                                                                                                                    n35 = n35;
                                                                                                                                                    if (n35 != 0) break;
                                                                                                                                                    cArray52 = cArray34;
                                                                                                                                                    n34 = n35;
                                                                                                                                                    n52 = n35;
                                                                                                                                                    cArray51 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n34 = n35;
                                                                                                                                            } while (n35 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[3] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray53 = "z}\u0006\u0017:9|\u001c\u000f~z`\u0016\u001a*|2\u001d\u001e)9p\u001a\u0015?kkS\u001f?msS\u001209\u007f\u0012\u000b~jf\u001c\t?~w".toCharArray();
                                                                                                                                        n3 = 0;
                                                                                                                                        int n54 = cArray53.length;
                                                                                                                                        cArray32 = cArray53;
                                                                                                                                        n33 = n54;
                                                                                                                                        if (n54 <= 1) break block188;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n32 = n33;
                                                                                                                                        if (n33 <= n3) break block189;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray54 = cArray32;
                                                                                                                                        char[] cArray55 = cArray32;
                                                                                                                                        int n55 = n3;
                                                                                                                                        while (true) {
                                                                                                                                            int n56;
                                                                                                                                            char c = cArray54[n55];
                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n56 = 25;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n56 = 18;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n56 = 115;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n56 = 123;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n56 = 94;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray54[n55] = (char)(c ^ n56);
                                                                                                                                            ++n3;
                                                                                                                                            cArray32 = cArray55;
                                                                                                                                            n33 = n33;
                                                                                                                                            if (n33 != 0) break;
                                                                                                                                            cArray55 = cArray32;
                                                                                                                                            n32 = n33;
                                                                                                                                            n55 = n33;
                                                                                                                                            cArray54 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n32 = n33;
                                                                                                                                    } while (n33 > n3);
                                                                                                                                }
                                                                                                                                stringArray[4] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray56 = "is\u0001\u001a39t\u001a\u0017;Mk\u0003\u001e~zs\u001d[0vfS\u0019;9|\u0006\u00172".toCharArray();
                                                                                                                                n3 = 0;
                                                                                                                                int n57 = cArray56.length;
                                                                                                                                cArray30 = cArray56;
                                                                                                                                n31 = n57;
                                                                                                                                if (n57 <= 1) break block190;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n30 = n31;
                                                                                                                                if (n31 <= n3) break block191;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray57 = cArray30;
                                                                                                                                char[] cArray58 = cArray30;
                                                                                                                                int n58 = n3;
                                                                                                                                while (true) {
                                                                                                                                    int n59;
                                                                                                                                    char c = cArray57[n58];
                                                                                                                                    switch (n3 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n59 = 25;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n59 = 18;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n59 = 115;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n59 = 123;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n59 = 94;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray57[n58] = (char)(c ^ n59);
                                                                                                                                    ++n3;
                                                                                                                                    cArray30 = cArray58;
                                                                                                                                    n31 = n31;
                                                                                                                                    if (n31 != 0) break;
                                                                                                                                    cArray58 = cArray30;
                                                                                                                                    n30 = n31;
                                                                                                                                    n58 = n31;
                                                                                                                                    cArray57 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n30 = n31;
                                                                                                                            } while (n31 > n3);
                                                                                                                        }
                                                                                                                        stringArray[5] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray59 = "is\u0001\u001a39|\u0012\u0016;9q\u0012\u0015~w}\u0007[<|2\u001d\u000e2u".toCharArray();
                                                                                                                        n3 = 0;
                                                                                                                        int n60 = cArray59.length;
                                                                                                                        cArray28 = cArray59;
                                                                                                                        n29 = n60;
                                                                                                                        if (n60 <= 1) break block192;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n28 = n29;
                                                                                                                        if (n29 <= n3) break block193;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray60 = cArray28;
                                                                                                                        char[] cArray61 = cArray28;
                                                                                                                        int n61 = n3;
                                                                                                                        while (true) {
                                                                                                                            int n62;
                                                                                                                            char c = cArray60[n61];
                                                                                                                            switch (n3 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n62 = 25;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n62 = 18;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n62 = 115;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n62 = 123;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n62 = 94;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray60[n61] = (char)(c ^ n62);
                                                                                                                            ++n3;
                                                                                                                            cArray28 = cArray61;
                                                                                                                            n29 = n29;
                                                                                                                            if (n29 != 0) break;
                                                                                                                            cArray61 = cArray28;
                                                                                                                            n28 = n29;
                                                                                                                            n61 = n29;
                                                                                                                            cArray60 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n28 = n29;
                                                                                                                    } while (n29 > n3);
                                                                                                                }
                                                                                                                stringArray[6] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray62 = "\u007f{\u001f\u001e~mk\u0003\u001e~zs\u001d[0vfS\u0019;9|\u0006\u00172".toCharArray();
                                                                                                                n3 = 0;
                                                                                                                int n63 = cArray62.length;
                                                                                                                cArray26 = cArray62;
                                                                                                                n27 = n63;
                                                                                                                if (n63 <= 1) break block194;
                                                                                                                cArray25 = cArray26;
                                                                                                                n26 = n27;
                                                                                                                if (n27 <= n3) break block195;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray63 = cArray26;
                                                                                                                char[] cArray64 = cArray26;
                                                                                                                int n64 = n3;
                                                                                                                while (true) {
                                                                                                                    int n65;
                                                                                                                    char c = cArray63[n64];
                                                                                                                    switch (n3 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n65 = 25;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n65 = 18;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n65 = 115;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n65 = 123;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n65 = 94;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray63[n64] = (char)(c ^ n65);
                                                                                                                    ++n3;
                                                                                                                    cArray26 = cArray64;
                                                                                                                    n27 = n27;
                                                                                                                    if (n27 != 0) break;
                                                                                                                    cArray64 = cArray26;
                                                                                                                    n26 = n27;
                                                                                                                    n64 = n27;
                                                                                                                    cArray63 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n26 = n27;
                                                                                                            } while (n27 > n3);
                                                                                                        }
                                                                                                        stringArray[7] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray65 = "is\u0001\u001a39|\u0012\u0016;9q\u0012\u0015~w}\u0007[<|2\u0016\u0016.mkS\u0014,9|\u0006\u00172".toCharArray();
                                                                                                        n3 = 0;
                                                                                                        int n66 = cArray65.length;
                                                                                                        cArray24 = cArray65;
                                                                                                        n25 = n66;
                                                                                                        if (n66 <= 1) break block196;
                                                                                                        cArray23 = cArray24;
                                                                                                        n24 = n25;
                                                                                                        if (n25 <= n3) break block197;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray66 = cArray24;
                                                                                                        char[] cArray67 = cArray24;
                                                                                                        int n67 = n3;
                                                                                                        while (true) {
                                                                                                            int n68;
                                                                                                            char c = cArray66[n67];
                                                                                                            switch (n3 % 5) {
                                                                                                                case 0: {
                                                                                                                    n68 = 25;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n68 = 18;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n68 = 115;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n68 = 123;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n68 = 94;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray66[n67] = (char)(c ^ n68);
                                                                                                            ++n3;
                                                                                                            cArray24 = cArray67;
                                                                                                            n25 = n25;
                                                                                                            if (n25 != 0) break;
                                                                                                            cArray67 = cArray24;
                                                                                                            n24 = n25;
                                                                                                            n67 = n25;
                                                                                                            cArray66 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n24 = n25;
                                                                                                    } while (n25 > n3);
                                                                                                }
                                                                                                stringArray[8] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray68 = "is\u0001\u001a39a\u0007\u0014,xu\u0016[=x|S\u00151m2\u0011\u001e~wg\u001f\u0017".toCharArray();
                                                                                                n3 = 0;
                                                                                                int n69 = cArray68.length;
                                                                                                cArray22 = cArray68;
                                                                                                n23 = n69;
                                                                                                if (n69 <= 1) break block198;
                                                                                                cArray21 = cArray22;
                                                                                                n22 = n23;
                                                                                                if (n23 <= n3) break block199;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray69 = cArray22;
                                                                                                char[] cArray70 = cArray22;
                                                                                                int n70 = n3;
                                                                                                while (true) {
                                                                                                    int n71;
                                                                                                    char c = cArray69[n70];
                                                                                                    switch (n3 % 5) {
                                                                                                        case 0: {
                                                                                                            n71 = 25;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n71 = 18;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n71 = 115;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n71 = 123;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n71 = 94;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray69[n70] = (char)(c ^ n71);
                                                                                                    ++n3;
                                                                                                    cArray22 = cArray70;
                                                                                                    n23 = n23;
                                                                                                    if (n23 != 0) break;
                                                                                                    cArray70 = cArray22;
                                                                                                    n22 = n23;
                                                                                                    n70 = n23;
                                                                                                    cArray69 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n22 = n23;
                                                                                            } while (n23 > n3);
                                                                                        }
                                                                                        stringArray[9] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray71 = "is\u0001\u001a39a\u0007\u0014,xu\u0016[3la\u0007[<|2\u001d\u0014*9|\u0006\u00172".toCharArray();
                                                                                        n3 = 0;
                                                                                        int n72 = cArray71.length;
                                                                                        cArray20 = cArray71;
                                                                                        n21 = n72;
                                                                                        if (n72 <= 1) break block200;
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                        if (n21 <= n3) break block201;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray72 = cArray20;
                                                                                        char[] cArray73 = cArray20;
                                                                                        int n73 = n3;
                                                                                        while (true) {
                                                                                            int n74;
                                                                                            char c = cArray72[n73];
                                                                                            switch (n3 % 5) {
                                                                                                case 0: {
                                                                                                    n74 = 25;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n74 = 18;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n74 = 115;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n74 = 123;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n74 = 94;
                                                                                                }
                                                                                            }
                                                                                            cArray72[n73] = (char)(c ^ n74);
                                                                                            ++n3;
                                                                                            cArray20 = cArray73;
                                                                                            n21 = n21;
                                                                                            if (n21 != 0) break;
                                                                                            cArray73 = cArray20;
                                                                                            n20 = n21;
                                                                                            n73 = n21;
                                                                                            cArray72 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                    } while (n21 > n3);
                                                                                }
                                                                                stringArray[10] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray74 = "Z}\u0006\u0017:9|\u001c\u000f~z`\u0016\u001a*|2\u001e\u001a.9a\u0007\u0014,xu\u0016[?m2\u0014\u0012(||S\u00171zs\u0007\u00121w2".toCharArray();
                                                                                n3 = 0;
                                                                                int n75 = cArray74.length;
                                                                                cArray18 = cArray74;
                                                                                n19 = n75;
                                                                                if (n75 <= 1) break block202;
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                                if (n19 <= n3) break block203;
                                                                            }
                                                                            do {
                                                                                char[] cArray75 = cArray18;
                                                                                char[] cArray76 = cArray18;
                                                                                int n76 = n3;
                                                                                while (true) {
                                                                                    int n77;
                                                                                    char c = cArray75[n76];
                                                                                    switch (n3 % 5) {
                                                                                        case 0: {
                                                                                            n77 = 25;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n77 = 18;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n77 = 115;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n77 = 123;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n77 = 94;
                                                                                        }
                                                                                    }
                                                                                    cArray75[n76] = (char)(c ^ n77);
                                                                                    ++n3;
                                                                                    cArray18 = cArray76;
                                                                                    n19 = n19;
                                                                                    if (n19 != 0) break;
                                                                                    cArray76 = cArray18;
                                                                                    n18 = n19;
                                                                                    n76 = n19;
                                                                                    cArray75 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                            } while (n19 > n3);
                                                                        }
                                                                        stringArray[11] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray77 = "w}\u0007[7tb\u001f\u001e3||\u0007\u001e:9k\u0016\u000f".toCharArray();
                                                                        n3 = 0;
                                                                        int n78 = cArray77.length;
                                                                        cArray16 = cArray77;
                                                                        n17 = n78;
                                                                        if (n78 <= 1) break block204;
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                        if (n17 <= n3) break block205;
                                                                    }
                                                                    do {
                                                                        char[] cArray78 = cArray16;
                                                                        char[] cArray79 = cArray16;
                                                                        int n79 = n3;
                                                                        while (true) {
                                                                            int n80;
                                                                            char c = cArray78[n79];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n80 = 25;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n80 = 18;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n80 = 115;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n80 = 123;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n80 = 94;
                                                                                }
                                                                            }
                                                                            cArray78[n79] = (char)(c ^ n80);
                                                                            ++n3;
                                                                            cArray16 = cArray79;
                                                                            n17 = n17;
                                                                            if (n17 != 0) break;
                                                                            cArray79 = cArray16;
                                                                            n16 = n17;
                                                                            n79 = n17;
                                                                            cArray78 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                    } while (n17 > n3);
                                                                }
                                                                stringArray[12] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray80 = "Ts\u0003(*v`\u0012\u001c;Ts\u001d\u001a9|`:\u0016.u<\u0010\u00171wwS\u000b?ks\u001e[:p`\u0016\u0018*v`\n[3la\u0007[0vfS\u0019;9w\u001e\u000b*`2\u0000\u000f,p|\u0014".toCharArray();
                                                                n3 = 0;
                                                                int n81 = cArray80.length;
                                                                cArray14 = cArray80;
                                                                n15 = n81;
                                                                if (n81 <= 1) break block206;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block207;
                                                            }
                                                            do {
                                                                char[] cArray81 = cArray14;
                                                                char[] cArray82 = cArray14;
                                                                int n82 = n3;
                                                                while (true) {
                                                                    int n83;
                                                                    char c = cArray81[n82];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n83 = 25;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n83 = 18;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n83 = 115;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n83 = 123;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n83 = 94;
                                                                        }
                                                                    }
                                                                    cArray81[n82] = (char)(c ^ n83);
                                                                    ++n3;
                                                                    cArray14 = cArray82;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray82 = cArray14;
                                                                    n14 = n15;
                                                                    n82 = n15;
                                                                    cArray81 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[13] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray83 = "9>S".toCharArray();
                                                        n3 = 0;
                                                        int n84 = cArray83.length;
                                                        cArray12 = cArray83;
                                                        n13 = n84;
                                                        if (n84 <= 1) break block208;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block209;
                                                    }
                                                    do {
                                                        char[] cArray84 = cArray12;
                                                        char[] cArray85 = cArray12;
                                                        int n85 = n3;
                                                        while (true) {
                                                            int n86;
                                                            char c = cArray84[n85];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n86 = 25;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n86 = 18;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n86 = 115;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n86 = 123;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n86 = 94;
                                                                }
                                                            }
                                                            cArray84[n85] = (char)(c ^ n86);
                                                            ++n3;
                                                            cArray12 = cArray85;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray85 = cArray12;
                                                            n12 = n13;
                                                            n85 = n13;
                                                            cArray84 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[14] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray86 = "z}\u0006\u0017:9|\u001c\u000f~z`\u0016\u001a*|2\u0010\u00171wwS\u001489f\u001b\u001e~}{\u0001\u001e=m}\u0001\u0002".toCharArray();
                                                n3 = 0;
                                                int n87 = cArray86.length;
                                                cArray10 = cArray86;
                                                n11 = n87;
                                                if (n87 <= 1) break block210;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block211;
                                            }
                                            do {
                                                char[] cArray87 = cArray10;
                                                char[] cArray88 = cArray10;
                                                int n88 = n3;
                                                while (true) {
                                                    int n89;
                                                    char c = cArray87[n88];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n89 = 25;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n89 = 18;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n89 = 115;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n89 = 123;
                                                            break;
                                                        }
                                                        default: {
                                                            n89 = 94;
                                                        }
                                                    }
                                                    cArray87[n88] = (char)(c ^ n89);
                                                    ++n3;
                                                    cArray10 = cArray88;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray88 = cArray10;
                                                    n10 = n11;
                                                    n88 = n11;
                                                    cArray87 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[15] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray89 = "Ts\u0003(*v`\u0012\u001c;Ts\u001d\u001a9|`:\u0016.u<\u0010\u00171wwS\u000b?ks\u001e[3xb:\u001f~tg\u0000\u000f~w}\u0007[<|2\u0016\u0016.mkS\b*k{\u001d\u001c".toCharArray();
                                        n3 = 0;
                                        int n90 = cArray89.length;
                                        cArray8 = cArray89;
                                        n9 = n90;
                                        if (n90 <= 1) break block212;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block213;
                                    }
                                    do {
                                        char[] cArray90 = cArray8;
                                        char[] cArray91 = cArray8;
                                        int n91 = n3;
                                        while (true) {
                                            int n92;
                                            char c = cArray90[n91];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n92 = 25;
                                                    break;
                                                }
                                                case 1: {
                                                    n92 = 18;
                                                    break;
                                                }
                                                case 2: {
                                                    n92 = 115;
                                                    break;
                                                }
                                                case 3: {
                                                    n92 = 123;
                                                    break;
                                                }
                                                default: {
                                                    n92 = 94;
                                                }
                                            }
                                            cArray90[n91] = (char)(c ^ n92);
                                            ++n3;
                                            cArray8 = cArray91;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray91 = cArray8;
                                            n8 = n9;
                                            n91 = n9;
                                            cArray90 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[16] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray92 = "Ts\u0003(*v`\u0012\u001c;7s\u0017\u001f\u0018p~\u0016".toCharArray();
                                n3 = 0;
                                int n93 = cArray92.length;
                                cArray6 = cArray92;
                                n7 = n93;
                                if (n93 <= 1) break block214;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block215;
                            }
                            do {
                                char[] cArray93 = cArray6;
                                char[] cArray94 = cArray6;
                                int n94 = n3;
                                while (true) {
                                    int n95;
                                    char c = cArray93[n94];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n95 = 25;
                                            break;
                                        }
                                        case 1: {
                                            n95 = 18;
                                            break;
                                        }
                                        case 2: {
                                            n95 = 115;
                                            break;
                                        }
                                        case 3: {
                                            n95 = 123;
                                            break;
                                        }
                                        default: {
                                            n95 = 94;
                                        }
                                    }
                                    cArray93[n94] = (char)(c ^ n95);
                                    ++n3;
                                    cArray6 = cArray94;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray94 = cArray6;
                                    n6 = n7;
                                    n94 = n7;
                                    cArray93 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[17] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray95 = "z}\u0006\u0017:9|\u001c\u000f~z`\u0016\u001a*|2\u0006\u00157hg\u0016[0x\u007f\u0016W~{g\u0014[7w2\u0012\u00179v`\u001a\u000f6t".toCharArray();
                        n3 = 0;
                        int n96 = cArray95.length;
                        cArray4 = cArray95;
                        n5 = n96;
                        if (n96 <= 1) break block216;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block217;
                    }
                    do {
                        char[] cArray96 = cArray4;
                        char[] cArray97 = cArray4;
                        int n97 = n3;
                        while (true) {
                            int n98;
                            char c = cArray96[n97];
                            switch (n3 % 5) {
                                case 0: {
                                    n98 = 25;
                                    break;
                                }
                                case 1: {
                                    n98 = 18;
                                    break;
                                }
                                case 2: {
                                    n98 = 115;
                                    break;
                                }
                                case 3: {
                                    n98 = 123;
                                    break;
                                }
                                default: {
                                    n98 = 94;
                                }
                            }
                            cArray96[n97] = (char)(c ^ n98);
                            ++n3;
                            cArray4 = cArray97;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray97 = cArray4;
                            n4 = n5;
                            n97 = n5;
                            cArray96 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[18] = new String(cArray3).intern();
                var0 = null;
                char[] cArray98 = "7{\u0010\u0014".toCharArray();
                n3 = 0;
                int n99 = cArray98.length;
                cArray2 = cArray98;
                n2 = n99;
                if (n99 <= 1) break block218;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block219;
            }
            do {
                char[] cArray99 = cArray2;
                char[] cArray100 = cArray2;
                int n100 = n3;
                while (true) {
                    int n101;
                    char c = cArray99[n100];
                    switch (n3 % 5) {
                        case 0: {
                            n101 = 25;
                            break;
                        }
                        case 1: {
                            n101 = 18;
                            break;
                        }
                        case 2: {
                            n101 = 115;
                            break;
                        }
                        case 3: {
                            n101 = 123;
                            break;
                        }
                        default: {
                            n101 = 94;
                        }
                    }
                    cArray99[n100] = (char)(c ^ n101);
                    ++n3;
                    cArray2 = cArray100;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray100 = cArray2;
                    n = n2;
                    n100 = n2;
                    cArray99 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[19] = new String(cArray).intern();
        z = stringArray;
        a = Logger.getLogger(MapStorageImpl.class);
        b = new Random();
    }
}

